/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.AndCondition;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.EqualCondition;
import com.sap.sapdb.oltptest.join.simulation.FullOuterJoin;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class FullOuterJoinTest
extends TestCase {
    final int c_maxColumns = 1;
    final int c_rowCount = 3;
    private AbstractList tableList;
    private DatabaseTable table2;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(3);
        this.tableList.add(this.createTable(2, 7));
        this.tableList.add(this.createTable(3, 5));
        this.tableList.add(this.createTable(1, 10));
        Iterator it = this.tableList.iterator();
        while (it.hasNext()) {
            DatabaseTable databaseTable = (DatabaseTable)it.next();
        }
    }

    protected DatabaseTable createTable(int columnCount, int rowCount) {
        int i;
        DatabaseTable table = new DatabaseTable();
        for (i = 1; i <= columnCount; ++i) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
        }
        for (i = 1; i <= rowCount; ++i) {
            TableRow row = new TableRow(table);
            for (int j = 1; j <= columnCount; ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            table.insert(row);
        }
        return table;
    }

    private DatabaseTable getTable(int index) {
        return (DatabaseTable)this.tableList.get(index);
    }

    public void testFullOuterJoin() {
        System.out.println("FullOuterJoinTables");
        EqualCondition eq = new EqualCondition(new DbResultTable(this.getTable(0)), 1, new DbResultTable(this.getTable(1)), 2);
        FullOuterJoin bf = new FullOuterJoin(new DbResultTable(this.getTable(0)), new DbResultTable(this.getTable(1)), eq);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
        Assert.assertEquals((int)7, (int)joinedTable.getRowCount());
    }

    public void testFullOuterJoin1() {
        System.out.println("FullOuterJoinTables-1");
        EqualCondition eq = new EqualCondition(new DbResultTable(this.getTable(0)), 1, new DbResultTable(this.getTable(1)), 1);
        EqualCondition eq1 = new EqualCondition(new DbResultTable(this.getTable(0)), 2, new DbResultTable(this.getTable(1)), 2);
        AndCondition and1 = new AndCondition(eq, eq1);
        FullOuterJoin bf = new FullOuterJoin(new DbResultTable(this.getTable(0)), new DbResultTable(this.getTable(1)), and1);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
        Assert.assertEquals((int)7, (int)joinedTable.getRowCount());
    }

    public void testTwoLevelJoin() {
        System.out.println("FullOuterJoinTables: two level join");
        EqualCondition eq = new EqualCondition(new DbResultTable(this.getTable(0)), 1, new DbResultTable(this.getTable(1)), 2);
        FullOuterJoin jo1 = new FullOuterJoin(new DbResultTable(this.getTable(0)), new DbResultTable(this.getTable(1)), eq);
        eq = new EqualCondition(new DbResultTable(this.getTable(0)), 2, new DbResultTable(this.getTable(2)), 1);
        FullOuterJoin jo2 = new FullOuterJoin(jo1, new DbResultTable(this.getTable(2)), eq);
        DatabaseTable joinedTable = new DatabaseTable(jo2.getResultTableDefinition());
        while (jo2.hasNext()) {
            TableRow row = jo2.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
        Assert.assertEquals((int)10, (int)joinedTable.getRowCount());
    }
}

