/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.ExistsPredicate;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ExistsPredicateTest
extends TestCase {
    private DatabaseTable dummyTable;

    protected void setUp() throws Exception {
        super.setUp();
        this.dummyTable = new DatabaseTable();
        this.dummyTable.addColumn(new IntegerColumn());
    }

    public void testExistsPredicateIsFalse() {
        System.out.println("ExistsPredicate: isFalse");
        DatabaseTable table = new DatabaseTable();
        table.addColumn(new IntegerColumn());
        DbResultTable resultTable = new DbResultTable(table);
        TableRow dummyRow = new TableRow(this.dummyTable);
        ExistsPredicate ep = new ExistsPredicate(resultTable);
        ep.prepare(null);
        Assert.assertFalse((boolean)ep.isTrue(dummyRow));
        Assert.assertTrue((boolean)ep.isFalse(dummyRow));
    }

    public void testExistsPredicateIsTrue() {
        System.out.println("ExistsPredicate: isTrue");
        DatabaseTable table = new DatabaseTable();
        table.addColumn(new IntegerColumn());
        TableRow dummyRow = new TableRow(this.dummyTable);
        for (int i = 1; i <= dummyRow.getColumnCount(); ++i) {
            dummyRow.setValue(i, new IntegerCell(1));
        }
        table.insert(dummyRow);
        dummyRow = new TableRow(this.dummyTable);
        ExistsPredicate ep = new ExistsPredicate(new DbResultTable(table));
        ep.prepare(null);
        Assert.assertFalse((boolean)ep.isFalse(dummyRow));
        Assert.assertTrue((boolean)ep.isTrue(dummyRow));
    }
}

