/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.EqualCondition;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.SimpleJoinedTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class EqualConditionTest
extends TestCase {
    final int c_maxColumns = 15;
    final int c_rowCount = 20;
    private AbstractList tableList;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(2);
        this.tableList.add(this.createTable());
        this.tableList.add(this.createTable());
    }

    protected DatabaseTable createTable() {
        int i;
        DatabaseTable table = new DatabaseTable();
        for (i = 1; i <= this.c_maxColumns; ++i) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
        }
        for (i = 1; i <= this.c_rowCount; ++i) {
            TableRow row = new TableRow(table);
            for (int j = 1; j <= 15; ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            table.insert(row);
        }
        return table;
    }

    public void testIsTrue() {
        System.out.println("EqualConditionTest: isTrue");
        Iterator leftRowIt = ((DatabaseTable)this.tableList.get(0)).rowIterator();
        Iterator rightRowIt = ((DatabaseTable)this.tableList.get(1)).rowIterator();
        DbResultTable rt1 = new DbResultTable((DatabaseTable)this.tableList.get(0));
        DbResultTable rt2 = new DbResultTable((DatabaseTable)this.tableList.get(1));
        ArrayList<DbResultTable> resultTableList = new ArrayList<DbResultTable>(2);
        ((AbstractList)resultTableList).add(rt1);
        ((AbstractList)resultTableList).add(rt2);
        SimpleJoinedTable resultTable = new SimpleJoinedTable(resultTableList);
        TableRow curRow = new TableRow(resultTable);
        while (leftRowIt.hasNext() && rightRowIt.hasNext()) {
            TableRow leftRow = (TableRow)leftRowIt.next();
            TableRow rightRow = (TableRow)rightRowIt.next();
            for (int i = 1; i <= this.c_maxColumns; ++i) {
                for (int j = 1; j <= this.c_maxColumns; ++j) {
                    EqualCondition eq = new EqualCondition(rt1, i, rt2, j);
                    eq.prepare(resultTable);
                    TableRow.mergeRows(curRow, leftRow, rightRow);
                    if (i == j) {
                        Assert.assertTrue((boolean)eq.isTrue(curRow));
                        continue;
                    }
                    Assert.assertFalse((boolean)eq.isTrue(curRow));
                }
            }
        }
    }

    public void testIsFalse() {
        System.out.println("EqualConditionTest: isFalse");
        Iterator leftRowIt = ((DatabaseTable)this.tableList.get(0)).rowIterator();
        Iterator rightRowIt = ((DatabaseTable)this.tableList.get(1)).rowIterator();
        ArrayList<DbResultTable> resultTableList = new ArrayList<DbResultTable>(2);
        DbResultTable rt1 = new DbResultTable((DatabaseTable)this.tableList.get(0));
        DbResultTable rt2 = new DbResultTable((DatabaseTable)this.tableList.get(1));
        ((AbstractList)resultTableList).add(rt1);
        ((AbstractList)resultTableList).add(rt2);
        SimpleJoinedTable resultTable = new SimpleJoinedTable(resultTableList);
        TableRow curRow = new TableRow(resultTable);
        while (leftRowIt.hasNext() && rightRowIt.hasNext()) {
            TableRow leftRow = (TableRow)leftRowIt.next();
            TableRow rightRow = (TableRow)rightRowIt.next();
            for (int i = 1; i <= this.c_maxColumns; ++i) {
                for (int j = 1; j <= this.c_maxColumns; ++j) {
                    EqualCondition eq = new EqualCondition(rt1, i, rt2, j);
                    eq.prepare(resultTable);
                    TableRow.mergeRows(curRow, leftRow, rightRow);
                    if (i == j) {
                        Assert.assertFalse((boolean)eq.isFalse(curRow));
                        continue;
                    }
                    Assert.assertTrue((boolean)eq.isFalse(curRow));
                }
            }
        }
    }
}

