/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.CrossProductIterator;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;

public class CrossProductIteratorTest
extends TestCase {
    AbstractList tableList;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(4);
        this.tableList.add(this.createTable(2, 7));
        this.tableList.add(this.createTable(3, 5));
        this.tableList.add(this.createTable(2, 7));
        this.tableList.add(this.createTable(3, 5));
    }

    protected DatabaseTable createTable(int columnCount, int rowCount) {
        int i;
        DatabaseTable table = new DatabaseTable();
        for (i = 1; i <= columnCount; ++i) {
            IntegerColumn c = new IntegerColumn();
            table.addColumn(c);
        }
        for (i = 1; i <= rowCount; ++i) {
            TableRow row = new TableRow(table);
            for (int j = 1; j <= columnCount; ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            table.insert(row);
        }
        return table;
    }

    public void testOneTable() {
        System.out.println("single table");
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>();
        ((AbstractList)tableList).add(new DbResultTable((DatabaseTable)this.tableList.get(0)));
        CrossProductIterator it = new CrossProductIterator(tableList);
        while (it.hasNext()) {
            TableRow tableRow = (TableRow)it.next();
        }
    }

    public void testMultipleTables() {
        System.out.println("multiple tables");
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>(this.tableList.size());
        Iterator tabIt = this.tableList.iterator();
        while (tabIt.hasNext()) {
            ((AbstractList)tableList).add(new DbResultTable((DatabaseTable)tabIt.next()));
        }
        CrossProductIterator it = new CrossProductIterator(tableList);
        while (it.hasNext()) {
            TableRow row = (TableRow)it.next();
        }
    }
}

