/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.AndCondition;
import com.sap.sapdb.oltptest.join.simulation.BruteForceJoin;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.EqualCondition;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.OrCondition;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.unittests.TestHelpers;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class BruteForceJoinTest
extends TestCase {
    final int c_maxColumns = 1;
    final int c_rowCount = 3;
    private AbstractList tableList;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(3);
        this.tableList.add(TestHelpers.createTable(2, 7));
        this.tableList.add(TestHelpers.createTable(3, 5));
        this.tableList.add(TestHelpers.createTable(1, 10));
        Iterator it = this.tableList.iterator();
        while (it.hasNext()) {
            DatabaseTable databaseTable = (DatabaseTable)it.next();
        }
    }

    private DatabaseTable getTable(int index) {
        return (DatabaseTable)this.tableList.get(index);
    }

    public void testBruteForceJoin() {
        System.out.println("BruteForceJoinTables");
        EqualCondition eq = new EqualCondition(this.getTable(0), 1, this.getTable(1), 2);
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>(2);
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(0)));
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(1)));
        BruteForceJoin bf = new BruteForceJoin(tableList, eq);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        Assert.assertEquals((int)5, (int)joinedTable.getRowCount());
    }

    public void testBruteForceJoin1() {
        System.out.println("BruteForceJoinTables-1");
        EqualCondition eq = new EqualCondition(this.getTable(0), 1, this.getTable(1), 1);
        EqualCondition eq1 = new EqualCondition(this.getTable(0), 2, this.getTable(1), 2);
        AndCondition and1 = new AndCondition(eq, eq1);
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>(2);
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(0)));
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(1)));
        BruteForceJoin bf = new BruteForceJoin(tableList, and1);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        Assert.assertEquals((int)5, (int)joinedTable.getRowCount());
    }

    public void testBruteForceJoin2() {
        System.out.println("BruteForceJoinTables-2");
        EqualCondition eq = new EqualCondition(this.getTable(0), 1, this.getTable(1), 2);
        EqualCondition eq1 = new EqualCondition(this.getTable(0), 2, this.getTable(1), 3);
        EqualCondition eq2 = new EqualCondition(this.getTable(2), 1, this.getTable(0), 1);
        AndCondition and1 = new AndCondition(eq, eq1);
        AndCondition and2 = new AndCondition(and1, eq2);
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>(3);
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(0)));
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(1)));
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(2)));
        BruteForceJoin bf = new BruteForceJoin(tableList, and2);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        Assert.assertEquals((int)5, (int)joinedTable.getRowCount());
    }

    public void testBruteForceJoin3() {
        System.out.println("BruteForceJoinTables-3");
        EqualCondition eq = new EqualCondition(this.getTable(0), 1, this.getTable(1), 2);
        EqualCondition eq1 = new EqualCondition(this.getTable(0), 2, this.getTable(1), 3);
        EqualCondition eq2 = new EqualCondition(this.getTable(2), 1, this.getTable(0), 1);
        AndCondition and1 = new AndCondition(eq, eq1);
        OrCondition or1 = new OrCondition(and1, eq2);
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>(3);
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(0)));
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(1)));
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(2)));
        BruteForceJoin bf = new BruteForceJoin(tableList, or1);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        Assert.assertEquals((int)80, (int)joinedTable.getRowCount());
    }

    public void testBruteForceJoinSingleTable() {
        System.out.println("BruteForceJoinTables: single table");
        EqualCondition eq = new EqualCondition(this.getTable(0), 1, this.getTable(0), 1);
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>(1);
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(0)));
        BruteForceJoin bf = new BruteForceJoin(tableList, eq);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
    }

    public void testBruteForceJoinEmptyTable() {
        System.out.println("BruteForceJoinTables: empty table");
        ArrayList<DbResultTable> tableList = new ArrayList<DbResultTable>(1);
        DatabaseTable emptyTable0 = new DatabaseTable();
        emptyTable0.addColumn(new IntegerColumn());
        DatabaseTable emptyTable1 = new DatabaseTable();
        emptyTable1.addColumn(new IntegerColumn());
        ((AbstractList)tableList).add(new DbResultTable(emptyTable0));
        ((AbstractList)tableList).add(new DbResultTable(emptyTable1));
        EqualCondition eq = new EqualCondition(emptyTable0, 1, emptyTable1, 1);
        BruteForceJoin bf = new BruteForceJoin(tableList, eq);
        DatabaseTable joinedTable = new DatabaseTable(bf.getResultTableDefinition());
        while (bf.hasNext()) {
            TableRow row = bf.next();
            joinedTable.insert(row);
        }
        joinedTable.dump();
    }

    public void testExample() {
        int j;
        int i;
        System.out.println("TestExample");
        DatabaseTable t1 = new DatabaseTable("TestTable100");
        DatabaseTable t2 = new DatabaseTable("TestTable200");
        t1.addColumn(new IntegerColumn("COL1"));
        t1.addColumn(new IntegerColumn("COL2"));
        t2.addColumn(new IntegerColumn("COL1"));
        t2.addColumn(new IntegerColumn("COL2"));
        int rowCount = 5;
        TableRow row = new TableRow(t1);
        for (i = 1; i <= rowCount; ++i) {
            for (j = 1; j <= t1.getColumnCount(); ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            t1.insert(row);
        }
        rowCount = 3;
        row = new TableRow(t2);
        for (i = 1; i <= rowCount; ++i) {
            for (j = 1; j <= t1.getColumnCount(); ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            t2.insert(row);
        }
        EqualCondition eq = new EqualCondition(t1, 1, t2, 2);
        DbResultTable rt1 = new DbResultTable(t1);
        DbResultTable rt2 = new DbResultTable(t2);
        ArrayList<ResultTable> tableList = new ArrayList<ResultTable>(2);
        ((AbstractList)tableList).add(rt1);
        ((AbstractList)tableList).add(rt2);
        BruteForceJoin bf = new BruteForceJoin(tableList, eq);
        t1.dump();
        t2.dump();
        eq = new EqualCondition(this.getTable(0), 1, t1, 1);
        ((AbstractList)tableList).clear();
        ((AbstractList)tableList).add(new DbResultTable(this.getTable(0)));
        ((AbstractList)tableList).add(bf);
        BruteForceJoin bf2 = new BruteForceJoin(tableList, eq);
        MaterializeResultOperator rop = new MaterializeResultOperator(bf2);
        DatabaseTable resultTable = rop.getResultTable();
        resultTable.dump();
        rop.dumpStructure();
        bf2.resetIterator();
        DatabaseTable resultTable1 = new DatabaseTable(bf2.getResultTableDefinition());
        while (bf2.hasNext()) {
            TableRow resultRow = bf2.next();
            resultTable1.insert(resultRow);
        }
        resultTable1.dump();
    }

    public void testTwoLevel() {
        int j;
        int i;
        System.out.println("InnerJoin: two level");
        DatabaseTable t1 = new DatabaseTable("TestTable100");
        DatabaseTable t2 = new DatabaseTable("TestTable200");
        DatabaseTable t3 = new DatabaseTable("TestTable300");
        t1.addColumn(new IntegerColumn("COL1"));
        t1.addColumn(new IntegerColumn("COL2"));
        t2.addColumn(new IntegerColumn("COL1"));
        t2.addColumn(new IntegerColumn("COL2"));
        t3.addColumn(new IntegerColumn("COL1"));
        int rowCount = 5;
        TableRow row = new TableRow(t1);
        for (i = 1; i <= rowCount; ++i) {
            for (j = 1; j <= t1.getColumnCount(); ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            t1.insert(row);
        }
        rowCount = 3;
        row = new TableRow(t2);
        for (i = 1; i <= rowCount; ++i) {
            for (j = 1; j <= t1.getColumnCount(); ++j) {
                row.setValue(j, new IntegerCell(i + j));
            }
            t2.insert(row);
        }
        rowCount = 4;
        row = new TableRow(t3);
        for (i = 1; i <= rowCount; ++i) {
            row.setValue(1, new IntegerCell(i));
            t3.insert(row);
        }
        EqualCondition eq = new EqualCondition(t2, 1, t3, 1);
        DbResultTable rt1 = new DbResultTable(t1);
        DbResultTable rt2 = new DbResultTable(t2);
        DbResultTable rt3 = new DbResultTable(t3);
        ArrayList<ResultTable> tableList = new ArrayList<ResultTable>(2);
        ((AbstractList)tableList).add(rt2);
        ((AbstractList)tableList).add(rt3);
        BruteForceJoin bf = new BruteForceJoin(tableList, eq);
        eq = new EqualCondition(t1, 1, t2, 1);
        ((AbstractList)tableList).clear();
        ((AbstractList)tableList).add(rt1);
        ((AbstractList)tableList).add(bf);
        BruteForceJoin bf2 = new BruteForceJoin(tableList, eq);
        MaterializeResultOperator rop = new MaterializeResultOperator(bf2);
        DatabaseTable resultTable = rop.getResultTable();
        DatabaseTable verifyTable = new DatabaseTable(resultTable);
        row = new TableRow(verifyTable);
        row.setValue(1, new IntegerCell(2));
        row.setValue(2, new IntegerCell(3));
        row.setValue(3, new IntegerCell(2));
        row.setValue(4, new IntegerCell(3));
        row.setValue(5, new IntegerCell(2));
        verifyTable.insert(row);
        row.setValue(1, new IntegerCell(3));
        row.setValue(2, new IntegerCell(4));
        row.setValue(3, new IntegerCell(3));
        row.setValue(4, new IntegerCell(4));
        row.setValue(5, new IntegerCell(3));
        verifyTable.insert(row);
        row.setValue(1, new IntegerCell(4));
        row.setValue(2, new IntegerCell(5));
        row.setValue(3, new IntegerCell(4));
        row.setValue(4, new IntegerCell(5));
        row.setValue(5, new IntegerCell(4));
        verifyTable.insert(row);
        Assert.assertTrue((boolean)resultTable.sortAndCompare(verifyTable, true));
    }
}

