/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.ColumnSortInfo;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.SortInfo;
import com.sap.sapdb.oltptest.join.simulation.SortTableComparator;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.Iterator;

public class SortOperator
extends ResultTable {
    private ResultTable inputTable;
    private SortInfo sortInfo;
    private boolean initialized = false;
    private DatabaseTable sortedTable;
    private DbResultTable outputTable;

    public SortOperator(ResultTable inputTable) {
        super(inputTable);
        this.inputTable = inputTable;
        this.sortedTable = new DatabaseTable(inputTable);
        this.outputTable = new DbResultTable(this.sortedTable);
        this.sortInfo = null;
    }

    public SortOperator(ResultTable inputTable, SortInfo sortInfo) {
        this(inputTable);
        this.sortInfo = sortInfo;
    }

    public boolean hasNext() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.outputTable.hasNext();
    }

    public TableRow next() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.outputTable.next();
    }

    public void resetIterator() {
        if (!this.initialized) {
            this.initialize();
        } else {
            this.outputTable.resetIterator();
        }
    }

    private void initialize() {
        while (this.inputTable.hasNext()) {
            this.sortedTable.insert(this.inputTable.next());
        }
        if (this.sortInfo == null) {
            this.sortedTable.sort();
        } else {
            this.sortedTable.sort(new SortTableComparator(this.sortInfo));
        }
        this.outputTable.resetIterator();
        this.initialized = true;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "SortOperator " + this.getTableName());
        Iterator it = this.sortInfo.columnIterator();
        while (it.hasNext()) {
            ColumnSortInfo c = (ColumnSortInfo)it.next();
            s.print(indentStr + "   Column " + c.getColumnNumber());
            if (c.getSortOrder() == 1) {
                s.println(" ascending");
                continue;
            }
            s.println(" descending");
        }
        s.println(indentStr + "  Table");
        this.inputTable.dumpStructure(s, indentStr + "    ");
    }
}

