/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.Assertion;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.SetFunction;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SetFunctionFilter
extends ResultTable {
    private ResultTable inputTable;
    private List functionList;
    private TableRow currentRow;
    private boolean initialized = false;

    public SetFunctionFilter(ResultTable inputTable) {
        super(inputTable);
        this.inputTable = inputTable;
        this.currentRow = null;
        this.functionList = new ArrayList(inputTable.getColumnCount());
    }

    public void addFunction(SetFunction setFunction, int outputColumnNumber) {
        Iterator iter = this.functionList.iterator();
        while (iter.hasNext()) {
            SetFunctionInfo element = (SetFunctionInfo)iter.next();
            Assertion.assertTrue(element.getOutputColumnNumber() != outputColumnNumber);
        }
        this.functionList.add(new SetFunctionInfo(setFunction, outputColumnNumber));
    }

    public boolean hasNext() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.currentRow != null;
    }

    public TableRow next() {
        if (!this.initialized) {
            this.initialize();
        }
        TableRow resultRow = this.currentRow;
        this.currentRow = null;
        return resultRow;
    }

    private void initialize() {
        this.initialized = true;
        this.verifyAllOutputRowsSet();
        while (this.inputTable.hasNext()) {
            this.currentRow = this.inputTable.next();
            this.applySetFunctions(this.currentRow);
        }
        if (this.currentRow != null) {
            this.getSetFunctionResults(this.currentRow);
        }
    }

    private void verifyAllOutputRowsSet() {
        for (int i = 1; i <= this.tableDef.getColumnCount(); ++i) {
            Iterator funcIt = this.functionList.iterator();
            boolean found = false;
            while (funcIt.hasNext()) {
                SetFunctionInfo funcInfo = (SetFunctionInfo)funcIt.next();
                if (funcInfo.getOutputColumnNumber() != i) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new NoSuchElementException("all output columns must have aggregate defined: " + i);
        }
    }

    private void applySetFunctions(TableRow row) {
        Iterator setIt = this.functionList.iterator();
        while (setIt.hasNext()) {
            SetFunction setFunc = ((SetFunctionInfo)setIt.next()).getFunction();
            setFunc.evaluate(row);
        }
    }

    private void getSetFunctionResults(TableRow outputRow) {
        Iterator setIt = this.functionList.iterator();
        while (setIt.hasNext()) {
            SetFunctionInfo funcInfo = (SetFunctionInfo)setIt.next();
            SetFunction setFunc = funcInfo.getFunction();
            outputRow.setValue(funcInfo.getOutputColumnNumber(), setFunc.getResult());
        }
    }

    public void resetIterator() {
        this.inputTable.resetIterator();
        this.initialized = false;
        Iterator it = this.functionList.iterator();
        while (it.hasNext()) {
            SetFunctionInfo f = (SetFunctionInfo)it.next();
            SetFunction sf = f.getFunction();
            sf.reset();
        }
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "SetFunctionFilterOperator");
        s.println(indentStr + "  input table:");
        this.inputTable.dumpStructure(s, indentStr + "    ");
        s.println(indentStr + "  set functions:");
        Iterator it = this.functionList.iterator();
        while (it.hasNext()) {
            SetFunctionInfo fi = (SetFunctionInfo)it.next();
            s.println(indentStr + "   outputColumn: " + fi.getOutputColumnNumber());
            fi.getFunction().dumpStructure(s, indentStr + "    ");
        }
    }

    class SetFunctionInfo {
        private SetFunction function;
        private int outputColumnNumber;

        public SetFunctionInfo(SetFunction function, int outputColumnNumber) {
            this.function = function;
            this.outputColumnNumber = outputColumnNumber;
        }

        public int getOutputColumnNumber() {
            return this.outputColumnNumber;
        }

        public SetFunction getFunction() {
            return this.function;
        }
    }
}

