/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.Column;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DuplicateTableException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class SecondJoin {
    private AbstractList tableList;

    public SecondJoin(int expectedTableCount) {
        this.tableList = new ArrayList(expectedTableCount);
    }

    public void addTable(DatabaseTable table) {
        if (this.tableList.indexOf(table) != -1) {
            throw new DuplicateTableException(table.getTableName());
        }
        this.tableList.add(table);
    }

    public DatabaseTable execute() {
        DatabaseTable resultTable = this.buildResultTable();
        return resultTable;
    }

    private DatabaseTable buildResultTable() {
        DatabaseTable resultTable = new DatabaseTable();
        Iterator tableIt = this.tableList.iterator();
        while (tableIt.hasNext()) {
            this.addInputTable(resultTable, (DatabaseTable)tableIt.next());
        }
        return resultTable;
    }

    private void addInputTable(DatabaseTable resultTable, DatabaseTable inputTable) {
        Iterator it = inputTable.columnIterator();
        while (it.hasNext()) {
            Column originalCol = (Column)it.next();
            Column newCol = (Column)originalCol.clone();
            newCol.setColumnName(inputTable.getTableName() + "." + originalCol.getColumnName());
            resultTable.addColumn(newCol);
        }
    }
}

