/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.OuterJoin;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class RightOuterJoin
extends OuterJoin {
    private ResultTable leftTable;
    private ResultTable rightTable;
    private AbstractCondition qualification;
    private TableRow currentRow;
    private TableRow nullLeftRow;
    private boolean rightRowReady = false;
    private boolean rowAlreadyQualified;
    private boolean valueReady = false;

    public RightOuterJoin(ResultTable leftTable, ResultTable rightTable, AbstractCondition qualification) {
        super(leftTable, rightTable);
        this.leftTable = leftTable;
        this.rightTable = rightTable;
        this.qualification = qualification;
        this.qualification.prepare(this);
        this.currentRow = new TableRow(this);
        this.nullLeftRow = this.createNullRow(this.leftTable.getTableDefinition());
        this.resetIterator();
    }

    public boolean hasNext() {
        if (this.valueReady) {
            return true;
        }
        if (!this.rightRowReady) {
            if (!this.rightTable.hasNext()) {
                return false;
            }
            this.rightRowReady = true;
            this.currentRow.setValues(this.leftTable.getColumnCount() + 1, this.rightTable.next());
        }
        while (true) {
            boolean rowFound = false;
            while (this.leftTable.hasNext()) {
                this.currentRow.setValues(1, this.leftTable.next());
                if (!this.qualification.isTrue(this.currentRow)) continue;
                this.rowAlreadyQualified = true;
                this.valueReady = true;
                return true;
            }
            if (!this.rowAlreadyQualified) {
                this.currentRow.setValues(1, this.nullLeftRow);
                this.rowAlreadyQualified = true;
                this.valueReady = true;
                return true;
            }
            if (!this.rightTable.hasNext()) {
                this.rightRowReady = false;
                return false;
            }
            this.currentRow.setValues(this.leftTable.getColumnCount() + 1, this.rightTable.next());
            this.leftTable.resetIterator();
            this.rowAlreadyQualified = false;
        }
    }

    public TableRow next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        return this.currentRow;
    }

    public void resetIterator() {
        this.rightTable.resetIterator();
        this.leftTable.resetIterator();
        this.rightRowReady = false;
        this.rowAlreadyQualified = false;
        this.valueReady = false;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "RightOuterJoinOperator " + this.getTableName());
        s.println(indentStr + "  Qualification:");
        this.qualification.dumpStructure(s, indentStr + "    ");
        s.println(indentStr + "  Input:");
        this.leftTable.dumpStructure(s, indentStr + "    ");
        this.rightTable.dumpStructure(s, indentStr + "    ");
    }
}

