/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class QualificationFilter
extends ResultTable {
    private ResultTable inputTable;
    private AbstractCondition qualification;
    private boolean valueReady = false;
    private boolean cycleComplete = false;
    private TableRow currentRow;

    public QualificationFilter(ResultTable inputTable, AbstractCondition qualification) {
        super(inputTable);
        this.inputTable = inputTable;
        this.qualification = qualification;
        this.qualification.prepare(this);
    }

    public boolean hasNext() {
        if (this.valueReady) {
            return true;
        }
        if (this.cycleComplete) {
            return false;
        }
        while (this.inputTable.hasNext()) {
            this.currentRow = this.inputTable.next();
            if (!this.qualification.isTrue(this.currentRow)) continue;
            this.valueReady = true;
            break;
        }
        if (!this.valueReady) {
            this.cycleComplete = true;
        }
        return this.valueReady;
    }

    public TableRow next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        return this.currentRow;
    }

    public void resetIterator() {
        this.inputTable.resetIterator();
        this.valueReady = false;
        this.cycleComplete = false;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "QualificationFilter");
        s.println(indentStr + "  Qualification:");
        this.qualification.dumpStructure(s, indentStr + "    ");
        s.println(indentStr + "  Table:");
        this.inputTable.dumpStructure(s, indentStr + "    ");
    }
}

