/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.OuterJoin;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class LeftOuterJoin
extends OuterJoin {
    private ResultTable leftTable;
    private ResultTable rightTable;
    private AbstractCondition qualification;
    private TableRow currentRow;
    private TableRow nullRightRow;
    private boolean rowAlreadyQualified;
    private boolean leftRowReady = false;
    private boolean valueReady = false;

    public LeftOuterJoin(ResultTable leftTable, ResultTable rightTable, AbstractCondition qualification) {
        super(leftTable, rightTable);
        this.leftTable = leftTable;
        this.rightTable = rightTable;
        this.qualification = qualification;
        this.qualification.prepare(this);
        this.currentRow = new TableRow(this);
        this.nullRightRow = this.createNullRow(this.rightTable.getTableDefinition());
        this.resetIterator();
    }

    public boolean hasNext() {
        if (this.valueReady) {
            return true;
        }
        if (!this.leftRowReady) {
            if (!this.leftTable.hasNext()) {
                return false;
            }
            this.leftRowReady = true;
            this.currentRow.setValues(1, this.leftTable.next());
        }
        while (true) {
            boolean rowFound = false;
            while (this.rightTable.hasNext()) {
                this.currentRow.setValues(this.leftTable.getColumnCount() + 1, this.rightTable.next());
                if (!this.qualification.isTrue(this.currentRow)) continue;
                this.rowAlreadyQualified = true;
                this.valueReady = true;
                return true;
            }
            if (!this.rowAlreadyQualified) {
                this.currentRow.setValues(this.leftTable.getColumnCount() + 1, this.nullRightRow);
                this.rowAlreadyQualified = true;
                this.valueReady = true;
                return true;
            }
            if (!this.leftTable.hasNext()) {
                this.leftRowReady = false;
                return false;
            }
            this.currentRow.setValues(1, this.leftTable.next());
            this.rightTable.resetIterator();
            this.rowAlreadyQualified = false;
        }
    }

    public TableRow next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        return this.currentRow;
    }

    public void resetIterator() {
        this.leftTable.resetIterator();
        this.rightTable.resetIterator();
        this.leftRowReady = false;
        this.rowAlreadyQualified = false;
        this.valueReady = false;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "LeftOuterJoinOperator " + this.getTableName());
        s.println(indentStr + "  Qualification:");
        this.qualification.dumpStructure(s, indentStr + "    ");
        s.println(indentStr + "  Input:");
        this.leftTable.dumpStructure(s, indentStr + "    ");
        this.rightTable.dumpStructure(s, indentStr + "    ");
    }
}

