/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.ColumnSortInfo;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.SetFunction;
import com.sap.sapdb.oltptest.join.simulation.SortInfo;
import com.sap.sapdb.oltptest.join.simulation.SortOperator;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class GroupByOperator
extends ResultTable {
    private ResultTable inputTable;
    private List columnNoList;
    private List setFunctionList;
    private TableRow groupRow;
    private TableRow currentRow;
    private SortInfo sortInfo = new SortInfo();

    public GroupByOperator(ResultTable inputTable, List groupByColumnList) {
        super(inputTable);
        Iterator it = groupByColumnList.iterator();
        while (it.hasNext()) {
            int columnNo = (Integer)it.next();
            this.sortInfo.addColumn(columnNo, 1);
        }
        this.inputTable = new SortOperator(inputTable, this.sortInfo);
        this.columnNoList = groupByColumnList;
        this.setFunctionList = new ArrayList();
        this.groupRow = null;
        this.currentRow = null;
    }

    public boolean hasNext() {
        if (this.groupRow != null) {
            return true;
        }
        if (!this.inputTable.hasNext()) {
            if (this.currentRow != null) {
                this.newGroupRow(this.currentRow);
                this.currentRow = null;
                return true;
            }
            return false;
        }
        while (this.inputTable.hasNext()) {
            if (this.groupRow == null && this.currentRow != null) {
                this.newGroupRow(this.currentRow);
            }
            this.currentRow = this.inputTable.next();
            if (this.groupRow == null) {
                this.newGroupRow(this.currentRow);
                continue;
            }
            Iterator colIt = this.sortInfo.columnIterator();
            while (colIt.hasNext()) {
                int colNo = ((ColumnSortInfo)colIt.next()).getColumnNumber();
                if (this.currentRow.getValue(colNo).isEqual(this.groupRow.getValue(colNo))) continue;
                return true;
            }
            this.applySetFunctions();
        }
        this.currentRow = null;
        return true;
    }

    private void newGroupRow(TableRow row) {
        this.groupRow = (TableRow)this.currentRow.clone();
        this.resetSetFunctions();
        this.applySetFunctions();
    }

    public TableRow next() {
        if (this.groupRow == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        TableRow returnRow = this.groupRow;
        this.getSetFunctionResults(returnRow);
        this.groupRow = null;
        return returnRow;
    }

    public void resetIterator() {
        this.inputTable.resetIterator();
        this.resetSetFunctions();
        this.groupRow = null;
        this.currentRow = null;
    }

    public void dumpStructure(String indentStr) {
        System.out.println(indentStr + "Table " + this.getTableName());
    }

    public void addSetFunction(SetFunction setFunction, int outputColumn) {
        setFunction.prepare(this);
        this.setFunctionList.add(new SetFunctionInfo(setFunction, outputColumn));
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "GroupByOperator");
        Iterator setIt = this.setFunctionList.iterator();
        while (setIt.hasNext()) {
            SetFunctionInfo funcInfo = (SetFunctionInfo)setIt.next();
            SetFunction setFunc = funcInfo.getSetFunction();
            s.println(indentStr + "  SetFunction:");
            s.println(indentStr + "    " + "outputColumn: " + funcInfo.getOutputColumnNumber());
        }
    }

    private void applySetFunctions() {
        Iterator setIt = this.setFunctionList.iterator();
        while (setIt.hasNext()) {
            SetFunction setFunc = ((SetFunctionInfo)setIt.next()).getSetFunction();
            setFunc.evaluate(this.currentRow);
        }
    }

    private void getSetFunctionResults(TableRow outputRow) {
        Iterator setIt = this.setFunctionList.iterator();
        while (setIt.hasNext()) {
            SetFunctionInfo funcInfo = (SetFunctionInfo)setIt.next();
            SetFunction setFunc = funcInfo.getSetFunction();
            outputRow.setValue(funcInfo.getOutputColumnNumber(), setFunc.getResult());
        }
    }

    private void resetSetFunctions() {
        Iterator setIt = this.setFunctionList.iterator();
        while (setIt.hasNext()) {
            SetFunction setFunc = ((SetFunctionInfo)setIt.next()).getSetFunction();
            setFunc.reset();
        }
    }

    private class SetFunctionInfo {
        private SetFunction func;
        private int outputColumn;

        public SetFunctionInfo(SetFunction function, int outputColumnNumber) {
            this.func = function;
            this.outputColumn = outputColumnNumber;
        }

        public SetFunction getSetFunction() {
            return this.func;
        }

        public int getOutputColumnNumber() {
            return this.outputColumn;
        }
    }
}

