/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.Assertion;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerColumn;
import com.sap.sapdb.oltptest.join.simulation.JoinedTable;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.SimpleJoinedTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableDefinition;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CorrelatedSubqueryOperator
extends JoinedTable {
    private ResultTable inputTable;
    private List subqueries;
    private List correlatedTables;
    private AbstractCondition qualification;
    private TableRow currentRow;
    private TableRow compareRow;
    private boolean valueReady;
    private TableDefinition comparisonTable;

    public CorrelatedSubqueryOperator(ResultTable inputTable) {
        super(inputTable);
        this.inputTable = inputTable;
        this.correlatedTables = new ArrayList();
        this.subqueries = new ArrayList();
        this.valueReady = false;
        this.currentRow = new TableRow(this.inputTable.getTableDefinition());
        this.comparisonTable = inputTable.getTableDefinition();
        this.comparisonTable.addColumn(new IntegerColumn());
        this.compareRow = new TableRow(this.comparisonTable);
    }

    public void addCorrelatedTable(DatabaseTable table) {
        Assertion.assertTrue(this.qualification == null);
        this.correlatedTables.add(table);
    }

    public void addCorrelatedQualification(DatabaseTable table) {
        Assertion.assertTrue(this.qualification == null);
        this.correlatedTables.add(table);
    }

    public DbResultTable newCorrelatedTableInstance(DatabaseTable table) {
        Assertion.assertTrue(this.correlatedTables.indexOf(table) != -1);
        return new DbResultTable(table);
    }

    public void setQualification(AbstractCondition qualification) {
        this.qualification = qualification;
        this.qualification.prepare(this);
    }

    public void addAndSubquery(ResultTable subquery, AbstractCondition qualification) {
        this.subqueries.add(new SubqueryInfo(subquery, qualification, 0));
        SimpleJoinedTable simpleDummy = new SimpleJoinedTable(this.inputTable, subquery);
        qualification.prepare(simpleDummy);
    }

    public void addOrSubquery(ResultTable subquery, AbstractCondition qualification) {
        this.subqueries.add(new SubqueryInfo(subquery, qualification, 1));
        SimpleJoinedTable simpleDummy = new SimpleJoinedTable(this.inputTable, subquery);
        qualification.prepare(simpleDummy);
    }

    public boolean hasNext() {
        if (this.valueReady) {
            return true;
        }
        if (!this.inputTable.hasNext()) {
            return false;
        }
        while (!this.valueReady) {
            this.currentRow = this.inputTable.next();
            this.prepareCorrelatedTables(this.currentRow);
            Iterator queryIt = this.subqueries.iterator();
            this.valueReady = this.qualification != null ? this.qualification.isTrue(this.currentRow) : true;
            while (queryIt.hasNext()) {
                SubqueryInfo queryInfo = (SubqueryInfo)queryIt.next();
                if (!this.valueReady && queryInfo.isAndPredicate()) continue;
                ResultTable t = queryInfo.getSubquery();
                AbstractCondition q = queryInfo.getQualification();
                t.resetIterator();
                if (q.needsRow()) {
                    if (!t.hasNext()) {
                        this.valueReady = false;
                        continue;
                    }
                    TableRow.mergeRows(this.compareRow, this.currentRow, t.next());
                    Assertion.assertTrue(!t.hasNext());
                }
                if (queryInfo.isOrPredicate()) {
                    if (!q.isTrue(this.compareRow)) continue;
                    this.valueReady = true;
                    break;
                }
                this.valueReady = this.valueReady && q.isTrue(this.compareRow);
            }
            if (this.valueReady || this.inputTable.hasNext()) continue;
            return false;
        }
        return true;
    }

    private void prepareCorrelatedTables(TableRow currentRow) {
        Iterator tableIt = this.correlatedTables.iterator();
        while (tableIt.hasNext()) {
            DatabaseTable table = (DatabaseTable)tableIt.next();
            table.clear();
            TableRow row = new TableRow(table);
            int startColumn = this.inputTable.getColumnBaseOffset(table);
            for (int i = 1; i <= table.getColumnCount(); ++i) {
                row.setValue(i, currentRow.getValue(startColumn + i - 1));
            }
            table.insert(row);
        }
    }

    public TableRow next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        return this.currentRow;
    }

    public void resetIterator() {
        this.inputTable.resetIterator();
        this.valueReady = false;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "CorrelatedSubqueryOperator");
        if (this.qualification != null) {
            s.println(indentStr + "  qualification");
            this.qualification.dumpStructure(s, indentStr + "    ");
        }
        s.println(indentStr + "  correlated tables:");
        Iterator it = this.correlatedTables.iterator();
        while (it.hasNext()) {
            Table t = (Table)it.next();
            t.dumpStructure(s, indentStr + "    ");
        }
        s.println(indentStr + "  input table:");
        this.inputTable.dumpStructure(s, indentStr + "    ");
        s.println(indentStr + "  subqueries:");
        it = this.subqueries.iterator();
        while (it.hasNext()) {
            SubqueryInfo sub = (SubqueryInfo)it.next();
            if (sub.isAndPredicate()) {
                s.println(indentStr + "   AND");
            } else {
                s.println(indentStr + "   OR");
            }
            sub.getQualification().dumpStructure(s, indentStr + "    ");
            s.println(indentStr + "   query:");
            sub.getSubquery().dumpStructure(s, indentStr + "    ");
        }
    }

    private class SubqueryInfo {
        public static final int AND_PREDICATE = 0;
        public static final int OR_PREDICATE = 1;
        private ResultTable subquery;
        private AbstractCondition qualification;
        private int predicate;

        public SubqueryInfo(ResultTable subquery, AbstractCondition qualification, int predicate) {
            this.subquery = subquery;
            this.qualification = qualification;
            this.predicate = predicate;
        }

        public boolean isAndPredicate() {
            return this.predicate == 0;
        }

        public boolean isOrPredicate() {
            return this.predicate == 1;
        }

        public int getPredicate() {
            return this.predicate;
        }

        public AbstractCondition getQualification() {
            return this.qualification;
        }

        public ResultTable getSubquery() {
            return this.subquery;
        }
    }
}

