/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import java.io.PrintStream;

public abstract class ComparisonCondition
extends AbstractCondition {
    protected Table leftTable;
    protected Table rightTable;
    protected int leftColumnNumber;
    protected int rightColumnNumber;
    protected int leftRowBaseColumnNo;
    protected int rightRowBaseColumnNo;

    public ComparisonCondition(Table leftTable, int leftColumnNumber, Table rightTable, int rightColumnNumber) {
        this.leftTable = leftTable;
        this.leftColumnNumber = leftColumnNumber;
        this.rightColumnNumber = rightColumnNumber;
        this.rightTable = rightTable;
    }

    public abstract String getConditionName();

    public abstract String getOperatorString();

    public void prepare(ResultTable inputTable) {
        this.leftRowBaseColumnNo = inputTable.getColumnBaseOffset(this.leftTable) - 1;
        this.rightRowBaseColumnNo = inputTable.getColumnBaseOffset(this.rightTable) - 1;
    }

    public boolean isTrue(TableRow row) {
        AbstractCell leftValue = row.getValue(this.leftColumnNumber + this.leftRowBaseColumnNo);
        AbstractCell rightValue = row.getValue(this.rightColumnNumber + this.rightRowBaseColumnNo);
        if (leftValue.isNull() || rightValue.isNull()) {
            return false;
        }
        return leftValue.isLess(rightValue);
    }

    public boolean isFalse(TableRow leftRow) {
        return !this.isTrue(leftRow);
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + this.getConditionName());
        s.println(indentStr + "  " + this.leftTable.getTableName() + "." + String.valueOf(this.leftColumnNumber) + " " + this.getOperatorString() + " " + this.rightTable.getTableName() + "." + String.valueOf(this.rightColumnNumber));
    }
}

