/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation;

import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.ResultTable;
import com.sap.sapdb.oltptest.join.simulation.Table;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.ValueFunction;
import java.io.PrintStream;

public class CellAccessorFunction
extends ValueFunction {
    public static final int COPY_CELL = 0;
    public static final int PASS_CELL = 1;
    private Table table;
    private int columnNumber;
    private int baseColumnRowOffset = 0;
    private boolean copyValue;

    public CellAccessorFunction(Table table, int columnNumber) {
        this.table = table;
        this.columnNumber = columnNumber;
        this.copyValue = true;
    }

    public CellAccessorFunction(Table table, int columnNumber, int cellHandling) {
        this.table = table;
        this.columnNumber = columnNumber;
        this.copyValue = cellHandling == 0;
    }

    public AbstractCell evaluate(TableRow row) {
        if (this.copyValue) {
            return (AbstractCell)row.getValue(this.columnNumber + this.baseColumnRowOffset).clone();
        }
        return row.getValue(this.columnNumber + this.baseColumnRowOffset);
    }

    public boolean needsRow() {
        return true;
    }

    public void prepare(ResultTable inputTable) {
        this.baseColumnRowOffset = inputTable.getColumnBaseOffset(this.table) - 1;
    }

    public void dumpStructure(PrintStream s, String indentStr) {
        s.println(indentStr + "CellAccessorFunction");
        if (this.copyValue) {
            s.println(indentStr + "  providing copy");
        } else {
            s.println(indentStr + "  providing original");
        }
        s.println(indentStr + "  table : " + this.table.getTableName());
        s.println(indentStr + "  column: " + this.columnNumber);
    }
}

