/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simplejdbc;

import com.sap.sapdb.oltptest.join.data.Generator;
import com.sap.sapdb.oltptest.join.description.TableDescription;
import java.sql.CallableStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class Connection {
    java.sql.Connection _inner;
    Statement stmt;

    public Connection() throws ClassNotFoundException, SQLException {
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        Properties sysprops = System.getProperties();
        String host = sysprops.getProperty("sdb.host", "");
        String dbname = sysprops.getProperty("sdb.dbname", "DB76");
        String user = sysprops.getProperty("sdb.user", "DANIEL");
        String pwd = sysprops.getProperty("sdb.pwd", "DANIEL");
        String options = "?autocommit=off";
        String url = "jdbc:sapdb://" + host + "/" + dbname + options;
        String sqlmode = sysprops.getProperty("sdb.sqlmode", "");
        if (sqlmode.length() != 0) {
            url = url + "&sqlmode=" + sqlmode;
        }
        this._inner = DriverManager.getConnection(url, user, pwd);
        this.stmt = this._inner.createStatement(1004, 1007);
    }

    public void sql(String cmd) throws SQLException {
        this.stmt.executeUpdate(cmd);
    }

    public void ddl(String cmd) throws SQLException {
        this.stmt.executeUpdate(cmd);
    }

    public void ddlIgnoreErrors(String cmd) {
        try {
            this.ddl(cmd);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void commit() throws SQLException {
        this._inner.commit();
    }

    public void ping() throws SQLException {
        this._inner.isClosed();
    }

    public ResultSet select(String sql) throws SQLException {
        return this.stmt.executeQuery(sql);
    }

    public void dumpQuery(String sql) throws SQLException {
        ResultSet cursor = this.stmt.executeQuery(sql);
        this.dumpCursor(cursor);
        cursor.close();
        this._inner.commit();
    }

    public void dumpCursor(ResultSet cursor) throws SQLException {
        ResultSetMetaData desc = cursor.getMetaData();
        int colCount = desc.getColumnCount();
        Set[] idSets = new Set[colCount + 1];
        String[] tableNames = new String[colCount + 1];
        String delimiter = "";
        for (int i = 1; i <= colCount; ++i) {
            String colName;
            String colLabel = desc.getColumnLabel(i);
            int dotPos = colLabel.indexOf(46);
            if (dotPos > 0 && (colName = colLabel.substring(dotPos + 1)).equals("id")) {
                idSets[i] = new TreeSet();
                tableNames[i] = colLabel.substring(0, dotPos);
            }
            System.out.print(delimiter + colLabel);
            delimiter = ",";
        }
        System.out.println();
        long count = 0L;
        while (cursor.next()) {
            ++count;
            delimiter = "";
            for (int i = 1; i <= colCount; ++i) {
                Object element = cursor.getObject(i);
                System.out.print(delimiter + element);
                if (idSets[i] != null && element != null) {
                    idSets[i].add(element);
                }
                delimiter = ",";
            }
            System.out.println();
        }
        cursor.beforeFirst();
        long joinSize = 1L;
        for (int i = 1; i <= colCount; ++i) {
            if (idSets[i] == null) continue;
            String tableName = tableNames[i];
            long tableSize = this.getTableSize(tableName);
            joinSize *= tableSize;
            long matchSize = idSets[i].size();
            long percentage = matchSize * 100L / tableSize;
            System.out.println(tableName + ": " + matchSize + " / " + tableSize + " (" + percentage + "%)");
        }
        long percentage = count * 100L / joinSize;
        System.out.println("ALL: " + count + " / " + joinSize + " (" + percentage + "%)");
    }

    protected long getTableSize(String tableName) throws SQLException {
        long result = -1L;
        ResultSet cursor = this.stmt.executeQuery("SELECT COUNT (*) FROM " + tableName);
        if (cursor.next()) {
            result = cursor.getLong(1);
        }
        return result;
    }

    public void fillTable(TableDescription table, Generator[] generators, int verbosity) throws SQLException {
        if (verbosity >= 2) {
            System.out.println("filling table " + table.getName());
        }
        String sql = "INSERT INTO " + table.getName() + " (";
        String values = ") VALUES (";
        String delimiter = "";
        TableDescription.ColumnIterator cols = table.columnIterator();
        int colCount = 0;
        while (cols.hasNext()) {
            String colName = cols.nextColumn().getName();
            ++colCount;
            sql = sql + delimiter + colName;
            values = values + delimiter + "?";
            delimiter = ", ";
        }
        sql = sql + values + ")";
        if (verbosity >= 2) {
            System.out.println(sql);
        }
        CallableStatement insert = this._inner.prepareCall(sql);
        int batchSize = 100;
        int batchCounter = 0;
        long rowCount = table.rowCount();
        boolean dataPending = false;
        long rowIndex = 0L;
        while (rowIndex < rowCount) {
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                insert.setObject(colIndex + 1, generators[colIndex].next());
            }
            insert.addBatch();
            dataPending = true;
            if (batchCounter >= 100) {
                insert.executeBatch();
                dataPending = false;
                batchCounter = 0;
            }
            ++rowIndex;
            ++batchCounter;
        }
        if (dataPending) {
            insert.executeBatch();
        }
        this._inner.commit();
    }

    public void fillTable(TableDescription table, AbstractList data, int verbosity) throws SQLException {
        if (verbosity >= 2) {
            System.out.println("filling table " + table.getName());
        }
        String sql = "INSERT INTO " + table.getName() + " (";
        String values = ") VALUES (";
        String delimiter = "";
        TableDescription.ColumnIterator cols = table.columnIterator();
        int colCount = 0;
        while (cols.hasNext()) {
            String colName = cols.nextColumn().getName();
            ++colCount;
            sql = sql + delimiter + colName;
            values = values + delimiter + "?";
            delimiter = ", ";
        }
        sql = sql + values + ")";
        if (verbosity >= 2) {
            System.out.println(sql);
        }
        CallableStatement insert = this._inner.prepareCall(sql);
        int batchSize = 100;
        Iterator iter = data.iterator();
        int batchCounter = 0;
        long rowCount = table.rowCount();
        boolean dataPending = false;
        while (iter.hasNext()) {
            ++batchCounter;
            Object[] row = (Object[])iter.next();
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                insert.setObject(colIndex + 1, row[colIndex]);
            }
            insert.addBatch();
            dataPending = true;
            if (batchCounter < 100) continue;
            insert.executeBatch();
            dataPending = false;
            batchCounter = 0;
        }
        if (dataPending) {
            insert.executeBatch();
        }
        this._inner.commit();
    }
}

