/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.description;

import com.sap.sapdb.oltptest.join.description.ColumnType;
import com.sap.sapdb.oltptest.join.description.JoinPredicate;
import com.sap.sapdb.oltptest.join.description.JoinQuery;
import com.sap.sapdb.oltptest.join.description.TableDescription;
import com.sap.sapdb.oltptest.join.simulation.AbstractCell;
import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.CellFactory;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.EqualConstCondition;
import com.sap.sapdb.oltptest.join.simulation.GreaterConstCondition;
import com.sap.sapdb.oltptest.join.simulation.LessConstCondition;
import java.util.AbstractList;

public class SingleTablePredicate
extends JoinPredicate {
    private String tableName;
    private String columnName;
    private String operator;
    private Object value;

    SingleTablePredicate(String tableName, String columnName, String operator, Object value) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.operator = operator;
        this.value = value;
    }

    public void createColumns(JoinQuery join) {
        TableDescription table = join.findTable(this.tableName);
        ColumnType coltype = this.value instanceof String ? ColumnType.Character : (this.value instanceof Integer ? ColumnType.Integer : new ColumnType("garbage"));
        table.addColumn(this.columnName, coltype);
    }

    public String asSQL() {
        String sqlLiteral = this.value instanceof String ? "'" + this.value + "'" : this.value.toString();
        String result = this.tableName + "." + this.columnName + " " + this.operator + " " + sqlLiteral;
        return result;
    }

    public boolean suitableForOn(String newTableName, AbstractList usedTables) {
        return newTableName.equals(this.tableName);
    }

    public AbstractCondition buildCondition(JoinQuery join) {
        AbstractCondition result;
        TableDescription table = join.findTable(this.tableName);
        DatabaseTable sim = table.getSimulatedTable();
        int colIndex = table.findColumnIndex(this.columnName);
        AbstractCell cell = CellFactory.createCell(this.value);
        if (this.operator.equals("=")) {
            result = new EqualConstCondition(sim, colIndex, cell);
        } else if (this.operator.equals("<")) {
            result = new LessConstCondition(sim, colIndex, cell);
        } else if (this.operator.equals(">")) {
            result = new GreaterConstCondition(sim, colIndex, cell);
        } else {
            throw new Error("invalid operator " + this.operator);
        }
        return result;
    }
}

