/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.description;

public class IntPermutation {
    int[] current;
    int size;

    public IntPermutation(int size) {
        this.size = size;
        this.current = new int[size];
        for (int i = 0; i < size; ++i) {
            this.current[i] = i;
        }
        this.current[size - 1] = this.current[size - 1] - 1;
    }

    public int[] next() {
        boolean nextFound = this.increment(this.size - 1);
        if (!nextFound) {
            return null;
        }
        int[] result = new int[this.size];
        System.arraycopy(this.current, 0, result, 0, this.size);
        return result;
    }

    protected boolean increment(int column) {
        int currentValue = this.current[column];
        for (int newValue = currentValue + 1; newValue < this.size; ++newValue) {
            if (this.alreadyUsed(column, newValue)) continue;
            this.current[column] = newValue;
            this.initColumns(column + 1);
            return true;
        }
        if (column > 0) {
            return this.increment(column - 1);
        }
        return false;
    }

    protected boolean alreadyUsed(int column, int newValue) {
        for (int i = 0; i < column; ++i) {
            if (this.current[i] != newValue) continue;
            return true;
        }
        return false;
    }

    protected void initColumns(int startColumn) {
        if (startColumn >= this.size) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.alreadyUsed(startColumn, i)) continue;
            this.current[startColumn] = i;
            this.initColumns(startColumn + 1);
            return;
        }
    }

    public static void main(String[] args) {
        int[] value;
        int width = 4;
        IntPermutation iter = new IntPermutation(width);
        while ((value = iter.next()) != null) {
            System.out.print("!!! ");
            for (int i = 0; i < width; ++i) {
                System.out.print(" " + value[i]);
            }
            System.out.println("");
        }
    }
}

