/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.data;

import com.sap.sapdb.oltptest.join.data.Generator;
import com.sap.sapdb.oltptest.join.data.RandomStream;

public class CommonIntGenerator
implements Generator {
    private int intRange;
    private int[] commonKeys;
    private int commonKeyPos;

    public CommonIntGenerator(int intRange) {
        this.intRange = intRange;
    }

    public CommonIntGenerator() {
        this(100000);
    }

    public void initKeys(int rowCount) {
        this.commonKeys = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.commonKeys[i] = RandomStream.nextInt(this.intRange);
        }
    }

    public void nextTable(int rowCount) {
        int commonSize = this.commonKeys.length;
        int[] newCommonKeys = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            int index = RandomStream.nextInt(commonSize);
            newCommonKeys[i] = this.commonKeys[index];
        }
        this.commonKeys = newCommonKeys;
        this.commonKeyPos = 0;
    }

    public Object next() {
        int result;
        if (this.commonKeyPos < this.commonKeys.length) {
            result = this.commonKeys[this.commonKeyPos];
            ++this.commonKeyPos;
        } else {
            result = RandomStream.nextInt(this.intRange);
        }
        return new Integer(result);
    }
}

