/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.interfaces;

import com.sap.sapdb.oltptest.interfaces.PerlDBDTest;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestProgramRunner
extends Thread {
    private String[] commandline;
    private String commandonly;
    private String[] parameter;
    private PerlDBDTest testcase;
    private Vector infoMessages;
    private Vector errorMessages;
    private Process runningProgram;
    private int runningStatus;
    private boolean good = true;
    private int acceptedExitCode = 0;
    private String referenceProtocolNameSTDERR;
    private String referenceProtocolNameSTDOUT;
    private Vector referenceProtocolSTDERR;
    private Vector referenceProtocolSTDOUT;
    private Vector protocolSTDERR;
    private Vector protocolSTDOUT;
    private static final int STDERR = 2;
    private static final int STDOUT = 1;

    public TestProgramRunner(String[] parameter, PerlDBDTest PerlDBDTest2) {
        this.parameter = parameter;
        this.testcase = PerlDBDTest2;
        this.infoMessages = new Vector();
        this.errorMessages = new Vector();
        this.runningStatus = 0;
        this.initCommandLine(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.good) {
            this.testcase.message("", 'E', "Running test specified by parameter " + this.parameter + " failed in initialisation.");
        }
        PerlDBDTest.println("######################################################################");
        TestProgramRunner testProgramRunner = this;
        synchronized (testProgramRunner) {
            this.runningStatus = 1;
        }
        try {
            PerlDBDTest.println("Executing " + this.getCommandLine() + " in " + PerlDBDTest.getSQLDBCTestRoot() + ".");
            this.runningProgram = Runtime.getRuntime().exec(this.commandline, null, PerlDBDTest.getSQLDBCTestRoot());
        }
        catch (IOException ioEx) {
            this.testcase.message("", 'E', "Program execution failed: " + ioEx.getMessage() + "\n" + "wanted to execute: " + this.getCommandLine());
            PerlDBDTest.println("######################################################################");
            return;
        }
        TestOutputReader errorReader = new TestOutputReader(this.runningProgram.getErrorStream(), 2);
        TestOutputReader outputReader = new TestOutputReader(this.runningProgram.getInputStream(), 1);
        errorReader.start();
        outputReader.start();
        int status = 0;
        try {
            this.runningProgram.waitFor();
            status = 1;
            errorReader.join();
            status = 2;
            outputReader.join();
            status = 3;
            TestProgramRunner testProgramRunner2 = this;
            synchronized (testProgramRunner2) {
                this.runningStatus = 2;
            }
            int processExitCode = this.runningProgram.exitValue();
            if (processExitCode == this.acceptedExitCode) {
                this.testcase.message("", 'I', this.commandonly + " successful.");
            } else {
                this.testcase.message("", 'E', this.commandonly + " failed, exit code " + processExitCode + " instead of " + this.acceptedExitCode + ", error output follows.");
                String errorMessage = this.makeStringFromVector(this.errorMessages);
                this.testcase.message("", 'E', errorMessage);
            }
            if (this.protocolSTDERR != null) {
                this.compareProtocols(this.protocolSTDERR, this.referenceProtocolSTDERR, this.referenceProtocolNameSTDERR);
            }
            if (this.protocolSTDOUT != null) {
                this.compareProtocols(this.protocolSTDOUT, this.referenceProtocolSTDOUT, this.referenceProtocolNameSTDOUT);
            }
        }
        catch (InterruptedException interruptedEx) {
            if (status == 0) {
                this.testcase.message("", 'E', "Test Program was interrupted.\nCommand Line: " + this.getCommandLine());
                this.runningProgram.destroy();
                this.testcase.notifySuccessfulInterrupt(1);
                PerlDBDTest.println("######################################################################");
                return;
            }
            switch (status) {
                case 1: {
                    try {
                        errorReader.join();
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
                case 2: {
                    try {
                        outputReader.join();
                        break;
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
            }
            TestProgramRunner ignored = this;
            synchronized (ignored) {
                this.runningStatus = 2;
            }
            int processExitCode = this.runningProgram.exitValue();
            if (processExitCode == this.acceptedExitCode) {
                this.testcase.message("", 'I', this.commandonly + " successful.");
            } else {
                this.testcase.message("", 'E', this.commandonly + " failed, exit code " + processExitCode + "instead of " + this.acceptedExitCode + ", error output follows.");
                String errorMessage = this.makeStringFromVector(this.errorMessages);
                this.testcase.message("", 'E', errorMessage);
            }
            if (this.protocolSTDERR != null) {
                this.compareProtocols(this.protocolSTDERR, this.referenceProtocolSTDERR, this.referenceProtocolNameSTDERR);
            }
            if (this.protocolSTDOUT != null) {
                this.compareProtocols(this.protocolSTDOUT, this.referenceProtocolSTDOUT, this.referenceProtocolNameSTDOUT);
            }
            this.testcase.notifySuccessfulInterrupt(2);
        }
        PerlDBDTest.println("######################################################################");
    }

    private String makeStringFromVector(Vector v) {
        Enumeration e = v.elements();
        StringBuffer sb = new StringBuffer();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            sb.append("\n");
            sb.append(s);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptExecution() {
        TestProgramRunner testProgramRunner = this;
        synchronized (testProgramRunner) {
            if (this.runningStatus == 1) {
                this.interrupt();
            } else if (this.runningStatus == 2) {
                while (this.runningStatus == 2) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                }
                this.testcase.notifySuccessfulInterrupt(2);
            } else {
                return;
            }
        }
    }

    private void initCommandLine(String[] allparameter) {
        this.commandline = new String[allparameter.length];
        for (int j = 0; j < allparameter.length; ++j) {
            String parameter = allparameter[j].trim();
            if (parameter.startsWith("::")) {
                int endofFilesSection = parameter.indexOf("::", 2);
                if (endofFilesSection == -1) {
                    this.good = false;
                    return;
                }
                String diffParameter = parameter.substring(2, endofFilesSection);
                this.initAdditionalParameters(diffParameter);
                parameter = parameter.substring(endofFilesSection + 2);
            }
            StringBuffer sb = new StringBuffer(parameter.trim());
            try {
                TestDatabase db = TestCase.getDatabase();
                String[] keys = new String[]{"$database", "$node", "$user", "$password", "$testpath"};
                String[] values = new String[]{db.getName(), db.getHost(), db.getDBAUser(), db.getDBAPassword(), PerlDBDTest.getSQLDBCTestRoot().getCanonicalPath()};
                if (db.getPort() != 7210) {
                    values[1] = db.getHost() + ":" + db.getPort();
                }
                for (int i = 0; i < keys.length; ++i) {
                    String check;
                    int idx = -1;
                    while ((idx = (check = sb.toString()).indexOf(keys[i])) != -1) {
                        sb.replace(idx, idx + keys[i].length(), values[i]);
                    }
                }
                String plaincommand = sb.toString();
                this.commandonly = plaincommand.indexOf("t\\") == -1 ? plaincommand : plaincommand.substring(plaincommand.indexOf("t\\"), plaincommand.length() - 3);
                this.commandline[j] = plaincommand;
                continue;
            }
            catch (IOException ioEx) {
                this.good = false;
                this.testcase.message("", 'E', "IO Exception: " + ioEx.getMessage());
            }
        }
    }

    private void initAdditionalParameters(String params) {
        StringTokenizer param_tok = new StringTokenizer(params, ",");
        while (param_tok.hasMoreTokens()) {
            String parameter = param_tok.nextToken();
            int eqIndex = parameter.indexOf("@");
            if (eqIndex == -1) {
                this.good = false;
                this.testcase.message("", 'E', "Missing '=' in detailed test specification.");
            }
            String parameterName = parameter.substring(0, eqIndex).trim();
            String parameterValue = parameter.substring(eqIndex + 1).trim();
            if (parameterName.equalsIgnoreCase("EXITCODE")) {
                this.acceptedExitCode = Integer.parseInt(parameterValue);
                continue;
            }
            if (parameterName.equalsIgnoreCase("STDERR")) {
                this.referenceProtocolNameSTDERR = parameterValue;
                this.referenceProtocolSTDERR = this.readReferenceProtocol(parameterValue);
                this.protocolSTDERR = new Vector();
                continue;
            }
            if (parameterName.equalsIgnoreCase("STDOUT")) {
                this.referenceProtocolNameSTDOUT = parameterValue;
                this.referenceProtocolSTDOUT = this.readReferenceProtocol(parameterValue);
                this.protocolSTDOUT = new Vector();
                continue;
            }
            this.testcase.message("", 'W', "Ignoring unknown detail specification '" + parameterName + "'");
        }
    }

    Vector readReferenceProtocol(String filename) {
        try {
            String line;
            File infile = new File(PerlDBDTest.getSQLDBCTestRoot(), filename);
            BufferedReader reader = new BufferedReader(new FileReader(infile));
            Vector<String> result = new Vector<String>();
            while ((line = reader.readLine()) != null) {
                result.addElement(line);
            }
            return result;
        }
        catch (IOException ioEx) {
            this.testcase.message("", 'E', "IOException reading reference protocol file : " + filename + "\n " + ioEx.getMessage());
            this.good = false;
            return null;
        }
    }

    public String getCommandLine() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.commandline.length; ++i) {
            sb.append(this.commandline[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    private synchronized void addMessage(String message, int category) {
        PerlDBDTest.println(message);
        int nameidx = 0;
        if (category == 2 && this.protocolSTDERR != null) {
            this.protocolSTDERR.addElement(message);
        }
        if (category == 1 && this.protocolSTDOUT != null) {
            this.protocolSTDOUT.addElement(message);
        }
        if (message.startsWith("INFO:")) {
            nameidx = (message = message.substring(5)).indexOf(58, 2);
            if (nameidx != -1) {
                message = message.substring(nameidx + 1);
            }
            this.infoMessages.add(message);
            return;
        }
        if (message.startsWith("ERROR:")) {
            nameidx = (message = message.substring(6)).indexOf(58, 2);
            if (nameidx != -1) {
                message = message.substring(nameidx + 1);
            }
            this.errorMessages.add(message);
            return;
        }
        this.infoMessages.add(message);
    }

    private void writeTestProtocol(Vector protocol, String protocolName) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(new File(this.testcase.getProtocolDir(), protocolName + ".testrun")));
            for (int i = 0; i < protocol.size(); ++i) {
                ps.println("" + protocol.elementAt(i));
            }
            ps.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void compareProtocols(Vector protocol, Vector referenceProtocol, String protocolName) {
        int protocol_index = 0;
        int refprotocol_index = 0;
        int lastdiff = -1;
        int differences = 0;
        while (protocol_index < protocol.size() || refprotocol_index < referenceProtocol.size()) {
            if (protocol_index >= protocol.size()) {
                while (refprotocol_index < referenceProtocol.size()) {
                    String ref_line = (String)referenceProtocol.elementAt(refprotocol_index);
                    if (ref_line.trim().length() == 0 || ref_line.startsWith("//")) {
                        ++refprotocol_index;
                        continue;
                    }
                    this.testcase.message("", 'E', "Protocol file " + protocolName + " has " + (referenceProtocol.size() - refprotocol_index) + " differences (reference protocol is longer).");
                    for (int i = refprotocol_index; i < referenceProtocol.size(); ++i) {
                        PerlDBDTest.println("reference: " + referenceProtocol.elementAt(i));
                    }
                    this.writeTestProtocol(protocol, protocolName);
                    return;
                }
                break;
            }
            if (refprotocol_index >= referenceProtocol.size()) {
                while (protocol_index < protocol.size()) {
                    String prot_line = (String)protocol.elementAt(protocol_index);
                    if (prot_line.trim().length() == 0) {
                        ++protocol_index;
                        continue;
                    }
                    this.testcase.message("", 'E', "Protocol file " + protocolName + " has " + (protocol.size() - protocol_index) + " differences (protocol is longer).");
                    for (int i = protocol_index; i < protocol.size(); ++i) {
                        PerlDBDTest.println("protocol: " + protocol.elementAt(i));
                    }
                    this.writeTestProtocol(protocol, protocolName);
                    return;
                }
                break;
            }
            if (protocol.elementAt(protocol_index).equals(referenceProtocol.elementAt(refprotocol_index))) {
                ++protocol_index;
                ++refprotocol_index;
                continue;
            }
            String ref = (String)referenceProtocol.elementAt(refprotocol_index);
            if (ref.startsWith("//")) {
                ++protocol_index;
                ++refprotocol_index;
                continue;
            }
            if (++differences == 1 || lastdiff != protocol_index - 1) {
                PerlDBDTest.println("DIFF " + protocolName + " from line " + (protocol_index + 1));
            }
            PerlDBDTest.println("reference: " + referenceProtocol.elementAt(protocol_index));
            PerlDBDTest.println("protocol: " + protocol.elementAt(refprotocol_index));
            lastdiff = protocol_index++;
            ++refprotocol_index;
        }
        if (differences > 0) {
            this.testcase.message("", 'E', "Protocol file " + protocolName + " has " + differences + " line differences.");
            this.writeTestProtocol(protocol, protocolName);
            return;
        }
    }

    private class TestOutputReader
    extends Thread {
        private BufferedReader input;
        private int category;

        TestOutputReader(InputStream input, int category) {
            this.input = new BufferedReader(new InputStreamReader(input));
            this.category = category;
        }

        public void run() {
            try {
                String line = null;
                while ((line = this.input.readLine()) != null) {
                    TestProgramRunner.this.addMessage(line, this.category);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

