/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.interfaces;

import com.sap.sapdb.oltptest.interfaces.TestProgramRunner;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class PerlDBDTest
extends TestCase {
    private static ArrayList testList;
    private int testInterruptionStatus = 0;
    private static long timeOut;
    private static String jtestRoot;
    private static boolean good;
    private static PrintStream protocolStream;
    private static File sqldbcTestRoot;
    private static File dbiTestRoot;
    private static Object semaphore;
    private static File protocolDir;
    private static String protocolStreamName;
    private static String perlexe;

    public static void prepare() {
        good = true;
        try {
            testList = PerlDBDTest.getUnnamedParameterList();
            if (testList.isEmpty()) {
                PerlDBDTest.addGlobalMessage((String)"", (char)'E', (String)"There are no tests for execution available.");
                good = false;
                return;
            }
            timeOut = PerlDBDTest.getParameterLong((String)"TIMEOUT", (long)-1L);
            if (timeOut == -1L) {
                timeOut = 60000 * testList.size();
            }
            PerlDBDTest.addGlobalMessage((String)"", (char)'I', (String)("Test timeout is " + timeOut));
            jtestRoot = System.getProperty("jtest.root");
            PerlDBDTest.addGlobalMessage((String)"", (char)'I', (String)("Test root is " + jtestRoot));
            PerlDBDTest.initProtocol();
            sqldbcTestRoot = new File(jtestRoot + File.separator + "tests" + File.separator + "DBD-MaxDB");
            dbiTestRoot = new File(jtestRoot + File.separator + "tests" + File.separator + "DBI");
            perlexe = TestCase.getParameterString((String)"DBIPERL", (String)"");
            if (perlexe.equals("")) {
                PerlDBDTest.addGlobalMessage((String)"", (char)'I', (String)"Testparameter DBIPERL not set, use vm argument com.sap.sapdb.testframe.DBIPERL instead");
                perlexe = System.getProperty("com.sap.sapdb.testframe.DBIPERL", null);
            }
            if (perlexe == null) {
                PerlDBDTest.addGlobalMessage((String)"", (char)'E', (String)"Path for DBI perl is not set. Use 'perl' instead.");
                perlexe = "perl";
            }
            if (System.getProperty("os.name").equals("HP-UX")) {
                perlexe = "LD_PRELOAD=libCsup.2:libcl.2 " + perlexe;
            }
        }
        catch (Exception ex) {
            good = false;
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            PerlDBDTest.addGlobalMessage((String)"", (char)'E', (String)("Exception in prepare: " + ex.toString() + "\n" + sw.toString()));
        }
    }

    public static File getSQLDBCTestRoot() {
        return sqldbcTestRoot;
    }

    private static void deleteDir(File dir) {
        File[] ldir = dir.listFiles();
        for (int i = 0; i < ldir.length; ++i) {
            if (ldir[i].isDirectory()) {
                PerlDBDTest.deleteDir(ldir[i]);
                continue;
            }
            ldir[i].delete();
        }
        dir.delete();
    }

    private boolean unzip(int testnum, String zipFile) {
        try {
            sqldbcTestRoot = new File(jtestRoot + File.separator + "tests");
            if (new File(jtestRoot + File.separator + "tests" + File.separator + zipFile + ".tar.gz").exists()) {
                File dir;
                PerlDBDTest.println("Found " + zipFile + ".tar.gz - try to decompress.");
                File tar = new File(jtestRoot + File.separator + "tests" + File.separator + zipFile + ".tar");
                if (tar.exists()) {
                    PerlDBDTest.println("First deleting old " + zipFile + ".tar.");
                    tar.delete();
                }
                if ((dir = new File(jtestRoot + File.separator + "tests" + File.separator + zipFile)).exists() && dir.isDirectory()) {
                    PerlDBDTest.println("First deleting old " + zipFile + " directory.");
                    PerlDBDTest.deleteDir(dir);
                }
                if (!this.runInner(new String[]{"gzip", "-f", "-d", zipFile + ".tar.gz"}, testnum, testList)) {
                    return false;
                }
            }
            if (new File(jtestRoot + File.separator + "tests" + File.separator + zipFile + ".tar").exists()) {
                PerlDBDTest.println("Found " + zipFile + ".tar - try to untar.");
                File dir = new File(jtestRoot + File.separator + "tests" + File.separator + zipFile);
                if (dir.isDirectory()) {
                    PerlDBDTest.println("First deleting old " + zipFile + " directory.");
                    PerlDBDTest.deleteDir(dir);
                }
                if (!this.runInner(new String[]{"tar", "-xf", zipFile + ".tar"}, testnum, testList)) {
                    return false;
                }
                File[] ldir = sqldbcTestRoot.listFiles();
                int dirnum = -1;
                for (int i = 0; i < ldir.length; ++i) {
                    if (!ldir[i].isDirectory() || !ldir[i].getName().startsWith(zipFile + "-")) continue;
                    dirnum = i;
                    break;
                }
                if (dirnum != -1) {
                    ldir[dirnum].renameTo(new File(jtestRoot + File.separator + "tests" + File.separator + zipFile));
                } else {
                    this.addMessage("", 'I', "Folder containing the " + zipFile + " driver not found at: " + jtestRoot + File.separator + "tests");
                }
            } else {
                PerlDBDTest.println("Info File not found " + jtestRoot + File.separator + "tests" + File.separator + zipFile + ".tar.gz");
            }
            if (!new File(jtestRoot + File.separator + "tests" + File.separator + zipFile).isDirectory()) {
                this.addMessage("", 'E', "Perl driver not found at: " + jtestRoot + File.separator + "tests" + File.separator + zipFile);
            }
            sqldbcTestRoot = new File(jtestRoot + File.separator + "tests" + File.separator + zipFile);
        }
        catch (Exception ex) {
            good = false;
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.addMessage("", 'E', "Exception in unzip: " + ex.toString() + "\n" + sw.toString());
        }
        return true;
    }

    public void run() {
        if (!good) {
            PerlDBDTest.addGlobalMessage((String)"", (char)'E', (String)"Error in prepare phase, see previous messages.");
        } else {
            try {
                ArrayList<String[]> makecmds = new ArrayList<String[]>(3);
                if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
                    makecmds.add(new String[]{perlexe, "-I", dbiTestRoot + File.separator + "blib" + File.separator + "lib", "-I", dbiTestRoot + File.separator + "blib" + File.separator + "arch", "Makefile.PL"});
                    makecmds.add(new String[]{"nmake"});
                } else {
                    makecmds.add(new String[]{perlexe, "-I", dbiTestRoot + File.separator + "blib" + File.separator + "lib", "-I", dbiTestRoot + File.separator + "blib" + File.separator + "arch", "Makefile.PL"});
                    makecmds.add(new String[]{"make"});
                }
                for (int i = 0; i < testList.size(); ++i) {
                    if (((String)testList.get(i)).equals("unzipDBDMaxDB")) {
                        if (this.unzip(i, "DBD-MaxDB")) continue;
                        return;
                    }
                    if (((String)testList.get(i)).equals("unzipDBI")) {
                        if (this.unzip(i, "DBI")) continue;
                        return;
                    }
                    if (((String)testList.get(i)).equals("makeDBDMaxDB")) {
                        for (int j = 0; j < makecmds.size(); ++j) {
                            if (this.runInner((String[])makecmds.get(j), i, testList)) continue;
                            return;
                        }
                        continue;
                    }
                    if (((String)testList.get(i)).equals("makeDBI")) {
                        File oldRoot = sqldbcTestRoot;
                        sqldbcTestRoot = new File(jtestRoot + File.separator + "tests" + File.separator + "DBI");
                        for (int j = 0; j < makecmds.size(); ++j) {
                            if (this.runInner((String[])makecmds.get(j), i, testList)) continue;
                            return;
                        }
                        sqldbcTestRoot = oldRoot;
                        continue;
                    }
                    String[] command = new String[]{};
                    command = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS") ? new String[]{perlexe, "-I", dbiTestRoot + File.separator + "blib" + File.separator + "lib", "-I", dbiTestRoot + File.separator + "blib" + File.separator + "arch", "-I", sqldbcTestRoot + File.separator + "blib" + File.separator + "lib", "-I", sqldbcTestRoot + File.separator + "blib" + File.separator + "arch", "-Mblib", "-e", "\"use Test::Harness qw(&runtests $verbose); use Env;$ENV{DBI_DSN}='dbi:MaxDB:$node/$database';$ENV{DBI_USER}='$user';$ENV{DBI_PASS}='$password';$verbose=1; runtests ('t\\" + (String)testList.get(i) + "');\""} : new String[]{perlexe, "-I", dbiTestRoot + File.separator + "blib" + File.separator + "lib", "-I", dbiTestRoot + File.separator + "blib" + File.separator + "arch", "-I", sqldbcTestRoot + File.separator + "blib" + File.separator + "lib", "-I", sqldbcTestRoot + File.separator + "blib" + File.separator + "arch", "-e", "use Test::Harness qw(&runtests $verbose);use Env;$ENV{DBI_DSN}='dbi:MaxDB:$node/$database';$ENV{DBI_USER}='$user';$ENV{DBI_PASS}='$password';$verbose=1; runtests @ARGV;", "t/" + (String)testList.get(i)};
                    if (this.runInner(command, i, testList)) continue;
                    return;
                }
            }
            catch (Exception ex) {
                good = false;
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.addMessage("", 'E', "Exception in run: " + ex.toString() + "\n" + sw.toString());
            }
        }
    }

    public boolean runInner(String[] command, int index, ArrayList testList) {
        TestProgramRunner currentTest = new TestProgramRunner(command, this);
        currentTest.start();
        try {
            currentTest.join();
        }
        catch (InterruptedException interruptedEx) {
            this.handleInterruption(currentTest);
            for (int k = index + 1; k < testList.size(); ++k) {
                String cmd = (String)testList.get(k);
                PerlDBDTest.addGlobalMessage((String)"", (char)'E', (String)("Test " + cmd + " did not run (previous test was killed)."));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterruption(TestProgramRunner test) {
        test.interruptExecution();
        try {
            Object object = semaphore;
            synchronized (object) {
                semaphore.wait(15000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.testInterruptionStatus == 0) {
            PerlDBDTest.addGlobalMessage((String)"", (char)'E', (String)("Could not interrupt test program, please cleanup by yourself.\nThe called program was:\n" + test.getCommandLine()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuccessfulInterrupt(int status) {
        this.testInterruptionStatus = status;
        Object object = semaphore;
        synchronized (object) {
            semaphore.notify();
        }
    }

    public static long getTimeout() {
        return timeOut;
    }

    public void message(String messageId, char messageCategory, String message) {
        TestCase.addGlobalMessage((String)messageId, (char)messageCategory, (String)message);
    }

    public static synchronized void println(String string) {
        if (protocolStream != null) {
            protocolStream.println(string);
        }
    }

    public File getProtocolDir() {
        return protocolDir;
    }

    private static void initProtocol() throws Exception {
        protocolDir = new File(jtestRoot + File.separator + "protocols");
        File directory = protocolDir;
        File basefile = new File(directory, "PerlDBDTest.prt");
        if (basefile.exists()) {
            File tempfile = PerlDBDTest.makeTempFile("PerlDBDTest", ".prt", directory);
            basefile.renameTo(tempfile);
            PerlDBDTest.addGlobalMessage((String)"", (char)'I', (String)("Renaming old protocol file PerlDBDTest.prt to " + tempfile.getCanonicalPath()));
        }
        protocolStreamName = basefile.getCanonicalPath();
        FileOutputStream fs = new FileOutputStream(basefile);
        protocolStream = new PrintStream(fs);
        protocolStream.println("----------------------------------------------------------------------");
        protocolStream.println("PerlDBDTest started on " + new Date());
        protocolStream.println("----------------------------------------------------------------------");
    }

    private static File makeTempFile(String prefix, String suffix, File directory) {
        int idx = 1;
        while (true) {
            String istr = Integer.toString(idx);
            String tname = prefix + "0000".substring(0, 4 - istr.length()) + istr + suffix;
            File f = new File(directory, tname);
            if (!f.exists()) {
                return f;
            }
            ++idx;
        }
    }

    public String getLogFile() {
        return protocolStreamName;
    }

    static {
        semaphore = new Object();
    }
}

