/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.interfaces;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ListIterator;

public class Odbc
extends TestCase {
    static final String DATA_SOURCE_NAME = "SAPODBCTest";
    private static String sTestCaller;
    private static String sDevTool;
    private static String sFileSep;
    static int sTimeout;
    private static boolean sTrace;
    private static ArrayList sSingleTestList;
    private static boolean SSLisActive;

    public static long getTimeout() {
        return 0L;
    }

    public static void cleanUp() {
        String cmd = "perl " + sDevTool + sFileSep + "bin" + sFileSep + "IfaGetProtDir.pl";
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.exec();
        Odbc.addGlobalMessage((String)"", (char)'I', (String)("Test individual protocols are written to " + sb.toString()));
    }

    public String getLogFile() {
        String cmd = "perl " + sDevTool + sFileSep + "bin" + sFileSep + "IfaGetProtDir.pl";
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.exec();
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\n' || sb.charAt(i) == '\r') {
                sb.deleteCharAt(i--);
                continue;
            }
            if (sb.charAt(i) == '\\' && sFileSep.equalsIgnoreCase("/")) {
                sb.replace(i, i + 1, "/");
                continue;
            }
            if (sb.charAt(i) != '/' || !sFileSep.equalsIgnoreCase("\\")) continue;
            sb.replace(i, i + 1, "\\");
        }
        String protocolPath = sb.toString().trim();
        protocolPath = protocolPath.substring(0, protocolPath.length() - 4);
        protocolPath = protocolPath + File.separator + "dif";
        System.out.println("Create a zip file with relevant test files (*.t, *.o, *.l) from '" + protocolPath + "'.");
        File theZipFile = null;
        theZipFile = SSLisActive ? new File(this.getDataOutputPath() + File.separator + "interfaces_prot_ssl.zip") : new File(this.getDataOutputPath() + File.separator + "interfaces_prot.zip");
        Zipper myZipper = new Zipper(theZipFile);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".t") || name.endsWith(".o") || name.endsWith(".l");
            }
        };
        File[] filelist = new File(protocolPath).listFiles(filter);
        myZipper.addFiles(filelist);
        protocolPath = sb.toString().trim();
        myZipper.addFile(new File(protocolPath + File.separator + "pctest.prot"));
        myZipper.addFile(new File(protocolPath + File.separator + "pctest.prot.html"));
        try {
            protocolPath = protocolPath.substring(0, protocolPath.length() - 4);
            myZipper.setRootDirectory(new File(protocolPath));
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage("ODBC", 'W', "Failed to create a zipfile with the protocol files\n" + e.getLocalizedMessage());
            return protocolPath + File.separator + "pctest.prot.html";
        }
        return theZipFile.getAbsolutePath();
    }

    private int execSingleTest(String pCmd) {
        int rc;
        String cmd = sTestCaller + " " + pCmd;
        System.out.println("Running: " + cmd);
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.enableWritingStdout(sTrace);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.setTimeout(sTimeout);
        exc.exec();
        if (exc.isDestroyed()) {
            this.addMessage("", 'W', "Subprocess: " + cmd + " has been destroyed after timeout");
        }
        if ((rc = exc.getExitValue()) > 255) {
            rc -= 65536;
        } else if (rc > 127) {
            rc -= 256;
        }
        if (rc == 0) {
            this.addMessage("", 'I', cmd + " successful!");
        } else if (rc > 0) {
            this.addMessage("", 'W', cmd + " => RC = " + rc);
        } else if (rc < 0) {
            this.addMessage("", 'E', cmd + " => RC = " + rc);
        }
        if (sb != null && sb.length() > 0) {
            this.addMessage("", 'I', sb.toString());
        }
        return rc;
    }

    private int execSingleTest(String pCmd, int pNumber, int pMaxNumber) {
        int rc;
        String cmd = sTestCaller + " " + pCmd;
        System.out.println("Running " + pNumber + "(" + pMaxNumber + "): " + cmd);
        this.addMessage("", 'I', "Running " + pNumber + "(" + pMaxNumber + "): " + cmd);
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.enableWritingStdout(sTrace);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.setTimeout(sTimeout);
        exc.exec();
        if (exc.isDestroyed()) {
            this.addMessage("", 'W', "Subprocess: " + cmd + " has been destroyed after timeout");
        }
        if ((rc = exc.getExitValue()) > 255) {
            rc -= 65536;
        } else if (rc > 127) {
            rc -= 256;
        }
        if (rc == 0) {
            this.addMessage("", 'I', cmd + " successful!");
        } else if (rc == 11) {
            this.addMessage("", 'T', cmd + " returns with rc = 11; start again");
            int numberOfLoop = 0;
            do {
                System.out.println("Running " + pNumber + "(" + pMaxNumber + "): " + cmd + " again");
                ++numberOfLoop;
                sb = new StringBuffer();
                exc = new Execute(cmd, null, sb);
                exc.enableWritingStdout(sTrace);
                exc.setErrPrefix("STDERR ");
                exc.setOutPrefix("STDOUT ");
                exc.setTimeout(sTimeout);
                exc.exec();
            } while ((rc = exc.getExitValue()) == 11 && numberOfLoop < 5);
            if (numberOfLoop == 5) {
                this.addMessage("", 'W', " Executed " + cmd + " and received the returncode 11 five times!");
            } else if (rc > 0) {
                this.addMessage("", 'W', cmd + " => RC = " + rc);
            } else if (rc < 0) {
                this.addMessage("", 'E', cmd + " => RC = " + rc);
            } else if (rc == 0) {
                this.addMessage("", 'I', cmd + " successful!");
            }
        } else if (rc > 0) {
            this.addMessage("", 'W', cmd + " => RC = " + rc);
        } else if (rc < 0) {
            this.addMessage("", 'E', cmd + " => RC = " + rc);
        }
        if (sb != null && sb.length() > 0) {
            this.addMessage("", 'T', sb.toString());
        }
        return rc;
    }

    public static void prepare() throws TestCaseException {
        sDevTool = System.getProperty("env.tool");
        if (sDevTool == null) {
            sDevTool = Odbc.getParameterString((String)"TOOL", (String)"");
        }
        if (sDevTool == "") {
            Odbc.addGlobalMessage((String)"ODBC", (char)'E', (String)"Environment variable TOOL not defined.");
            throw new TestCaseException("Environment variable TOOL not defined");
        }
        String trace = Odbc.getParameterString((String)"TRACE", (String)"OFF");
        sTrace = trace.equalsIgnoreCase("ON") ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        sTimeout = Odbc.getParameterInt((String)"TIMEOUT", (int)300);
        String sslUri = Odbc.getParameterString((String)"SSLURI", (String)"NONE");
        String buildSSLUri = Odbc.getParameterString((String)"BUILDSSLURI", (String)"NO");
        if (buildSSLUri.equalsIgnoreCase("yes") || buildSSLUri.equalsIgnoreCase("true") || buildSSLUri.equalsIgnoreCase("on") || buildSSLUri.equalsIgnoreCase("1")) {
            if (sslUri.equalsIgnoreCase("NONE")) {
                Odbc.addGlobalMessage((String)"SSL", (char)'I', (String)("Override SSLURI: " + sslUri + "\nbecause parameter BUILDSSLURI is set to: " + buildSSLUri));
            }
            if (TestDriver.getOpSystem().substring(0, 3).equalsIgnoreCase("WIN")) {
                sslUri = "remotes://" + Odbc.getDatabase().getHost();
                sslUri = sslUri + "/database/" + Odbc.getDatabase().getName() + "?ignorehostnameinservercert";
            } else {
                sslUri = "remotes://" + Odbc.getDatabase().getHost() + ":";
                String niserverport = "96" + Integer.toString(Odbc.getDatabase().getPort()).substring(2);
                sslUri = sslUri + niserverport + "/" + Odbc.getDatabase().getName() + "?ignorehostnameinservercert";
            }
        }
        sSingleTestList = Odbc.getUnnamedParameterList();
        sFileSep = System.getProperty("file.separator");
        Odbc.addGlobalMessage((String)"Bugfixing", (char)'I', (String)("The value of getDatabase().getDBAUser() is :" + Odbc.getDatabase().getDBAUser()));
        Odbc.addGlobalMessage((String)"Bugfixing", (char)'I', (String)("The value of getDatabase().getDBAPassword() is :" + Odbc.getDatabase().getDBAPassword()));
        if (sslUri.equalsIgnoreCase("NONE")) {
            sTestCaller = "perl -S IfaTest.pl " + Odbc.getDatabase().getName() + " " + Odbc.getDatabase().getHost() + ":" + Odbc.getDatabase().getPort() + " " + Odbc.getDatabase().getDBAUser() + " " + Odbc.getDatabase().getDBAPassword();
        } else {
            SSLisActive = true;
            Odbc.addGlobalMessage((String)"SSL", (char)'I', (String)("used SSL URI: " + sslUri));
            sTestCaller = "perl -S IfaTest.pl " + Odbc.getDatabase().getName() + " " + sslUri + " " + Odbc.getDatabase().getDBAUser() + " " + Odbc.getDatabase().getDBAPassword();
        }
        int count = sSingleTestList.size();
        String cmd = "perl " + sDevTool + sFileSep + "bin" + sFileSep + "odbctest.pl -cleanup";
        StringBuffer sb = new StringBuffer();
        Execute exc = new Execute(cmd, null, sb);
        exc.enableWritingStdout(true);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.exec();
        int errorCode = 0;
        errorCode = exc.getExitValue();
        if (errorCode > 255) {
            errorCode -= 65536;
        } else if (errorCode > 127) {
            errorCode -= 256;
        }
        if (errorCode == 0) {
            Odbc.addGlobalMessage((String)"", (char)'I', (String)(cmd + " successful!"));
        } else {
            if (errorCode < 0) {
                Odbc.addGlobalMessage((String)"", (char)'E', (String)(cmd + " => RC = " + errorCode));
                Odbc.addGlobalMessage((String)"", (char)'E', (String)("Error in prepare. NO ODBC-tests ( " + count + " ) will be executed!"));
                if (sb != null && sb.length() > 0) {
                    Odbc.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
                }
                throw new TestCaseException("Error in prepare");
            }
            if (errorCode > 0) {
                Odbc.addGlobalMessage((String)"", (char)'W', (String)(cmd + " => RC = " + errorCode));
                Odbc.addGlobalMessage((String)"", (char)'W', (String)"Warning in prepare.");
            }
        }
        if (sb != null && sb.length() > 0) {
            Odbc.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
        }
        String prepareCall = Odbc.getParameterString((String)"PREPARE", (String)"-X odbc/initodbc -cprot");
        cmd = sTestCaller + " " + prepareCall;
        sb = new StringBuffer();
        exc = new Execute(cmd, null, sb);
        exc.enableWritingStdout(true);
        exc.setErrPrefix("STDERR ");
        exc.setOutPrefix("STDOUT ");
        exc.exec();
        errorCode = exc.getExitValue();
        if (errorCode > 255) {
            errorCode -= 65536;
        } else if (errorCode > 127) {
            errorCode -= 256;
        }
        if (errorCode == 0) {
            Odbc.addGlobalMessage((String)"", (char)'I', (String)(cmd + " successful!"));
        } else {
            if (errorCode < 0) {
                Odbc.addGlobalMessage((String)"", (char)'E', (String)(cmd + " => RC = " + errorCode));
                Odbc.addGlobalMessage((String)"", (char)'E', (String)("Error in prepare. NO ODBC-tests ( " + count + " ) will be executed!"));
                if (sb != null && sb.length() > 0) {
                    Odbc.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
                }
                throw new TestCaseException("Error in prepare");
            }
            if (errorCode > 0) {
                Odbc.addGlobalMessage((String)"", (char)'W', (String)(cmd + " => RC = " + errorCode));
                Odbc.addGlobalMessage((String)"", (char)'W', (String)"Warning in prepare.");
            }
        }
        if (sb != null && sb.length() > 0) {
            Odbc.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
        }
    }

    public void run() {
        if (sSingleTestList != null && !sSingleTestList.isEmpty()) {
            ListIterator it = sSingleTestList.listIterator();
            int counter = 0;
            int totalNumber = sSingleTestList.size();
            this.addMessage("", 'I', "Total number of single tests " + totalNumber);
            while (it.hasNext() && !this.isInterrupted()) {
                this.setStatus("Test " + ++counter + " of " + totalNumber);
                this.execSingleTest(((String)it.next()).trim(), counter, totalNumber);
            }
        }
        if (!this.isInterrupted()) {
            this.execSingleTest("-X odbc/endodbc");
        }
    }

    static {
        sTimeout = 0;
        sTrace = false;
        sSingleTestList = null;
        SSLisActive = false;
    }
}

