/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.innertransaction.sync;

import com.sap.sapdb.oltptest.innertransaction.InnerTransactionTest;
import com.sap.sapdb.oltptest.innertransaction.sync.SyncException;
import com.sap.sapdb.oltptest.innertransaction.sync.SyncThread;

public class SyncMaster {
    private SyncThread currentSyncThread;
    private int waitForThreads = 0;
    private int currentNumberOfThreads;
    private int currentSyncPointNumber;
    private long maximumWaitTime;
    private boolean endBecauseOfError = false;
    private boolean isOver = true;
    private InnerTransactionTest fatherTest;
    private int currentSequenceNumber;

    public SyncMaster(int currentNumberOfThreads, long maximumWaitTime, InnerTransactionTest fatherTest, int currentSequenceNumber) {
        this.currentNumberOfThreads = currentNumberOfThreads;
        this.maximumWaitTime = maximumWaitTime;
        this.fatherTest = fatherTest;
        this.currentSequenceNumber = currentSequenceNumber;
        this.currentSyncPointNumber = -1;
    }

    public synchronized void waitHere(int syncPointNumber) throws SyncException, InterruptedException {
        if (!this.endBecauseOfError) {
            if (syncPointNumber < this.currentSyncPointNumber) {
                return;
            }
            if (syncPointNumber == this.currentSyncPointNumber) {
                if (this.currentSyncThread != null) {
                    if (this.isOver) {
                        return;
                    }
                } else {
                    this.createNewSyncPoint();
                }
            }
            if (syncPointNumber > this.currentSyncPointNumber) {
                this.currentSyncPointNumber = syncPointNumber;
                this.createNewSyncPoint();
            }
            --this.waitForThreads;
            if (this.waitForThreads <= 0) {
                this.endCurrentSyncPoint();
            } else {
                this.wait();
            }
        } else {
            throw new SyncException("error during lifecycle of synchronisation master");
        }
    }

    public synchronized boolean isEndBecauseOfError() {
        return this.endBecauseOfError;
    }

    protected synchronized void setEndBecauseOfError() {
        this.endBecauseOfError = true;
    }

    public synchronized void endCurrentSyncPoint() {
        this.isOver = true;
        this.notifyAll();
        if (this.currentSyncThread != null) {
            this.currentSyncThread.comeToAnEnd();
        }
    }

    private void createNewSyncPoint() {
        this.endCurrentSyncPoint();
        this.waitForThreads = this.currentNumberOfThreads;
        this.currentSyncThread = new SyncThread(this.maximumWaitTime, this, this.fatherTest, this.currentSequenceNumber);
        this.isOver = false;
        this.currentSyncThread.start();
    }
}

