/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.innertransaction;

import com.sap.sapdb.oltptest.innertransaction.DBParameter;
import com.sap.sapdb.oltptest.innertransaction.DataForThread;
import com.sap.sapdb.oltptest.innertransaction.DataForTryToConnect;
import com.sap.sapdb.oltptest.innertransaction.InnerTransactionTestThread;
import com.sap.sapdb.oltptest.innertransaction.XmlErrorHandler;
import com.sap.sapdb.oltptest.innertransaction.statements.CheckStatement;
import com.sap.sapdb.oltptest.innertransaction.statements.CleanUpStatement;
import com.sap.sapdb.oltptest.innertransaction.statements.ExecuteStatement;
import com.sap.sapdb.oltptest.innertransaction.statements.ExecuteUpdateStatement;
import com.sap.sapdb.oltptest.innertransaction.statements.SyncStatement;
import com.sap.sapdb.oltptest.innertransaction.sync.SyncMaster;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InnerTransactionTest
extends TestCase {
    private static String defaultDefaultUserName = "JOJO";
    private static String defaultDefaultUserPass = "PUPS";
    private static boolean defaultKeepUser = false;
    private static int defaultProtocolLevel = 0;
    private static int[] defaultFatalErrors = new int[]{-813, -8888, -10821, -708};
    private static int defaultMaxNumberOfOccurredErrors = 50;
    private static String defaultDefaultUserType = "ressource not exclusive";
    private static long defaultMaximumWaitTime = 10000L;
    private int protocolLevel;

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void interruptAllThreads(InnerTransactionTestThread[] currentThreads) {
        for (int h1 = 0; h1 < currentThreads.length; ++h1) {
            if (currentThreads[h1] == null) continue;
            currentThreads[h1].interrupt();
        }
    }

    private ArrayList readXmlFileForTestCase(File xmlFile, String defaultUserName, String defaultUserType, String defaultUserPass, int currentTestCaseNumber, ArrayList newDbParameters, ArrayList attemptsToConnect) {
        ArrayList<DataForThread> result = new ArrayList<DataForThread>();
        this.ownAddMessage(-1, currentTestCaseNumber, -1, 1, 'I', "read xml file for test case " + currentTestCaseNumber + " : " + xmlFile.toString(), null);
        try {
            int currentNumberOfThreads = 0;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new XmlErrorHandler());
            Document xmlDocument = builder.parse(xmlFile);
            Element root = xmlDocument.getDocumentElement();
            NodeList nl = root.getChildNodes();
            for (int h1 = 0; h1 < nl.getLength(); ++h1) {
                Node passwordNode;
                String userName;
                NamedNodeMap attributes;
                Node currentNode = nl.item(h1);
                if (currentNode.getNodeType() == 1 && currentNode.getNodeName().equals("tryToConnect")) {
                    attributes = currentNode.getAttributes();
                    Node userNode = attributes.getNamedItem("userName");
                    String userName2 = userNode.getNodeValue();
                    Node passNode = attributes.getNamedItem("password");
                    String password = passNode.getNodeValue();
                    Node errorNode = attributes.getNamedItem("expectError");
                    boolean expectError = false;
                    try {
                        expectError = new Boolean(errorNode.getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    DataForTryToConnect dataForTryToConnect = new DataForTryToConnect(userName2, password, expectError);
                    attemptsToConnect.add(dataForTryToConnect);
                }
                if (currentNode.getNodeType() == 1 && currentNode.getNodeName().equals("db")) {
                    attributes = currentNode.getAttributes();
                    Node parameterNode = attributes.getNamedItem("parameter");
                    String parameter = parameterNode.getNodeValue();
                    Node valueNode = attributes.getNamedItem("value");
                    String value = valueNode.getNodeValue();
                    DBParameter dbParameter = new DBParameter(parameter, value);
                    newDbParameters.add(dbParameter);
                }
                if (currentNode.getNodeType() != 1 || !currentNode.getNodeName().equals("thread")) continue;
                attributes = currentNode.getAttributes();
                Node sequenceNode = attributes.getNamedItem("sequence");
                String sequence = sequenceNode.getNodeValue();
                Node nameNode = attributes.getNamedItem("userName");
                boolean useDefaultUserName = true;
                if (nameNode != null) {
                    userName = nameNode.getNodeValue();
                    useDefaultUserName = false;
                } else {
                    userName = defaultUserName + "_s" + currentTestCaseNumber + "_t";
                }
                Node typeNode = attributes.getNamedItem("userType");
                String userType = typeNode != null ? typeNode.getNodeValue() : defaultUserType;
                Node numberNode = attributes.getNamedItem("number");
                int numberOfThreads = 1;
                if (numberNode != null) {
                    try {
                        numberOfThreads = new Integer(numberNode.getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                Node createNode = attributes.getNamedItem("create");
                boolean createUser = true;
                if (createNode != null) {
                    try {
                        createUser = new Boolean(createNode.getNodeValue());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                String password = (passwordNode = attributes.getNamedItem("password")) != null ? passwordNode.getNodeValue() : defaultUserPass;
                for (int h2 = 0; h2 < numberOfThreads; ++h2) {
                    String currentUserName = "";
                    currentUserName = useDefaultUserName ? userName + currentNumberOfThreads : (numberOfThreads == 1 ? userName : userName + currentNumberOfThreads);
                    ++currentNumberOfThreads;
                    currentUserName = currentUserName.toUpperCase();
                    DataForThread userSeq = new DataForThread(sequence, currentUserName, userType, password, createUser);
                    result.add(userSeq);
                }
            }
        }
        catch (SAXException e) {
            this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "error during reading xml-file " + xmlFile.toString() + " (end test case) :" + e.getMessage(), null);
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "error during reading xml-file " + xmlFile.toString() + " (end test case) :" + e.getMessage(), null);
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "error during reading xml-file " + xmlFile.toString() + " (end test case) :" + e.getMessage(), null);
            e.printStackTrace();
            return null;
        }
        return result;
    }

    private ArrayList readXmlFileForThread(File currentXmlFile, int currentTestCaseNumber, int threadNumber) {
        ArrayList<Object> result = new ArrayList<Object>();
        this.ownAddMessage(-1, currentTestCaseNumber, -1, 1, 'I', "read xml file for thread " + threadNumber + " : " + currentXmlFile.toString(), null);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new XmlErrorHandler());
            Document xmlDocument = builder.parse(currentXmlFile);
            Element root = xmlDocument.getDocumentElement();
            NodeList nl = root.getChildNodes();
            for (int h1 = 0; h1 < nl.getLength(); ++h1) {
                String statement;
                Node currentNode = nl.item(h1);
                if (currentNode.getNodeType() != 1) continue;
                String nodeName = currentNode.getNodeName();
                NamedNodeMap attributes = currentNode.getAttributes();
                if (nodeName.equals("execute") || nodeName.equals("executeUpdate")) {
                    statement = attributes.getNamedItem("statement").getNodeValue();
                    Node errorNode = attributes.getNamedItem("error");
                    int error = 0;
                    if (errorNode != null) {
                        try {
                            error = new Integer(errorNode.getNodeValue());
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (nodeName.equals("execute")) {
                        ExecuteStatement s = new ExecuteStatement(statement, error);
                        result.add(s);
                    }
                    if (nodeName.equals("executeUpdate")) {
                        Node rowCountNode = attributes.getNamedItem("rowCount");
                        int rowCount = 0;
                        if (rowCountNode != null) {
                            try {
                                rowCount = new Integer(rowCountNode.getNodeValue());
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        ExecuteUpdateStatement s = new ExecuteUpdateStatement(statement, error, rowCount);
                        result.add(s);
                    }
                }
                if (nodeName.equals("check")) {
                    String select = attributes.getNamedItem("select").getNodeValue();
                    String resultS = null;
                    int rowCount = 0;
                    Node resultNode = attributes.getNamedItem("result");
                    if (resultNode != null) {
                        try {
                            rowCount = new Integer(resultNode.getNodeValue());
                        }
                        catch (NumberFormatException e) {
                            resultS = resultNode.getNodeValue();
                        }
                    }
                    CheckStatement s = new CheckStatement(select, resultS, rowCount);
                    result.add(s);
                }
                if (nodeName.equals("sync")) {
                    SyncStatement s = new SyncStatement();
                    result.add(s);
                }
                if (!nodeName.equals("cleanUp")) continue;
                statement = attributes.getNamedItem("statement").getNodeValue();
                CleanUpStatement s = new CleanUpStatement(statement);
                result.add(s);
            }
        }
        catch (SAXException e) {
            this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "error during reading xml-file " + currentXmlFile.toString() + " (do not start thread) :" + e.getMessage(), null);
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "error during reading xml-file " + currentXmlFile.toString() + " (do not start thread) :" + e.getMessage(), null);
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "error during reading xml-file " + currentXmlFile.toString() + " (do not start thread) :" + e.getMessage(), null);
            e.printStackTrace();
            return null;
        }
        return result;
    }

    private boolean checkSqlException(int errorCode, int[] fatalErrors) {
        if (fatalErrors != null) {
            for (int h1 = 0; h1 < fatalErrors.length; ++h1) {
                if (errorCode != fatalErrors[h1]) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dropAllUsers(ArrayList createdUser, int[] fatalErrors) {
        block56: {
            if (createdUser.size() > 0) {
                Connection masterConnection = null;
                TestStatement masterStatement = null;
                String currentUserName = "";
                masterConnection = InnerTransactionTest.getDatabase().connect(InnerTransactionTest.getUser(), InnerTransactionTest.getPassword());
                masterStatement = new TestStatement(null, masterConnection);
                if (this.protocolLevel == 0) {
                    this.ownAddMessage(-1, -1, -1, 0, 'I', "drop users (" + createdUser.size() + ")", null);
                }
                for (int h1 = 0; h1 < createdUser.size(); ++h1) {
                    currentUserName = (String)createdUser.get(h1);
                    if (this.protocolLevel >= 0) {
                        this.ownAddMessage(-1, -1, -1, 0, 'I', "drop user " + currentUserName, null);
                    }
                    masterStatement.executeUpdate("drop user " + currentUserName);
                }
                Object var8_10 = null;
                System.out.println("Debug: in finally");
                try {
                    masterStatement.close();
                }
                catch (NullPointerException e2) {
                }
                catch (SQLException e2) {
                    if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement : " + e2.getMessage(), null);
                    } else {
                        this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close statement : " + e2.getMessage(), null);
                    }
                    e2.printStackTrace();
                }
                try {
                    masterConnection.close();
                }
                catch (NullPointerException e2) {
                }
                catch (SQLException e2) {
                    if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection : " + e2.getMessage(), null);
                    } else {
                        this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close connection : " + e2.getMessage(), null);
                    }
                    e2.printStackTrace();
                }
                System.out.println("Debug: out finally");
                {
                    break block56;
                    catch (TestDatabaseException e) {
                        this.ownAddMessage(-1, -1, -1, 0, 'E', "error during dropping user " + currentUserName + " : " + e.getMessage(), null);
                        e.printStackTrace();
                        Object var8_11 = null;
                        System.out.println("Debug: in finally");
                        try {
                            masterStatement.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement : " + e2.getMessage(), null);
                            } else {
                                this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close statement : " + e2.getMessage(), null);
                            }
                            e2.printStackTrace();
                        }
                        try {
                            masterConnection.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection : " + e2.getMessage(), null);
                            } else {
                                this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close connection : " + e2.getMessage(), null);
                            }
                            e2.printStackTrace();
                        }
                        System.out.println("Debug: out finally");
                        break block56;
                    }
                    catch (SQLException e) {
                        if (this.checkSqlException(e.getErrorCode(), fatalErrors)) {
                            this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error during dropping user " + currentUserName + " : " + e.getMessage(), null);
                        } else {
                            this.ownAddMessage(-1, -1, -1, 0, 'E', "error during dropping user " + currentUserName + " : " + e.getMessage(), null);
                        }
                        e.printStackTrace();
                        Object var8_12 = null;
                        System.out.println("Debug: in finally");
                        try {
                            masterStatement.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement : " + e2.getMessage(), null);
                            } else {
                                this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close statement : " + e2.getMessage(), null);
                            }
                            e2.printStackTrace();
                        }
                        try {
                            masterConnection.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection : " + e2.getMessage(), null);
                            } else {
                                this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close connection : " + e2.getMessage(), null);
                            }
                            e2.printStackTrace();
                        }
                        System.out.println("Debug: out finally");
                        break block56;
                    }
                    catch (Exception e) {
                        this.ownAddMessage(-1, -1, -1, 0, 'W', "error during dropping user " + currentUserName + " : " + e.getMessage(), null);
                        e.printStackTrace();
                        Object var8_13 = null;
                        System.out.println("Debug: in finally");
                        try {
                            masterStatement.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement : " + e2.getMessage(), null);
                            } else {
                                this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close statement : " + e2.getMessage(), null);
                            }
                            e2.printStackTrace();
                        }
                        try {
                            masterConnection.close();
                        }
                        catch (NullPointerException e2) {
                        }
                        catch (SQLException e2) {
                            if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                                this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection : " + e2.getMessage(), null);
                            } else {
                                this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close connection : " + e2.getMessage(), null);
                            }
                            e2.printStackTrace();
                        }
                        System.out.println("Debug: out finally");
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    System.out.println("Debug: in finally");
                    try {
                        masterStatement.close();
                    }
                    catch (NullPointerException e2) {
                    }
                    catch (SQLException e2) {
                        if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                            this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close statement : " + e2.getMessage(), null);
                        } else {
                            this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close statement : " + e2.getMessage(), null);
                        }
                        e2.printStackTrace();
                    }
                    try {
                        masterConnection.close();
                    }
                    catch (NullPointerException e2) {
                    }
                    catch (SQLException e2) {
                        if (this.checkSqlException(((SQLException)e2).getErrorCode(), fatalErrors)) {
                            this.ownAddMessage(-1, -1, -1, 0, 'E', "fatal error while trying to close connection : " + e2.getMessage(), null);
                        } else {
                            this.ownAddMessage(-1, -1, -1, 0, 'W', "error while trying to close connection : " + e2.getMessage(), null);
                        }
                        e2.printStackTrace();
                    }
                    System.out.println("Debug: out finally");
                    throw throwable;
                }
            }
        }
    }

    private int[] splitStringToIntArray(String fatalErrorsString) {
        int[] result;
        StringTokenizer tokenizer = new StringTokenizer(fatalErrorsString, ",;|.");
        int[] tmpResult = new int[tokenizer.countTokens()];
        int h1 = 0;
        int errors = 0;
        while (tokenizer.hasMoreTokens()) {
            try {
                tmpResult[h1] = 0;
                Integer integer = new Integer(tokenizer.nextToken());
                tmpResult[h1] = integer;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (tmpResult[h1++] != 0) continue;
            ++errors;
        }
        if (tmpResult.length - errors > 0) {
            result = new int[tmpResult.length - errors];
            for (h1 = 0; h1 < result.length; ++h1) {
                if (tmpResult[h1] == 0) continue;
                result[h1] = tmpResult[h1];
            }
        } else {
            result = new int[]{};
        }
        return result;
    }

    private String intArrayToString(int[] array) {
        if (array != null) {
            StringBuffer result = new StringBuffer();
            for (int h1 = 0; h1 < array.length; ++h1) {
                if (h1 + 1 < array.length) {
                    result.append(array[h1] + ", ");
                    continue;
                }
                result.append(array[h1]);
            }
            return result.toString();
        }
        return new String("");
    }

    private void setMaxDbParameters(ArrayList newDbParameters, int currentTestCaseNumber, ArrayList oldDbParameters) {
        if (newDbParameters != null) {
            TestDatabaseSap maxDb = null;
            try {
                maxDb = (TestDatabaseSap)InnerTransactionTest.getDatabase();
                for (int h1 = 0; h1 < newDbParameters.size(); ++h1) {
                    DBParameter currentParameter = (DBParameter)newDbParameters.get(h1);
                    String currentParameterName = currentParameter.getParameter();
                    String currentParameterValue = currentParameter.getValue();
                    String oldParameterValue = maxDb.getParameter(currentParameterName);
                    if (!oldParameterValue.equals(currentParameterValue)) {
                        this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'I', "set db parameter " + currentParameterName + " : " + currentParameterValue, null);
                        DBParameter saveParameter = new DBParameter(currentParameterName, oldParameterValue);
                        if (oldDbParameters != null) {
                            oldDbParameters.add(saveParameter);
                        }
                        maxDb.setParameter(currentParameterName, currentParameterValue);
                        continue;
                    }
                    this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'I', "db parameter " + currentParameterName + " is already : " + currentParameterValue, null);
                }
            }
            catch (ClassCastException e) {
                this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "database is no maxDB: can not set parameters (end test case) : " + e.getMessage(), null);
                e.printStackTrace();
            }
            catch (TestDatabaseException e) {
                this.ownAddMessage(-1, currentTestCaseNumber, -1, 0, 'W', "error during setting db parameters : " + e.getMessage(), null);
                e.printStackTrace();
            }
        }
    }

    private void cleanUpTestCase(InnerTransactionTestThread[] currentThreads, SyncMaster currentSyncMaster, ArrayList oldDbParameters, int currentTestCaseNumber) {
        if (currentThreads != null) {
            this.interruptAllThreads(currentThreads);
        }
        if (currentSyncMaster != null) {
            currentSyncMaster.endCurrentSyncPoint();
        }
        if (oldDbParameters != null) {
            this.setMaxDbParameters(oldDbParameters, currentTestCaseNumber, null);
        }
    }

    public synchronized void ownAddMessage(int threadNo, int testCaseNo, int statementNo, int priority, char messageType, String messageText, String statement) {
        if (priority <= this.protocolLevel) {
            StringBuffer messageId = new StringBuffer("");
            if (threadNo != -1 || testCaseNo != -1 || statementNo != -1) {
                DecimalFormat df;
                messageId.append("(");
                if (threadNo != -1) {
                    df = new DecimalFormat("000");
                    messageId.append("thr " + df.format(threadNo) + ",");
                } else {
                    messageId.append("     - ,");
                }
                if (testCaseNo != -1) {
                    df = new DecimalFormat("000");
                    messageId.append("case " + df.format(testCaseNo) + ",");
                } else {
                    messageId.append("      - ,");
                }
                if (statementNo != -1) {
                    df = new DecimalFormat("0000");
                    messageId.append("sta " + df.format(statementNo));
                } else {
                    messageId.append("      - ");
                }
                if (this.protocolLevel < 2 && statement != null && !statement.equals("")) {
                    messageId.append(" : " + statement);
                }
                messageId.append(")");
            }
            if (messageType == 'E') {
                System.out.println(messageId + "ERROR   : " + messageText);
                this.addMessage(messageId.toString(), 'E', messageText);
            }
            if (messageType == 'W') {
                System.out.println(messageId + "WARNING : " + messageText);
                this.addMessage(messageId.toString(), 'W', messageText);
            }
            if (messageType == 'I') {
                System.out.println(messageId + "INFO    : " + messageText);
                this.addMessage(messageId.toString(), 'I', messageText);
            }
        }
    }

    protected synchronized Connection threadConnect(String userName, String userPass) throws TestDatabaseException {
        Properties connectProp = new Properties();
        connectProp.put("user", userName);
        connectProp.put("password", userPass);
        connectProp.put("autocommit", "off");
        Connection c = InnerTransactionTest.getDatabase().connect(connectProp);
        return c;
    }
}

