/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class View
extends Relation {
    String definition;
    String select;
    List expectedExplain;

    public View(String name_init, String definition_init) {
        super(name_init);
        this.definition = definition_init;
        this.select = "select * from " + this.name;
    }

    String displayName() {
        return "View " + this.name;
    }

    void init(Connection session) throws SQLException {
        Util.sql(session, "CREATE OR REPLACE VIEW " + this.name + " AS " + this.definition);
        this.expectedOutput = Util.select(session, this.select);
        this.expectedExplain = Util.explainQueryRewrite(session, this.select);
    }

    void drop(Connection session) throws SQLException {
        Util.sql(session, "DROP VIEW " + this.name, -4004);
    }

    String simpleCompare(Connection session) throws SQLException {
        List actualOutput = Util.select(session, this.select);
        String result = this.compare(this.expectedOutput, actualOutput);
        if (result == null) {
            actualOutput = Util.explainQueryRewrite(session, this.select);
            result = this.compare(this.expectedExplain, actualOutput);
        }
        return result;
    }

    void showActual(Connection session) throws SQLException {
        Util.showActual(session, this.displayName(), "SELECT * from " + this.name);
    }
}

