/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.testframe.testcase.TestCase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Util {
    static TestCase logger = null;
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Util() {
    }

    static void setLogger(TestCase logger_init) {
        logger = logger_init;
    }

    public static List split(String input) {
        return Util.split(input, ',');
    }

    public static List split(String input, char delimiter) {
        String nextval;
        int delimPos;
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while ((delimPos = input.indexOf(delimiter, pos)) != -1) {
            nextval = input.substring(pos, delimPos);
            result.add(nextval);
            pos = delimPos + 1;
        }
        nextval = input.substring(pos);
        result.add(nextval);
        return result;
    }

    public static String join(Collection coll, String realDelimiter) {
        String delimiter = "";
        StringBuffer result = new StringBuffer();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            result.append(delimiter);
            result.append((String)iter.next());
            delimiter = realDelimiter;
        }
        return result.toString();
    }

    public static String join(Collection coll) {
        return Util.join(coll, " ");
    }

    public static String joinAsLiterals(Collection coll) {
        String delimiter = "";
        StringBuffer result = new StringBuffer();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            result.append(delimiter);
            result.append("'");
            result.append((String)iter.next());
            result.append("'");
            delimiter = ", ";
        }
        return result.toString();
    }

    public static String fillIn(String template, String[][] mapping) {
        String result = template;
        for (int i = 0; i < mapping.length; ++i) {
            String search = "<" + mapping[i][0] + ">";
            String replace = mapping[i][1];
            int pos = result.indexOf(search);
            if (pos < 0) continue;
            int matchlen = search.length();
            result = result.substring(0, pos) + replace + result.substring(pos + matchlen);
        }
        return result;
    }

    static ResultSet sql(Connection session, String sqlString) throws SQLException {
        return Util.sql(session, sqlString, 0);
    }

    static ResultSet sql(Connection session, String sqlString, int allowedRC) throws SQLException {
        ResultSet result = null;
        Statement stmt = session.createStatement();
        try {
            boolean hasCursor;
            if (logger != null) {
                logger.addMessage("SQL", 'I', sqlString);
                System.out.println("SQL:" + sqlString);
            }
            if (hasCursor = stmt.execute(sqlString)) {
                result = stmt.getResultSet();
            }
        }
        catch (SQLException sqlExc) {
            if (sqlExc.getErrorCode() == allowedRC) {
                if (logger != null) {
                    logger.addMessage("SQL Error", 'I', sqlExc.toString() + " (ignored)");
                    System.out.println("SQL Error: " + sqlExc.getMessage() + " (ignored)");
                }
                return null;
            }
            if (logger != null) {
                logger.addMessage("SQL Error", 'I', sqlExc.toString());
                System.out.println("SQL Error: " + sqlExc.getMessage());
            }
            throw sqlExc;
        }
        return result;
    }

    static List select(Connection session, String sqlCmd) throws SQLException {
        return Util.select(session, sqlCmd, false);
    }

    static List select(Connection session, String sqlCmd, boolean addColumnHeaders) throws SQLException {
        int i;
        ResultSet cursor = Util.sql(session, sqlCmd);
        ResultSetMetaData description = cursor.getMetaData();
        int fieldCount = description.getColumnCount();
        ArrayList<String> result = new ArrayList<String>();
        while (cursor.next()) {
            ArrayList<String> fields = new ArrayList<String>();
            block4: for (i = 1; i <= fieldCount; ++i) {
                switch (description.getColumnType(i)) {
                    case -2: {
                        fields.add(Util.toHexString(cursor.getBytes(i)));
                        continue block4;
                    }
                    default: {
                        fields.add(cursor.getString(i));
                    }
                }
            }
            result.add(Util.join(fields, ","));
        }
        Collections.sort(result);
        if (addColumnHeaders) {
            ArrayList<String> colnames = new ArrayList<String>();
            for (i = 1; i <= fieldCount; ++i) {
                colnames.add(description.getColumnLabel(i));
            }
            String headerline = Util.join(colnames, ",");
            result.add(0, headerline);
        }
        return result;
    }

    static void showActual(Connection session, String comment, String sqlCmd) throws SQLException {
        boolean addColumnHeaders = true;
        if (comment != null) {
            System.out.println(comment);
        }
        Iterator actualOutput = Util.select(session, sqlCmd, addColumnHeaders).iterator();
        if (addColumnHeaders) {
            System.out.println("H:" + actualOutput.next());
        }
        int index = 0;
        while (actualOutput.hasNext()) {
            System.out.println("" + ++index + ": " + actualOutput.next());
        }
    }

    static void showActual(Connection session, String sqlCmd) throws SQLException {
        Util.showActual(session, null, sqlCmd);
    }

    static List explainQueryRewrite(Connection session, String sqlCmd) throws SQLException {
        sqlCmd = "EXPLAIN " + sqlCmd;
        ResultSet cursor = Util.sql(session, sqlCmd);
        ResultSetMetaData description = cursor.getMetaData();
        int fieldCount = description.getColumnCount();
        ArrayList<String> result = new ArrayList<String>();
        boolean queryRewriteFound = false;
        while (!queryRewriteFound && cursor.next()) {
            String strategy = cursor.getString("STRATEGY");
            if (!strategy.startsWith("QUERYREWRITE")) continue;
            queryRewriteFound = true;
        }
        if (!queryRewriteFound) {
            return result;
        }
        int tablenameIndex = 2;
        do {
            ArrayList<String> fields = new ArrayList<String>();
            block5: for (int i = 1; i <= fieldCount; ++i) {
                if (i == 2) {
                    fields.add("CURSORNAME");
                    continue;
                }
                switch (description.getColumnType(i)) {
                    case -2: {
                        fields.add(Util.toHexString(cursor.getBytes(i)));
                        continue block5;
                    }
                    default: {
                        fields.add(cursor.getString(i));
                    }
                }
            }
            result.add(Util.join(fields, ","));
        } while (cursor.next());
        return result;
    }

    static String tableColumnsMinusLobs(Connection session, String tablename) throws SQLException {
        List cursor = Util.select(session, "select '" + tablename + ".' || COLUMNNAME from COLUMNS" + " where tablename = '" + tablename + "'" + " and Datatype not in  ('LOB', 'LONG')");
        return Util.join(cursor, ", ");
    }

    static String simpleClass(Object obj) {
        if (obj == null) {
            return "(null)";
        }
        String className = obj.getClass().getName();
        int dotindex = className.lastIndexOf(46);
        if (dotindex > 0) {
            className = className.substring(dotindex + 1);
        }
        return className;
    }

    public static String toHexString(byte[] b) {
        if (b == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        Connection session = DriverManager.getConnection("jdbc:sapdb:READ77", "DBA", "DBA");
        session.setAutoCommit(false);
        String columns = Util.tableColumnsMinusLobs(session, "TABLES");
        System.out.println("*** " + columns);
    }
}

