/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.Util;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class TableGroup {
    List tables;

    public TableGroup(Relation[] tables_init) {
        this.tables = Arrays.asList(tables_init);
    }

    public List tableNames() {
        Iterator iter = this.tables.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (iter.hasNext()) {
            Relation current = (Relation)iter.next();
            result.add(current.getName());
        }
        return result;
    }

    Relation findByName(String requested) {
        Iterator iter = this.tables.iterator();
        while (iter.hasNext()) {
            Relation current = (Relation)iter.next();
            if (!current.getName().equals(requested)) continue;
            return current;
        }
        return null;
    }

    public void init(Connection session) throws SQLException {
        Iterator iter = this.tables.iterator();
        while (iter.hasNext()) {
            Relation current = (Relation)iter.next();
            current.init(session);
        }
    }

    public void initForExport(Connection session, String schemaName) throws SQLException {
        if (schemaName != null) {
            Util.sql(session, "set current_schema = " + schemaName);
        }
        Iterator iter = this.tables.iterator();
        while (iter.hasNext()) {
            Relation current = (Relation)iter.next();
            current.initForExport(session);
        }
    }

    public void importAllIntoReader(Connection session, String schemaName) throws SQLException {
        Iterator iter = this.tables.iterator();
        while (iter.hasNext()) {
            Relation current = (Relation)iter.next();
            System.out.println("*** " + current);
            this.importOneIntoReader(session, schemaName, current);
        }
        session.commit();
    }

    public void importSpecificIntoReader(Connection session, String schemaName, Collection tables) throws SQLException {
        Iterator iter = tables.iterator();
        while (iter.hasNext()) {
            Relation current = (Relation)iter.next();
            this.importOneIntoReader(session, schemaName, current);
        }
        session.commit();
    }

    public void importSpecificIntoReader(Connection session, String schemaName, String tableNames) throws SQLException {
        List names = Util.split(tableNames);
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Relation current = this.findByName(name);
            if (current != null) {
                this.importOneIntoReader(session, schemaName, current);
                continue;
            }
            System.out.println("ERR: no table named " + name);
        }
    }

    private void importOneIntoReader(Connection session, String schemaName, Relation relation) throws SQLException {
        List repoSchemaPair = Util.split(schemaName, '.');
        String repository = (String)repoSchemaPair.get(0);
        String schema = (String)repoSchemaPair.get(1);
        String tableName = relation.getName();
        relation.drop(session);
        Util.sql(session, Util.fillIn("IMPORT TABLE <schema>.<providerTableName> FROM <repository> AS <readerTableName>", new String[][]{{"schema", schema}, {"providerTableName", tableName}, {"repository", repository}, {"readerTableName", tableName}}));
    }

    public boolean compareAll(Connection session, String comment, TestCase logger) throws SQLException {
        boolean noDiffs = true;
        Iterator iter = this.tables.iterator();
        while (iter.hasNext()) {
            Relation current = (Relation)iter.next();
            String diffResult = current.simpleCompare(session);
            if (diffResult == null) continue;
            logger.addMessage(comment, 'E', current.getName() + ": " + diffResult);
            noDiffs = false;
        }
        session.commit();
        return noDiffs;
    }
}

