/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.Util;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Table
extends Relation {
    List fieldDescriptions;
    List initialData;

    public Table(String name_init, String fields_init, String[] data_init) {
        super(name_init);
        this.fieldDescriptions = this.parseDefinition(fields_init, data_init);
        List<String> list = Arrays.asList(data_init);
        Collections.sort(list);
        this.initialData = list;
    }

    private List parseDefinition(String fields_init, String[] data_init) {
        return Util.split(fields_init);
    }

    String displayName() {
        return "Table " + this.name;
    }

    public void init(Connection session) throws SQLException {
        StringBuffer create = new StringBuffer("CREATE TABLE ");
        String qmarks = "";
        create.append(this.name);
        create.append(" (");
        Iterator iter = this.fieldDescriptions.iterator();
        String delimiter = "";
        while (iter.hasNext()) {
            String fieldname = (String)iter.next();
            create.append(delimiter);
            create.append(fieldname);
            create.append(" CHAR (20)");
            qmarks = qmarks + delimiter + "?";
            delimiter = ",";
        }
        create.append(" )");
        Util.sql(session, "DROP TABLE " + this.name, -4004);
        Util.sql(session, create.toString());
        String insertCmd = "INSERT INTO " + this.name + " VALUES (" + qmarks + ")";
        CallableStatement insert = session.prepareCall(insertCmd);
        Iterator rowiter = this.initialData.iterator();
        while (rowiter.hasNext()) {
            Iterator coliter = Util.split((String)rowiter.next()).iterator();
            int colindex = 1;
            while (coliter.hasNext()) {
                insert.setObject(colindex, coliter.next());
                ++colindex;
            }
            insert.executeUpdate();
        }
        session.commit();
        this.expectedOutput = this.initialData;
    }

    void drop(Connection session) throws SQLException {
        Util.sql(session, "DROP TABLE " + this.name, -4004);
    }

    String simpleCompare(Connection session) throws SQLException {
        List actual = Util.select(session, "SELECT * from " + this.name);
        return this.compare(this.initialData, actual);
    }

    void showActual(Connection session) throws SQLException {
        Util.showActual(session, this.displayName(), "SELECT * from " + this.name);
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        Connection session = DriverManager.getConnection("jdbc:sapdb:READ77", "DBA", "DBA");
        session.setAutoCommit(false);
        Table table = new Table("TEST", "a,b", new String[]{"1,x", "2,y", "3,z"});
        table.init(session);
        String diffResult = table.simpleCompare(session);
        if (diffResult == null) {
            System.out.println("OK compare");
        } else {
            System.out.println(diffResult);
        }
    }
}

