/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.AbstractSharedRepositoryCase;
import com.sap.sapdb.megatenant.Util;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class SharedRepositorySystemViews
extends AbstractSharedRepositoryCase {
    protected TestDatabaseSap providerDB;

    public static String getTestClassId() {
        return "SharedRepositorySystemViews";
    }

    protected void runX(Connection session) throws SQLException, TestDatabaseException {
        this.expectViewSize(session, "FILESYSTEMS", 1);
        this.expectViewSize(session, "DATAVOLUMES", 1);
        this.importShare(session);
        this.expectViewSize(session, "FILESYSTEMS", 2);
        this.expectViewSize(session, "DATAVOLUMES", 2);
        tables.importAllIntoReader(session, this.shareName + "." + "SHARABLE");
        this.expectContent("Join DATAVOLUMES FILESYSTEMS", session, "select * from DATAVOLUMES, FILESYSTEMS  where DATAVOLUMES.FILESYSTEMID = FILESYSTEMS.FILESYSTEMINDEX", this.shareName, 2);
        this.expectContent("Join FILES FILESYSTEMS", session, "select * from FILES, FILESYSTEMS  where FILESYSTEMS.FILESYSTEMINDEX = num (substr (FILES.FILEID, 1, 1))", this.shareName, -1);
        this.expectContent("Join TABLES FILESYSTEMS", session, "select " + Util.tableColumnsMinusLobs(session, "TABLES") + ", FILESYSTEMS.* from TABLES, FILESYSTEMS " + " where FILESYSTEMS.FILESYSTEMINDEX = num (substr (TABLES.TABLEID, 1, 1))", this.shareName, -1);
        session.rollback();
    }

    boolean expectViewSize(Connection session, String tablename, int expectedSize) throws SQLException {
        boolean result = true;
        String select = "select * from " + tablename;
        int rowcount = Util.select(session, select).size();
        if (rowcount != expectedSize) {
            this.logError("Table " + tablename + ": has " + rowcount + " rows, expected " + expectedSize);
            Util.showActual(session, select);
            result = false;
        }
        return result;
    }

    boolean expectContent(String comment, Connection session, String select, String searchString, int expectedSize) throws SQLException {
        List rows = Util.select(session, select);
        int rowcount = rows.size();
        if (rowcount == 0) {
            this.logError("SELECT " + comment + " is empty");
        }
        if (expectedSize > 0 && rowcount != expectedSize) {
            this.logError("SELECT " + comment + " has " + rowcount + " rows, expected " + expectedSize);
            Util.showActual(session, select);
        }
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            String current = (String)iter.next();
            if (current.indexOf(searchString) == -1) continue;
            return true;
        }
        this.logError("SELECT " + comment + " has no data '" + searchString + "'");
        Util.showActual(session, select);
        return false;
    }
}

