/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.AbstractSharedRepositoryCase;
import com.sap.sapdb.megatenant.QueryGroup;
import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.TestQuery;
import com.sap.sapdb.megatenant.TestView;
import com.sap.sapdb.megatenant.Util;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import java.sql.Connection;
import java.sql.SQLException;

public class SharedRepositorySQL
extends AbstractSharedRepositoryCase {
    protected TestDatabaseSap providerDB;

    public static String getTestClassId() {
        return "SharedRepositorySQL";
    }

    protected void runX(Connection session) throws SQLException, TestDatabaseException {
        TestQuery simpleJoin = new TestQuery("simple join", "SELECT PRODUCTID, COLORNAME from COLORS, PRODUCTS where PRODUCTS.COLORID = COLORS.COLORID");
        TestQuery throughView = new TestQuery("through view", "SELECT * FROM PRODUCTSX");
        TestView redundantView = new TestView("REDUNDANTPRODUCTS", "select  PRODUCTID, COLORS.COLORID from COLORS, PRODUCTSX where COLORS.COLORNAME = PRODUCTSX.COLORNAME");
        Relation[] queryArray = new Relation[]{simpleJoin, throughView, redundantView, null};
        QueryGroup queries = new QueryGroup(queryArray);
        tables.init(session);
        queries.init(session);
        session.commit();
        this.importShare(session);
        String[] importTables = new String[]{"PRODUCTSX", "COLORS"};
        for (int i = 0; i < importTables.length; ++i) {
            tables.importSpecificIntoReader(session, this.shareName + "." + "SHARABLE", importTables[i]);
            queries.compareAll(session, "after importing " + importTables[i], this);
        }
        session.commit();
        queries.compareAll(session, "SQL", this);
        Util.sql(session, "DELETE from PRODUCTS");
        int rowcount = Util.select(session, "select * from PRODUCTSX").size();
        if (rowcount == 0) {
            this.logError("imported view PRODUCTSX seems to select from private (empty) table PRODUCTS");
        }
        session.rollback();
    }
}

