/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.AbstractSharedRepositoryCase;
import com.sap.sapdb.megatenant.KernelMessages;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import java.sql.Connection;
import java.sql.SQLException;

public class SharedRepositoryRobustness
extends AbstractSharedRepositoryCase {
    protected void runX(Connection session) throws SQLException, TestDatabaseException {
        this.providerDoesntExists();
    }

    boolean providerDoesntExists() throws TestDatabaseException, SQLException {
        String testid = "provider doesn't exist";
        TestDatabaseSap reader = (TestDatabaseSap)this.getDatabase();
        Connection session = reader.connect();
        this.expectSqlError(session, "IMPORT SHARED REPOSITORY 'NOTEXIST' AS SHAREDUMMY SNAPSHOT 1", -8080);
        this.checkForKernelMessage(reader, testid, new KernelMessages.EntryPattern("ERR", "RTE", 20035, "Parameter KERNELVERSION not found"));
        session.rollback();
        return false;
    }

    boolean providerChangedSnapshot() throws TestDatabaseException, SQLException {
        String testid = "provider new snapshot";
        TestDatabaseSap reader = (TestDatabaseSap)this.getDatabase();
        reader.executeDBMcmd("db_offline");
        return false;
    }

    boolean providerDropped() throws TestDatabaseException, SQLException {
        String testid = "provider dropped";
        boolean testSucceeds = false;
        TestDatabaseSap reader = (TestDatabaseSap)this.getDatabase();
        reader.executeDBMcmd("db_offline");
        providerDB.executeDBMcmd("db_offline");
        providerDB.executeDBMcmd("db_drop");
        try {
            reader.executeDBMcmd("db_online");
            this.logError(testid, "db shouldn't be online when provider is not available");
        }
        catch (TestDatabaseException tdbExc) {
            testSucceeds = this.checkForKernelMessage(reader, testid, new KernelMessages.EntryPattern("ERR", "RTE", 20035, "Parameter _PAGE_SIZE not found"));
        }
        return testSucceeds;
    }

    boolean checkForKernelMessage(TestDatabaseSap reader, String testid, KernelMessages.EntryPattern pattern) {
        boolean messageFound = false;
        String fileContent = null;
        try {
            fileContent = reader.getDatabaseProtocolViaDBMKey("KNLMSG");
        }
        catch (Exception exc) {
            this.logError(testid, "failed to get kernel messages");
        }
        if (fileContent != null) {
            KernelMessages messages = new KernelMessages(fileContent);
            KernelMessages.Entry match = messages.nextMatch(pattern);
            if (match == null) {
                this.logError(testid, "missing kernel message: " + pattern);
            } else {
                messageFound = true;
                this.log(testid, "found expected message " + pattern);
            }
        }
        return messageFound;
    }
}

