/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.AbstractSharedRepositoryCase;
import com.sap.sapdb.megatenant.LobTable;
import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.TableGroup;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.sql.Connection;
import java.sql.SQLException;

public class SharedRepositoryLocalUpdates
extends AbstractSharedRepositoryCase {
    public static String getTestClassId() {
        return "SharedRepositoryLocalUpdates";
    }

    protected void runX(Connection session) throws SQLException, TestDatabaseException {
        String providerName = this.createProvider(null);
        this.importShare(session);
        TableGroup lobTables = new TableGroup(new Relation[]{this.lobTable});
        lobTables.importAllIntoReader(session, this.shareName + "." + "SHARABLE");
        session.commit();
        LobTable table2 = new LobTable("LOBS2");
        table2.init(session);
        session.commit();
        LobTable[] lobtables = new LobTable[]{this.lobTable, table2};
        String checkMessage = this.lobTable.compareWithTable(session, table2.getName());
        if (checkMessage != null) {
            this.logError("import data", checkMessage);
            return;
        }
        if (!this.updateAndCheck(session, lobtables, 1, false, "rollback local updates")) {
            return;
        }
        if (!this.updateAndCheck(session, lobtables, 1, true, "commit local updates")) {
            return;
        }
        if (!this.updateAndCheck(session, lobtables, 2, true, "update rows a second time")) {
            return;
        }
    }

    boolean updateAndCheck(Connection session, LobTable[] lobtables, int step, boolean doCommit, String testname) throws SQLException {
        for (int i = 0; i < lobtables.length; ++i) {
            boolean updateOK = lobtables[i].updateTable(session, step, this);
            if (updateOK) continue;
            return false;
        }
        if (doCommit) {
            session.commit();
        } else {
            session.rollback();
        }
        String checkMessage = lobtables[0].compareWithTable(session, lobtables[1].getName());
        if (checkMessage != null) {
            this.logError(testname, checkMessage);
            return false;
        }
        return true;
    }
}

