/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.AbstractSharedRepositoryCase;
import com.sap.sapdb.megatenant.QueryGroup;
import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.TestQuery;
import com.sap.sapdb.megatenant.Util;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SharedRepositoryCatalog
extends AbstractSharedRepositoryCase {
    protected TestDatabaseSap providerDB;

    public static String getTestClassId() {
        return "SharedRepositoryCatalog";
    }

    protected void runX(Connection session) throws SQLException, TestDatabaseException {
        String tableNames = Util.joinAsLiterals(tables.tableNames());
        TestQuery tableListing = new TestQuery("Tables", "SELECT SCHEMANAME, OWNER, TABLENAME, TYPE, TABLETYPE from tables where tablename in (" + tableNames + ")");
        TestQuery columnListing = new TestQuery("COLUMNS", "SELECT SCHEMANAME, OWNER, TABLENAME, COLUMNNAME, MODE, DATATYPE, CODETYPE, LEN, DEC, NULLABLE, \"DEFAULT\", POS, TABLETYPE from columns where tablename in (" + tableNames + ")");
        TestQuery filesjoin = new TestQuery("FILESJOIN", "select SCHEMANAME, OWNER, TABLENAME, PRIVILEGES, TABLES.TYPE, TABLETYPE, UNLOADED, SAMPLE_PERCENT, SAMPLE_ROWS, TABLES.DYNAMIC, ARCHIVE, VARIABLE_COLUMNS, SESSIONID, FILES.TYPE, HEX (PRIMARYFILEID) PRIMARYFILEID, FILESTATE, ENTRYCOUNT, TREEINDEXSIZE, TREELEAVESSIZE, LOBSIZE, CLUSTERED, FILES.DYNAMIC, PACKED from tables, files where tableid = fileid and tablename in (" + tableNames + ")");
        QueryGroup queries = new QueryGroup(new Relation[]{tableListing, columnListing, filesjoin});
        TestQuery currentTest = filesjoin;
        tables.init(session);
        this.addGenericCatalogQueries(queries, session, tableNames);
        queries.init(session);
        session.commit();
        this.importShare(session);
        tables.importAllIntoReader(session, this.shareName + "." + "SHARABLE");
        queries.compareAll(session, "Catalog", this);
    }

    List findCatalogTables(Connection session) throws SQLException {
        return Util.select(session, "select tablename from columns where columnname = 'TABLENAME'");
    }

    void addGenericCatalogQueries(QueryGroup queries, Connection session, String dataTableNames) throws SQLException {
        HashSet<String> tablesToIgnore = new HashSet<String>(Arrays.asList("SYSUPDSTATWANTED", "LOCKS", "LOCKSTATISTICS", "LOCK_HOLDER"));
        Iterator tablenames = this.findCatalogTables(session).iterator();
        while (tablenames.hasNext()) {
            String tablename = (String)tablenames.next();
            if (tablesToIgnore.contains(tablename)) continue;
            String cmd = "select count (*), tablename from " + tablename + " where tablename in (" + dataTableNames + ") group by tablename";
            queries.add(new TestQuery(tablename, cmd));
        }
    }
}

