/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.AbstractSharedRepositoryCase;
import com.sap.sapdb.megatenant.Util;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import java.sql.Connection;
import java.sql.SQLException;

public class SharedRepositoryBasics
extends AbstractSharedRepositoryCase {
    public static String getTestClassId() {
        return "SharedRepositoryBasics";
    }

    protected void runX(Connection session) throws SQLException, TestDatabaseException {
        String providerName = this.createProvider(null);
        tables.init(session);
        this.importShare(session);
        tables.importAllIntoReader(session, this.shareName + "." + "SHARABLE");
        tables.compareAll(session, "after import", this);
        session.commit();
        this.testUpdates(session);
        this.testImportFromSameSchema(session);
        session.close();
        TestDatabase reader = this.getDatabase();
        reader.executeDBMcmd("db_offline");
        reader.executeDBMcmd("db_online");
        session = reader.connect();
        tables.compareAll(session, "after restart", this);
        this.dropShare(session);
        this.expectSqlError(session, "EXISTS TABLE COLORS", -4004);
        String cmd = "select * from DATAVOLUMES where FILESYSTEMID > 0";
        if (Util.select(session, cmd).size() > 0) {
            this.logWarning("DROP REPOSITORY", "Known Error: Volumes not dropped");
        }
        session.close();
        TestDatabase reader2 = this.getDatabase();
        reader2.executeDBMcmd("db_offline");
        reader2.executeDBMcmd("db_online");
        session = reader2.connect();
        this.expectSqlError(session, "EXISTS TABLE COLORS", -4004);
    }

    private void testUpdates(Connection session) throws SQLException {
        String testid = "update virtual copy";
        String[] changeCommands = new String[]{"insert into COLORS values ('100', 'rainbow')", "delete from COLORS", "update COLORS set COLORNAME = 'pitch black' where COLORNAME = 'black'"};
        for (int i = 0; i < changeCommands.length; ++i) {
            this.expectSqlOK(session, changeCommands[i]);
        }
        session.rollback();
    }

    private void testImportFromSameSchema(Connection session) throws SQLException {
        String testid = "name collision";
        try {
            tables2.init(session);
            String mainProviderSchema = providerDB.getDBAUser();
            tables2.importSpecificIntoReader(session, this.shareName + "." + mainProviderSchema, "NAMECOLLISION");
        }
        catch (SQLException sqlExc) {
            switch (sqlExc.getErrorCode()) {
                case -4004: {
                    this.logError(testid, "IMPORT with sname schema.tablename still fails");
                    break;
                }
                default: {
                    this.logError(testid, sqlExc.getMessage());
                }
            }
        }
        session.rollback();
    }
}

