/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class Relation {
    protected String name;
    protected List expectedOutput;

    public Relation() {
        this.name = null;
    }

    public Relation(String name_init) {
        this.name = name_init;
    }

    public String getName() {
        return this.name;
    }

    abstract String displayName();

    public String toString() {
        return this.displayName();
    }

    String displayName(List group) {
        String result = this.displayName();
        if (result == null) {
            int groupIndex = group.indexOf(this);
            result = Util.simpleClass(this) + groupIndex;
        }
        return result;
    }

    abstract void init(Connection var1) throws SQLException;

    public void initForExport(Connection session) throws SQLException {
        this.init(session);
        Util.sql(session, "GRANT SELECT ON \"" + this.name + "\" to SHARABLEOBJECTS");
    }

    abstract void drop(Connection var1) throws SQLException;

    abstract String simpleCompare(Connection var1) throws SQLException;

    abstract void showActual(Connection var1) throws SQLException;

    protected String compare(Collection expectedColl, Collection actualColl) {
        String sizeDiff = " [exp: " + expectedColl.size() + "; act: " + actualColl.size() + "]";
        Iterator expected = expectedColl.iterator();
        Iterator actual = actualColl.iterator();
        while (expected.hasNext()) {
            Object expectedRow = expected.next();
            if (!actual.hasNext()) {
                return "DB out of rows at " + expectedRow + sizeDiff;
            }
            Object actualRow = actual.next();
            if (expectedRow.equals(actualRow)) continue;
            return "DIFF: expected: '" + expectedRow + "'\n    vs. actual: '" + actualRow + "'" + sizeDiff;
        }
        if (actual.hasNext()) {
            return "DB additional row " + actual.next() + sizeDiff;
        }
        return null;
    }
}

