/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.AbstractSharedRepositoryCase;
import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.Util;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Random;

public class LobTable
extends Relation {
    int rows = 500;
    static final int initialRun_C = 0;
    static final int updateRun_C = 1;
    static final int updateRun2_C = 2;
    static final int randomSeed_C = 1000;

    public LobTable(String tablename_init) {
        super(tablename_init);
    }

    void init(Connection session) throws SQLException {
        Statement stmt = session.createStatement();
        try {
            stmt.executeUpdate("drop table " + this.name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.executeUpdate("create table " + this.name + " (" + "ID       integer key," + "RUNNO    integer key," + "LOBLEN   integer," + "LOBVAL   long)");
        this.updateTable(session, 0, null);
    }

    void showActual(Connection session) throws SQLException {
    }

    String displayName() {
        return "LobTable " + this.name;
    }

    void drop(Connection session) throws SQLException {
        Util.sql(session, "DROP TABLE " + this.name, -4004);
    }

    String simpleCompare(Connection session) throws SQLException {
        return null;
    }

    boolean updateTable(Connection session, int runNo, AbstractSharedRepositoryCase testCase) throws SQLException {
        PreparedStatement insert = session.prepareStatement("insert into " + this.name + " (ID, RUNNO, LOBLEN, LOBVAL) values (?, ?, ?, ?)");
        PreparedStatement update = session.prepareStatement("update " + this.name + " set RUNNO = ?, LOBLEN = ?, LOBVAL = ? where ID = ?");
        PreparedStatement delete = session.prepareStatement("delete from " + this.name + " where ID = ? and RUNNO = ?");
        RowGenerator rows = new RowGenerator(this.rows, runNo);
        while (rows.hasNext()) {
            Object[] row = (Object[])rows.next();
            Object id = row[1];
            Object run = row[2];
            Object loblength = row[3];
            Object lob = row[4];
            char opcode = ((String)row[0]).charAt(0);
            switch (opcode) {
                case 'i': {
                    if (runNo != 0) break;
                }
                case 'I': {
                    insert.setObject(1, id);
                    insert.setObject(2, run);
                    insert.setObject(3, loblength);
                    insert.setObject(4, lob);
                    try {
                        insert.execute();
                        break;
                    }
                    catch (SQLException insExc) {
                        testCase.logError("insert ID = " + id + " RUNNO = " + run, insExc.toString());
                        return false;
                    }
                }
                case 'U': {
                    update.setObject(1, run);
                    update.setObject(2, loblength);
                    update.setObject(3, lob);
                    update.setObject(4, id);
                    try {
                        update.execute();
                        break;
                    }
                    catch (SQLException updExc) {
                        testCase.logError("update ID = " + id + " RUNNO = " + run, updExc.toString());
                        return false;
                    }
                }
                case 'D': {
                    delete.setObject(1, id);
                    delete.setObject(2, new Integer(0));
                    try {
                        delete.execute();
                        break;
                    }
                    catch (SQLException delExc) {
                        testCase.logError("delete ID = " + id + " RUNNO = " + 0, delExc.toString());
                        return false;
                    }
                }
                default: {
                    testCase.logError("updateTable", "ERR: Invalid opcode: " + opcode);
                }
            }
        }
        return true;
    }

    String compare(Connection session, int runNo) throws SQLException {
        Statement stmt = session.createStatement();
        ResultSet cursor = stmt.executeQuery("select id, runno, loblen, lobval from " + this.name + " order by id, runno");
        RowGenerator rows = new RowGenerator(this.rows, runNo);
        while (cursor.next()) {
            int i;
            Object[] expected = (Object[])rows.next();
            Object[] actual = new Object[expected.length];
            for (i = 1; i < expected.length; ++i) {
                actual[i] = cursor.getObject(i);
            }
            for (i = 1; i < expected.length; ++i) {
                if (expected[i].equals(actual[i])) continue;
                Object id = actual[1];
                Object rno = actual[2];
                return "DIFF: row (" + id + "," + rno + ") at " + i + ": actual = " + actual[i] + " expected = " + expected[i];
            }
        }
        cursor.close();
        return null;
    }

    String compareWithTable(Connection session, String tablename2) throws SQLException {
        Statement stmt1 = session.createStatement();
        ResultSet cursor1 = stmt1.executeQuery("select id, runno, loblen, lobval from " + this.name + " order by id, runno");
        Statement stmt2 = session.createStatement();
        ResultSet cursor2 = stmt2.executeQuery("select id, runno, loblen, lobval from " + tablename2 + " order by id, runno");
        block0: while (true) {
            boolean hasData1 = cursor1.next();
            boolean hasData2 = cursor2.next();
            if (!hasData1 && !hasData2) break;
            if (!hasData1) {
                return "ERR: " + this.name + " is out of data";
            }
            if (!hasData2) {
                return "ERR: " + tablename2 + " is out of data";
            }
            Object id = "unknown";
            int i = 1;
            while (true) {
                if (i > 4) continue block0;
                Object actual = cursor1.getObject(i);
                Object expected = cursor1.getObject(i);
                if (i == 1) {
                    id = actual;
                }
                if (!actual.equals(expected)) {
                    return "DIFF: id: " + id + " actual: " + actual + " expected: " + expected;
                }
                ++i;
            }
            break;
        }
        return null;
    }

    public static void main(String[] args) throws SQLException, ClassNotFoundException {
        int i;
        Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
        Connection session = DriverManager.getConnection("jdbc:sapdb:DB77", "DANIEL", "DANIEL");
        session.setAutoCommit(false);
        String[] tablenames = new String[]{"LOBS_0", "LOBS_1"};
        LobTable[] tables = new LobTable[2];
        for (int i2 = 0; i2 < tablenames.length; ++i2) {
            tables[i2] = new LobTable(tablenames[i2]);
            tables[i2].init(session);
            session.commit();
        }
        String compResult = tables[0].compareWithTable(session, tablenames[1]);
        if (compResult != null) {
            System.out.println(compResult);
            return;
        }
        System.out.println("initial compare OK");
        for (i = 0; i < tablenames.length; ++i) {
            tables[i].updateTable(session, 1, null);
        }
        session.rollback();
        compResult = tables[0].compareWithTable(session, tablenames[1]);
        if (compResult != null) {
            System.out.println(compResult);
            return;
        }
        System.out.println("compare after update and rollback OK");
        for (i = 0; i < tablenames.length; ++i) {
            tables[i].updateTable(session, 1, null);
        }
        session.commit();
        compResult = tables[0].compareWithTable(session, tablenames[1]);
        if (compResult != null) {
            System.out.println(compResult);
            return;
        }
        System.out.println("compare after update and commit OK");
    }

    public static class RowGenerator
    implements Iterator {
        int rowIndex = -1;
        int rows;
        int runNo;
        Integer runNoObject;
        Random generator;

        public RowGenerator(int rows_init, int runNo_init) {
            this.rows = rows_init;
            this.runNo = runNo_init;
            this.runNoObject = new Integer(this.runNo);
            this.generator = new Random(1000L);
        }

        public boolean hasNext() {
            return this.rowIndex + 1 < this.rows;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            String opcode;
            boolean useValue;
            int kb64 = 65536;
            int[] loblengthArray = new int[3];
            do {
                ++this.rowIndex;
                for (int i = 0; i < loblengthArray.length; ++i) {
                    loblengthArray[i] = this.generator.nextInt(65536);
                }
                opcode = "i";
                if (this.runNo != 0) {
                    switch (this.rowIndex % 30) {
                        case 0: {
                            opcode = "I";
                            break;
                        }
                        case 10: {
                            opcode = "U";
                            break;
                        }
                        case 20: {
                            opcode = "D";
                            break;
                        }
                        default: {
                            opcode = "i";
                        }
                    }
                }
                useValue = false;
                switch (this.runNo) {
                    case 0: {
                        useValue = true;
                        break;
                    }
                    case 1: {
                        if (!opcode.equals("i")) {
                            useValue = true;
                        }
                    }
                    case 2: {
                        if (opcode.equals("I")) {
                            opcode = "U";
                        }
                        if (!opcode.equals("U")) break;
                        useValue = true;
                    }
                }
            } while (!useValue);
            int loblength = loblengthArray[this.runNo];
            String lobval = this.genLob(loblength, this.runNo);
            return new Object[]{opcode, new Integer(this.rowIndex), this.runNoObject, new Integer(loblength), lobval};
        }

        String genLob(int length, int runNo) {
            String chunk;
            int chunkSizeC = 16;
            String[] fillers = new String[]{"abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "2BCDEFGHIJKLMNOPQRSTUVWXYZ"};
            String filler = fillers[runNo];
            StringBuffer buf = new StringBuffer();
            for (int pos = 0; pos < length; pos += chunk.length()) {
                String posString = Integer.toString(pos);
                int fillerSize = 16 - posString.length();
                chunk = filler.substring(0, fillerSize) + posString;
                if (length - pos < 16) {
                    chunk = chunk.substring(0, length - pos);
                }
                buf.append(chunk);
            }
            return buf.toString();
        }
    }
}

