/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KernelMessages {
    List lines;
    Iterator lineIterator;

    public KernelMessages(String knlmsgContent) {
        this.lines = Util.split(knlmsgContent, '\n');
        this.lineIterator = this.lines.iterator();
    }

    public Entry nextMessage() {
        boolean dotrace = false;
        Entry result = null;
        while (result == null && this.lineIterator.hasNext()) {
            String message;
            int errorCode;
            String component;
            String kind;
            String line = (String)this.lineIterator.next();
            try {
                kind = line.substring(47, 50);
                component = line.substring(51, 61).trim();
                String errcodeString = line.substring(62, 67);
                try {
                    errorCode = Integer.parseInt(errcodeString);
                }
                catch (NumberFormatException nfExc) {
                    continue;
                }
                message = line.substring(70).trim();
            }
            catch (StringIndexOutOfBoundsException indexExc) {
                continue;
            }
            result = new Entry(kind, component, errorCode, message);
        }
        return result;
    }

    public Entry nextMatch(EntryPattern pattern) {
        Entry current;
        Entry result = null;
        while (result == null && (current = this.nextMessage()) != null) {
            if (!pattern.matches(current)) continue;
            result = current;
        }
        return result;
    }

    public List allMatches(EntryPattern pattern) {
        Entry current;
        ArrayList<Entry> result = new ArrayList<Entry>();
        while ((current = this.nextMatch(pattern)) != null) {
            result.add(current);
        }
        return result;
    }

    public static class EntryPattern
    extends Entry {
        final String wildString;
        final int wildInt = -1;

        public EntryPattern(String kind_init, String component_init, int code_init, String text_init) {
            super(kind_init, component_init, code_init, text_init);
            this.wildString = null;
        }

        public String toString() {
            return "EntryPattern (" + (this.kind == this.wildString ? "*" : this.kind) + ", " + (this.component == this.wildString ? "*" : this.component) + ", " + (this.code == -1 ? "*" : Integer.toString(this.code)) + ", " + (this.text == this.wildString ? "*" : this.text) + ")";
        }

        public boolean matches(Entry other) {
            if (this.kind != this.wildString && !this.kind.equals(other.kind)) {
                return false;
            }
            if (this.component != this.wildString && !this.component.equals(other.component)) {
                return false;
            }
            if (this.code != -1 && this.code != other.code) {
                return false;
            }
            return this.text == this.wildString || this.text.equals(other.text);
        }
    }

    public static class Entry {
        String kind;
        String component;
        int code;
        String text;

        public Entry(String kind_init, String component_init, int code_init, String text_init) {
            this.kind = kind_init;
            this.component = component_init;
            this.code = code_init;
            this.text = text_init;
        }

        public String toString() {
            return "Entry (" + this.kind + ", " + this.component + ", " + this.code + ", " + this.text + ")";
        }
    }
}

