/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.megatenant;

import com.sap.sapdb.megatenant.LobTable;
import com.sap.sapdb.megatenant.Relation;
import com.sap.sapdb.megatenant.Table;
import com.sap.sapdb.megatenant.TableGroup;
import com.sap.sapdb.megatenant.Util;
import com.sap.sapdb.megatenant.View;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriverConfiguration;
import com.sap.sapdb.testframe.testcase.TestCase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractSharedRepositoryCase
extends TestCase {
    protected static TestDatabaseSap providerDB;
    protected String shareName;
    public static final String providerSchema_C = "SHARABLE";
    protected static TableGroup tables;
    protected static TableGroup tables2;
    protected LobTable lobTable = new LobTable("LOBS");

    public AbstractSharedRepositoryCase() throws SQLException, TestDatabaseException {
        Util.setLogger(this);
    }

    protected abstract void runX(Connection var1) throws SQLException, TestDatabaseException;

    public void run() {
        try {
            Connection session = this.getReaderConnection();
            this.runX(session);
            session.close();
        }
        catch (TestDatabaseException tdbExc) {
            this.logException(tdbExc);
        }
        catch (SQLException sqlExc) {
            this.logException(sqlExc);
        }
    }

    Connection getReaderConnection() throws SQLException, TestDatabaseException {
        TestDatabase reader = this.getDatabase();
        Connection session = reader.connect();
        session.setAutoCommit(false);
        return session;
    }

    protected String createProvider(String dbname) throws TestDatabaseException, SQLException {
        if (providerDB != null) {
            return providerDB.getName();
        }
        if (dbname == null) {
            dbname = AbstractSharedRepositoryCase.getParameterString((String)"ProviderDB", (String)"PROVIDER");
        }
        TestDriverConfiguration providerConfig = new TestDriverConfiguration();
        providerConfig.setConfiguration(mTestDriverOptions);
        providerConfig.setConfigValue("DBName", (Object)dbname);
        boolean createNewProviderDB = AbstractSharedRepositoryCase.getParameterBoolean((String)"createProvider", (boolean)true);
        providerConfig.setConfigValue("DBForce", (Object)new Boolean(createNewProviderDB));
        providerDB = this.additionalDatabase(providerConfig, 1);
        if (createNewProviderDB) {
            Connection session = providerDB.connect();
            if (providerSchema_C != null) {
                Util.sql(session, "CREATE SCHEMA SHARABLE");
            }
            tables2.initForExport(session, null);
            tables.initForExport(session, providerSchema_C);
            TableGroup lobTables = new TableGroup(new Relation[]{this.lobTable});
            lobTables.initForExport(session, providerSchema_C);
            session.commit();
            session.close();
            providerDB.executeDBMcmd("db_admin");
            providerDB.executeDBMcmd("db_execute create snapshot");
            providerDB.executeDBMcmd("db_offline");
        }
        return dbname;
    }

    protected String importShare(Connection session, String shareName) throws SQLException, TestDatabaseException {
        String providerName = this.createProvider(null);
        Util.sql(session, Util.fillIn("IMPORT SHARED REPOSITORY '<providerName>' AS <shareName> SNAPSHOT 1", new String[][]{{"providerName", providerName}, {"shareName", shareName}}));
        session.commit();
        return shareName;
    }

    protected String importShare(Connection session) throws SQLException, TestDatabaseException {
        this.shareName = "SHARE1";
        return this.importShare(session, this.shareName);
    }

    protected void dropShare(Connection session) throws SQLException {
        Util.sql(session, Util.fillIn("DROP SHARED REPOSITORY <shareName>", new String[][]{{"shareName", this.shareName}}));
        session.commit();
    }

    void log(String message) {
        System.out.println("INF:" + message);
        this.addMessage(((Object)((Object)this)).getClass().getName(), 'I', message);
    }

    void log(String id, String message) {
        System.out.println("INF:" + message);
        this.addMessage(id, 'I', message);
    }

    void logWarning(String id, String message) {
        System.out.println("WNG:" + id + ":" + message);
        this.addMessage(id, 'W', message);
    }

    void logError(String id, String message) {
        System.out.println("ERR:" + id + ":" + message);
        this.addMessage(id, 'E', message);
    }

    void logError(String message) {
        this.logError(((Object)((Object)this)).getClass().getName(), message);
    }

    void logException(Throwable exc) {
        this.logError(exc.toString());
        String[] backtrace = AbstractSharedRepositoryCase.filterBackTrace(exc);
        for (int i = 0; i < backtrace.length; ++i) {
            System.out.println("" + i + ": " + backtrace[i]);
        }
    }

    private static String[] filterBackTrace(Throwable exc) {
        StackTraceElement[] backtrace = exc.getStackTrace();
        String[] result = new String[backtrace.length];
        int resultIndex = 0;
        boolean inSkipMode = true;
        for (int i = 0; i < backtrace.length; ++i) {
            String entry = backtrace[i].toString();
            if (inSkipMode && entry.startsWith("com.sap.sapdb.megatenant") && !entry.startsWith("com.sap.sapdb.megatenant.Util")) {
                inSkipMode = false;
            }
            if (inSkipMode) continue;
            result[resultIndex] = entry;
            ++resultIndex;
        }
        String[] tmp = new String[resultIndex];
        System.arraycopy(result, 0, tmp, 0, resultIndex);
        return tmp;
    }

    boolean expectSqlError(Connection session, String sqlCmd, int expectedError) {
        boolean gotExpectedError;
        block2: {
            gotExpectedError = true;
            try {
                Util.sql(session, sqlCmd);
                this.logError("SQL OK, expected error " + expectedError);
                gotExpectedError = false;
            }
            catch (SQLException sqlExc) {
                if (sqlExc.getErrorCode() == expectedError) break block2;
                this.logError("SQL Error " + sqlExc.getErrorCode() + ", expected error " + expectedError);
                gotExpectedError = false;
            }
        }
        return gotExpectedError;
    }

    boolean expectSqlOK(Connection session, String sqlCmd) {
        try {
            Util.sql(session, sqlCmd);
            return true;
        }
        catch (SQLException sqlExc) {
            this.logError("SQL Error " + sqlExc.getErrorCode());
            return false;
        }
    }

    boolean expectViewSize(Connection session, String tablename, int expectedSize) throws SQLException {
        boolean result = true;
        String select = "select * from " + tablename;
        int rowcount = Util.select(session, select).size();
        if (rowcount != expectedSize) {
            this.logError("Table " + tablename + ": has " + rowcount + " rows, expected " + expectedSize);
            Util.showActual(session, select);
            result = false;
        }
        return result;
    }

    boolean expectContent(String comment, Connection session, String select, String searchString, int expectedSize) throws SQLException {
        List rows = Util.select(session, select);
        int rowcount = rows.size();
        if (rowcount == 0) {
            this.logError("SELECT " + comment + " is empty");
        }
        if (expectedSize > 0 && rowcount != expectedSize) {
            this.logError("SELECT " + comment + " has " + rowcount + " rows, expected " + expectedSize);
            Util.showActual(session, select);
        }
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            String current = (String)iter.next();
            if (current.indexOf(searchString) == -1) continue;
            return true;
        }
        this.logError("SELECT " + comment + " has no data '" + searchString + "'");
        Util.showActual(session, select);
        return false;
    }

    static void level1() throws Exception {
        throw new Exception("test exception");
    }

    public static void main(String[] args) {
        try {
            AbstractSharedRepositoryCase.level1();
        }
        catch (Throwable exc) {
            String[] backtrace = AbstractSharedRepositoryCase.filterBackTrace(exc);
            for (int i = 0; i < backtrace.length; ++i) {
                if (backtrace[i] == null) continue;
                System.out.println("" + i + ": " + backtrace[i]);
            }
        }
    }

    static {
        tables = new TableGroup(new Relation[]{new Table("COLORS", "COLORID,COLORNAME", new String[]{"00,black", "01,blue", "02,green", "03,yellow", "04,orange", "05,red", "06,violet", "10,white"}), new Table("PRODUCTS", "PRODUCTID,COLORID", new String[]{"01,03", "02,10", "03,05", "04,03", "05,06", "06,02", "07,05", "08,05", "09,00"}), new View("PRODUCTSX", "SELECT PRODUCTID, COLORNAME from COLORS, PRODUCTS where PRODUCTS.COLORID = COLORS.COLORID")});
        tables2 = new TableGroup(new Relation[]{new Table("NAMECOLLISION", "A", new String[]{"1"})});
    }
}

