/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.hotstandby;

import com.sap.sapdb.hotstandby.HotStandbyBasics;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDatabaseSapDevice;
import com.sap.sapdb.testframe.driver.TestDriverConfiguration;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationData;
import com.sap.sapdb.testframe.testcase.VerificationDataSorted;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class HotStandby01
extends HotStandbyBasics {
    protected void workWithMasterInstance() throws TestDatabaseException, SQLException, ClassNotFoundException, InterruptedException {
        TestDatabaseSap masterDB = null;
        masterDB = new TestDatabaseSap(this.mMasterNode, this.mDatabaseName);
        Connection masterConnection = null;
        masterConnection = masterDB.connect(this.mDBAUser, this.mDBAUserPW);
        TestStatement masterStmt = new TestStatement((TestCase)this, masterConnection);
        masterStmt.executeUpdateIgnoreErrors("drop user " + this.mDBUser);
        masterStmt.execute("Create user " + this.mDBUser + " password " + this.mDBUserPW + " resource not exclusive");
        masterConnection.commit();
        masterStmt.close();
        masterConnection.close();
        masterConnection = masterDB.connect(this.mDBUser, this.mDBUserPW);
        masterConnection.setAutoCommit(false);
        masterStmt = new TestStatement((TestCase)this, masterConnection);
        this.currentCmd = "create table mywork (mw01 int, mw02 char(24))";
        masterStmt.execute(this.currentCmd);
        masterConnection.rollback();
        this.currentCmd = "create table mywork (mw01 int, mw02 char(24))";
        masterStmt.execute(this.currentCmd);
        masterConnection.commit();
        this.currentCmd = "drop table mywork";
        masterStmt.execute(this.currentCmd);
        masterConnection.rollback();
        this.currentCmd = "drop table mywork";
        masterStmt.execute(this.currentCmd);
        masterConnection.commit();
        for (int i = 1; i < 100; ++i) {
            this.currentCmd = "create table mywork0" + i + " (mw01 int, mw02 char( " + i * 4 + "))";
            masterStmt.execute(this.currentCmd);
            Thread.sleep(5L);
        }
        masterConnection.rollback();
        this.currentCmd = "create table mydatatab (mdt1 int primary key, mdt2 char(50))";
        masterStmt.execute(this.currentCmd);
        masterConnection.commit();
        String randomString = null;
        Random r = new Random();
        for (int i = 1; i < 100; ++i) {
            randomString = "";
            for (int lz = 0; lz < 41; ++lz) {
                randomString = randomString + "" + Math.abs(r.nextInt() % 10);
            }
            randomString = randomString + Math.abs(r.nextInt() % 1000000);
            this.currentCmd = "insert into mydatatab values (" + i + ", 'c" + randomString + "')";
            masterStmt.execute(this.currentCmd);
        }
        masterConnection.commit();
    }

    protected void takeOverAndCompareData() throws TestDatabaseException, SQLException, ClassNotFoundException, TestCaseException {
        this.releaseDBMConnection();
        ResultSet masterRS = null;
        TestDatabaseSap masterDB = null;
        masterDB = new TestDatabaseSap(this.mMasterNode, this.mDatabaseName);
        Connection masterConnection = null;
        masterConnection = masterDB.connect(this.mDBUser, this.mDBUserPW);
        TestStatement masterStmt = new TestStatement((TestCase)this, masterConnection);
        masterRS = masterStmt.executeQuery("select * from mydatatab");
        VerificationDataSorted Veri = new VerificationDataSorted(masterRS);
        masterRS.close();
        masterStmt.close();
        this.currentCmd = "db_stop";
        this.executeDBMCmdViaName(this.mMasterNode, this.mDatabaseName, this.currentCmd);
        this.releaseDBMConnection();
        this.currentCmd = "util_execute takeover";
        this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, this.currentCmd);
        masterDB = new TestDatabaseSap(this.mStandbyNode[0], this.mDatabaseName);
        masterConnection = null;
        masterConnection = masterDB.connect(this.mDBUser, this.mDBUserPW);
        masterStmt = new TestStatement((TestCase)this, masterConnection);
        masterRS = masterStmt.executeQuery("select * from mydatatab");
        if (!this.checkQuery(masterStmt, (VerificationData)Veri)) {
            throw new TestDatabaseException("compare data... DIFFERENCE!\n" + Veri.getErrorMessage());
        }
    }

    public void run() {
        this.mTraceLevel = 1;
        try {
            this.mStandbyNode[0] = "hs0102";
            this.mStandbyRoot[0] = "/SAP_DB/7404DEV/db";
            this.mLogVolume_Name[0] = "/rel/HotStandby/HP/LOG01M";
            this.mLogVolume_Type[0] = "F";
            this.mLogVolume_Size[0] = 4000;
            this.mDataVolume_Name[0] = "DAT01";
            this.mDataVolume_Type[0] = "F";
            this.mDataVolume_Size[0] = 4000;
            try {
                this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "db_stop");
                this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "db_drop");
                this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "db_clear");
            }
            catch (Exception exp1) {
                // empty catch block
            }
            TestDriverConfiguration myMaster = new TestDriverConfiguration();
            myMaster.setConfigValue("DBName", (Object)this.mDatabaseName);
            myMaster.setConfigValue("DBRoot", (Object)this.mMasterRoot);
            myMaster.setConfigValue("DBHost", (Object)this.mMasterNode);
            myMaster.setConfigValue("DBForce", (Object)Boolean.TRUE);
            myMaster.setConfigValue("DBKeep", (Object)Boolean.TRUE);
            myMaster.setConfigValue("DBDrop", (Object)Boolean.FALSE);
            myMaster.setConfigValue("DBType", (Object)"SAP");
            myMaster.setConfigValue("DBMode", (Object)"fast");
            myMaster.setConfigValue("DBSize", (Object)"SMALL");
            myMaster.setConfigValue("DBKind", (Object)"LVC");
            myMaster.setConfigValue("DBMUser", (Object)this.mDBMUser);
            myMaster.setConfigValue("DBMPwd", (Object)this.mDBMUserPW);
            myMaster.setConfigValue("DBAUser", (Object)this.mDBAUser);
            myMaster.setConfigValue("DBAPwd", (Object)this.mDBAUserPW);
            myMaster.setConfigValue("OSPwd", (Object)"Remuser");
            myMaster.setConfigValue("OSUser", (Object)"remuser");
            myMaster.setConfigValue("DBKeepState", (Object)"OFFLINE");
            myMaster.setConfigValue("TestFrameTrace", (Object)Boolean.TRUE);
            HashMap<String, String> parameterMapMyMaster = new HashMap<String, String>();
            parameterMapMyMaster.put("OFFICIAL_NODE", this.mOfficialNode);
            parameterMapMyMaster.put("HS_NODE_001", this.mMasterNode);
            parameterMapMyMaster.put("HS_NODE_002", this.mStandbyNode[0]);
            myMaster.setDBParameterMap(parameterMapMyMaster);
            ArrayList<TestDatabaseSapDevice> myMasterDevice = new ArrayList<TestDatabaseSapDevice>(4);
            myMasterDevice.add(new TestDatabaseSapDevice("DATA", "DAT01", "F", 1, 4000));
            myMasterDevice.add(new TestDatabaseSapDevice("LOG", this.mLogVolume_Name[0], this.mLogVolume_Type[0], 1, this.mLogVolume_Size[0]));
            myMaster.setDBDeviceList(myMasterDevice);
            TestDatabaseSap myMasterDB = this.additionalDatabase(myMaster, 0);
            this.addMessage("Parameter of the Master", 'I', "List:\n" + myMasterDB.getAllParameter());
            myMasterDB.executeDBMcmd("trace_on DEFAULT");
            myMasterDB.executeDBMcmd("trace_on TOPICCOMMON 5");
            this.mTraceLevel = 3;
            this.currentCmd = "db_create " + this.mDatabaseName + " " + this.mDBMUser + "," + this.mDBMUserPW + " remuser,Remuser";
            this.executeDBMCmdViaRoot(this.mStandbyNode[0], this.mStandbyRoot[0], this.currentCmd);
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_startsession");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_init LVC");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_put HS_NODE_001 " + this.mMasterNode);
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_put HS_NODE_002 " + this.mStandbyNode[0]);
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_put OFFICIAL_NODE " + this.mOfficialNode);
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_put SUPPRESS_CORE NO");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_checkall");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_commitsession");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_addvolume 1 DATA DAT01 F 4000");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "param_addvolume 1 LOG " + this.mLogVolume_Name[0] + " " + this.mLogVolume_Type[0] + " " + this.mLogVolume_Size[0]);
            this.mTraceLevel = 1;
            TestDatabaseSap myHotStandBy = new TestDatabaseSap(this.mStandbyNode[0], this.mDatabaseName);
            this.addMessage("Parameter of the StandBy", 'I', "List:\n" + myHotStandBy.getAllParameter());
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "db_cold");
            System.out.println("Standby is in admin mode");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "util_connect");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "util_execute init standby");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "util_release");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "util_connect");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "util_execute restart standby");
            this.executeDBMCmdViaName(this.mStandbyNode[0], this.mDatabaseName, "util_release");
            System.out.println("standby should be in standby mode\nwait 13 sec...");
            Thread.sleep(13000L);
            this.releaseDBMConnection();
            this.checkDBState(this.mMasterNode, this.mDatabaseName, "online");
            this.releaseDBMConnection();
            this.checkDBState(this.mStandbyNode[0], this.mDatabaseName, "standby");
            System.out.println("Work with the master instance....");
            this.workWithMasterInstance();
            System.out.println("Wait 5 sec...");
            Thread.sleep(5000L);
            this.releaseDBMConnection();
            this.checkDBState(this.mMasterNode, this.mDatabaseName, "online");
            this.releaseDBMConnection();
            this.checkDBState(this.mStandbyNode[0], this.mDatabaseName, "standby");
            System.out.println("Wait 7 sec...");
            Thread.sleep(7000L);
            this.releaseDBMConnection();
            this.checkDBState(this.mMasterNode, this.mDatabaseName, "online");
            this.releaseDBMConnection();
            this.checkDBState(this.mStandbyNode[0], this.mDatabaseName, "standby");
            this.takeOverAndCompareData();
            this.releaseDBMConnection();
            this.checkDBState(this.mMasterNode, this.mDatabaseName, "offline");
            this.releaseDBMConnection();
            this.checkDBState(this.mStandbyNode[0], this.mDatabaseName, "online");
            System.out.println("Wait 5 sec...");
            Thread.sleep(5000L);
            this.releaseDBMConnection();
            this.checkDBState(this.mMasterNode, this.mDatabaseName, "offline");
            this.releaseDBMConnection();
            this.checkDBState(this.mStandbyNode[0], this.mDatabaseName, "online");
            System.out.println("\nTest ends...");
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getClass() + ", " + ex.getLocalizedMessage());
            System.out.println("last cmd was: '" + this.currentCmd + "'");
            this.addMessage(HotStandby01.getTestClassId(), 'E', "Exception: " + ex.getClass() + "\n" + ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    public static String getTestClassId() {
        return "HotStandby01";
    }

    public String getLogFile() {
        return null;
    }
}

