/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.archive;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class ArchiveTest
extends TestCase {
    private static final String mExUser = "ARCHTEST";
    private static final String mExPassword = "ARCHTEST";

    public static String getMinimumRelease() {
        return "7.4.4.2";
    }

    public static void cleanUp() throws TestCaseException {
        System.out.println("End of " + ArchiveTest.getTestClassId());
    }

    public static String getTestClassId() {
        return "ArchiveTest";
    }

    public static void prepare() throws TestCaseException {
        Connection myConnection = null;
        TestStatement myStatement = null;
        TestPreparedStatement myPrepStatement = null;
        System.out.println("Start of " + ArchiveTest.getTestClassId());
        try {
            myConnection = ArchiveTest.getDatabase().connect(ArchiveTest.getUser(), ArchiveTest.getPassword());
            myStatement = new TestStatement(null, myConnection);
            myStatement.enableExceptions(false);
            myStatement.executeUpdate("Drop user ARCHTEST");
            myStatement.enableExceptions(true);
            myStatement.executeUpdate("Create user ARCHTEST password ARCHTEST resource not exclusive");
            myStatement.close();
            myConnection.close();
            Properties myConnectProps = new Properties();
            myConnectProps.setProperty("user", "ARCHTEST");
            myConnectProps.setProperty("password", "ARCHTEST");
            myConnectProps.setProperty("autocommit", "off");
            myConnection = ArchiveTest.getDatabase().connect(myConnectProps);
            myStatement = new TestStatement(null, myConnection);
            myStatement.executeUpdate("Create table ARCHTAB (k0 char(10), k1 int, f0 char(20)) for archive");
            myPrepStatement = new TestPreparedStatement(null, myConnection, "Insert ARCHTAB values (?,?,?)");
            for (int i = 0; i < 10000; ++i) {
                myPrepStatement.setString(1, "Key" + i);
                myPrepStatement.setInt(2, i);
                myPrepStatement.setString(3, "Test" + i);
                myPrepStatement.executeUpdate();
            }
            myPrepStatement.close();
            myConnection.commit();
        }
        catch (Exception e) {
            ArchiveTest.addGlobalMessage((String)"Method prepare", (char)'E', (String)"preparation failed");
            throw new TestCaseException("Error during preparation: " + e.getClass() + e.getMessage());
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myPrepStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection myConnection = null;
        TestStatement myStatement = null;
        boolean v7612 = false;
        try {
            v7612 = TestDriver.compareRelease((String)(((TestDatabaseSap)ArchiveTest.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)ArchiveTest.getDatabase()).getKernelBuild().substring(0, 3)), (String)">=", (String)"7.6.0.12");
        }
        catch (TestDatabaseException e) {
            e.printStackTrace(System.err);
        }
        try {
            boolean wasInterupted;
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                myConnection = ArchiveTest.getDatabase().connect("ARCHTEST", "ARCHTEST");
                                myStatement = new TestStatement((TestCase)this, myConnection);
                                wasInterupted = false;
                                try {
                                    myStatement.executeUpdate("Create table ARCHPRIM (k0 char(10), k1 int, f0 char(20), primary key(k1)) for archive");
                                }
                                catch (DatabaseException dbEx) {
                                    wasInterupted = true;
                                    if (dbEx.getErrorCode() == -7082) break block42;
                                    this.addMessage("createKey", 'E', "should throw '-7082, SQL statement not allowed for this table type', throws: " + (Object)((Object)dbEx), myStatement.getSqlString());
                                }
                            }
                            if (!wasInterupted) {
                                this.addMessage("createKey", 'E', "should throw '-7082, SQL statement not allowed for this table type'", myStatement.getSqlString());
                            }
                            wasInterupted = false;
                            try {
                                myStatement.executeUpdate("delete from ARCHTAB where k1 = 7");
                            }
                            catch (DatabaseException dbEx) {
                                wasInterupted = true;
                                if (dbEx.getErrorCode() == -7082) break block43;
                                this.addMessage("delete Record", 'E', "should throw '-7082, SQL statement not allowed for this table type', throws: " + (Object)((Object)dbEx), myStatement.getSqlString());
                            }
                        }
                        if (!wasInterupted) {
                            this.addMessage("delete Record", 'E', "should throw '-7082, SQL statement not allowed for this table type'", myStatement.getSqlString());
                        }
                        wasInterupted = false;
                        try {
                            myStatement.executeUpdate("update ARCHTAB (k1) Values (27) where k1 = 7");
                        }
                        catch (DatabaseException dbEx) {
                            wasInterupted = true;
                            if (dbEx.getErrorCode() == -7082) break block44;
                            this.addMessage("update Record", 'E', "should throw '-7082, SQL statement not allowed for this table type', throws: " + (Object)((Object)dbEx), myStatement.getSqlString());
                        }
                    }
                    if (!wasInterupted) {
                        this.addMessage("update Record", 'E', "should throw '-7082, SQL statement not allowed for this table type'", myStatement.getSqlString());
                    }
                    wasInterupted = false;
                    try {
                        myStatement.executeUpdate("alter table ARCHTAB ADD (phone_number FIXED (8), street CHAR (15))");
                    }
                    catch (DatabaseException dbEx) {
                        wasInterupted = true;
                        if (dbEx.getErrorCode() == -7082) break block45;
                        this.addMessage("alter table", 'E', "should throw '-7082, SQL statement not allowed for this table type', throws: " + (Object)((Object)dbEx), myStatement.getSqlString());
                    }
                }
                if (!wasInterupted) {
                    this.addMessage("alter table", 'E', "should throw '-7082, SQL statement not allowed for this table type'", myStatement.getSqlString());
                }
                ResultSet rs = null;
                try {
                    myStatement.executeUpdate("force savepoint");
                    rs = myStatement.executeQuery("select numeric_value from dba.tablestatistics where owner='ARCHTEST' and tablename = 'ARCHTAB' and DESCRIPTION = 'Used  pages'");
                }
                catch (DatabaseException dbEx) {
                    // empty catch block
                }
                rs.next();
                int tabSize = rs.getInt(1);
                try {
                    rs = myStatement.executeQuery("select usedsize from sysinfo.datavolumes where lower(path) = 'arch01.dat' and lower(mode) = 'sequential'");
                }
                catch (DatabaseException dbEx) {
                    // empty catch block
                }
                rs.next();
                int volUsed = rs.getInt(1);
                if (v7612) {
                    if (volUsed != (tabSize - 2) * 8) {
                        this.addMessage("table size", 'E', "used space on volume is " + volUsed + "KB, should be: " + (tabSize - 2) * 8 + "KB", myStatement.getSqlString());
                    }
                } else if (volUsed != (tabSize - 2 + 1) * 8) {
                    this.addMessage("table size", 'E', "used space on volume is " + volUsed + "KB, should be: " + (tabSize - 2 + 1) * 8 + "KB", myStatement.getSqlString());
                }
                wasInterupted = false;
                try {
                    myStatement.executeUpdate("drop table ARCHTAB");
                }
                catch (DatabaseException dbEx) {
                    wasInterupted = true;
                    if (dbEx.getErrorCode() == -7082) break block46;
                    this.addMessage("drop table", 'E', "should throw '-7082, SQL statement not allowed for this table type', throws: " + (Object)((Object)dbEx), myStatement.getSqlString());
                }
            }
            if (!wasInterupted) {
                this.addMessage("drop table", 'E', "should throw '-7082, SQL statement not allowed for this table type'", myStatement.getSqlString());
            }
            myConnection.commit();
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                myStatement.close();
            }
            catch (Exception e) {}
            try {
                myConnection.commit();
                myConnection.close();
            }
            catch (Exception e) {}
        }
    }
}

