/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.wisconsin;

import com.sap.sapdb.benchmark.common.BenchmarkAtomicTestinfo;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.Session;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.wisconsin.WiscQueryResult;
import com.sap.sapdb.benchmark.wisconsin.WiscResultException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;

public class WiscSummary
extends StorableObject
implements Comparable {
    private ServerNode serverNode = null;
    private DBDescription dbDescription = null;
    private Date testTime = null;
    private SortedSet mResultSummary = null;

    public WiscSummary(int id, ServerNode serverNode, DBDescription dBDescription, Date testTime, SortedSet mResultSummary) {
        super(id);
        this.serverNode = serverNode;
        this.dbDescription = dBDescription;
        this.testTime = testTime;
        this.mResultSummary = mResultSummary;
    }

    public static WiscSummary loadWiscResult(int id) throws SQLException, WiscResultException {
        ServerNode SN = null;
        DBDescription DBD = null;
        Timestamp TT = null;
        TreeSet<WiscQueryResult> RSum = new TreeSet<WiscQueryResult>();
        Statement stmt = WiscSummary.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("select  servernode_id,  dbdescription_id,  test_time  from  wisc_definitions  where id = " + id);
        if (RS.next()) {
            SN = ServerNode.loadServerNode(RS.getInt("servernode_id"));
            DBD = DBDescription.loadDBDescription(RS.getInt("dbdescription_id"));
            TT = RS.getTimestamp("test_time");
        }
        RS = stmt.executeQuery("select  wrs.query_no,   wrs.stmt_description,   wrs.number_executions ,   avg_rt,   avg_cput,   avg_rio   from  wisc_result_summary wrs,   (select  testrun_id,   query_no,   AVG(run_time) as avg_rt,   AVG(cpu_time) as avg_cput,   AVG(readio) as avg_rio    from  wisc_results   group by testrun_id,   query_no)   t1   where wrs.testrun_id = " + id + " and    t1.query_no    = wrs.query_no  " + " and   t1.testrun_id  = wrs.testrun_id");
        while (RS.next()) {
            RSum.add(WiscQueryResult.loadWiscQueryResult(id, RS.getInt("query_no"), RS.getString("stmt_description"), RS.getInt("number_executions"), RS.getInt("avg_rt"), RS.getInt("avg_cput"), RS.getInt("avg_rio")));
        }
        RS.close();
        stmt.close();
        WiscSummary.getConnection().commit();
        if (SN == null || DBD == null || TT == null || RSum == null) {
            return null;
        }
        return new WiscSummary(id, SN, DBD, TT, RSum);
    }

    public static void deleteSession(int sessionId) throws SQLException {
        Statement stmt = WiscSummary.getConnection().createStatement();
        Statement stmt2 = WiscSummary.getConnection().createStatement();
        Connection conJavatestinfo = DriverManager.getConnection("jdbc:sapdb://PTS/QADB", "TESTER", "TESTER");
        Statement stmtJavatestinfo = conJavatestinfo.createStatement();
        try {
            Session sess = Session.loadSession(sessionId);
            StringBuffer defIdList = null;
            ResultSet RS = stmt.executeQuery("SELECT name FROM sessions, users WHERE sessions.id=" + sess.getId() + " AND sessions.user_id = users.id");
            String user = null;
            if (RS.next()) {
                user = RS.getString("name");
            }
            RS = stmt.executeQuery("SELECT def_id FROM wisc_sessions_results WHERE session_id=" + sess.getId());
            while (RS.next()) {
                if (defIdList == null) {
                    defIdList = new StringBuffer("");
                } else {
                    defIdList.append(',');
                }
                defIdList.append(RS.getString("def_id"));
                ResultSet RS2 = stmt2.executeQuery("SELECT wd.id as id, sn.host_name as host, wd.test_time as starttime  FROM wisc_definitions wd, servernodes sn\t WHERE wd.id = " + RS.getString("def_id") + " AND wd.servernode_id = sn.id");
                BenchmarkAtomicTestinfo oneTestinfo = new BenchmarkAtomicTestinfo(0);
                while (RS2.next()) {
                    oneTestinfo.setTestId(RS2.getInt("id"));
                    oneTestinfo.setHost(RS2.getString("host"));
                    oneTestinfo.setStartTime(RS2.getTimestamp("starttime"));
                    oneTestinfo.setUser(user);
                }
                RS2 = stmt2.executeQuery("SELECT MAX(date_time) as endtime FROM wisc_results WHERE testrun_id = " + RS.getString("def_id"));
                if (RS2.next()) {
                    oneTestinfo.setEndTime(RS2.getTimestamp("endtime"));
                }
                RS2.close();
                stmtJavatestinfo.executeUpdate("INSERT INTO javatestweg (SELECT driverstarted FROM javatestinfo WHERE driverfqhn like '" + oneTestinfo.getHost() + "%' " + "AND testname like '%wisconsin%' " + "AND testuser = '" + oneTestinfo.getUser() + "' " + "AND driverstarted < '" + oneTestinfo.getStartTime() + "' " + "AND driverfinished > '" + oneTestinfo.getEndTime() + "' )");
            }
            RS.close();
            if (defIdList != null) {
                stmt.executeUpdate("DELETE FROM wisc_sessions_results WHERE def_id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM wisc_results WHERE testrun_id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM wisc_definitions WHERE id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM wisc_result_summary WHERE testrun_id IN (" + defIdList.toString() + ")");
            }
            stmt.executeUpdate("DELETE FROM wisc_sessions_results WHERE session_id=" + sess.getId());
            stmt.executeUpdate("DELETE FROM sessions WHERE id=" + sess.getId());
            stmt.close();
            WiscSummary.getConnection().commit();
        }
        catch (SQLException e) {
            stmt.close();
            WiscSummary.getConnection().rollback();
            throw e;
        }
    }

    public static void deleteInvalidTestRunInSession(int sessionId) throws SQLException {
        Statement stmt = WiscSummary.getConnection().createStatement();
        Statement stmt2 = WiscSummary.getConnection().createStatement();
        try {
            Session sess = Session.loadSession(sessionId);
            StringBuffer defIdList = null;
            ResultSet RS = stmt.executeQuery("SELECT def_id FROM wisc_sessions_results WHERE session_id=" + sess.getId());
            while (RS.next()) {
                int howMany;
                ResultSet RS1 = stmt2.executeQuery("SELECT COUNT(*) FROM wisc_result_summary where testrun_id = " + RS.getString("def_id"));
                if (!RS1.next() || (howMany = RS1.getInt("Expression1")) != 0) continue;
                if (defIdList == null) {
                    defIdList = new StringBuffer("");
                } else {
                    defIdList.append(',');
                }
                defIdList.append(RS.getString("def_id"));
            }
            RS.close();
            if (defIdList != null) {
                stmt.executeUpdate("DELETE FROM wisc_sessions_results WHERE def_id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM wisc_results WHERE testrun_id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM wisc_definitions WHERE id IN (" + defIdList.toString() + ")");
                stmt.executeUpdate("DELETE FROM wisc_result_summary WHERE testrun_id IN (" + defIdList.toString() + ")");
            }
            stmt.close();
            WiscSummary.getConnection().commit();
        }
        catch (SQLException e) {
            stmt.close();
            WiscSummary.getConnection().rollback();
            throw e;
        }
    }

    public static SortedSet getSummariesForSession(int sessionID) throws SQLException {
        TreeSet<WiscSummary> res = new TreeSet<WiscSummary>();
        try {
            Statement stmt = WiscSummary.getConnection().createStatement();
            ResultSet RS = stmt.executeQuery("SELECT def_id FROM wisc_sessions_results WHERE session_id =" + sessionID);
            while (RS.next()) {
                WiscSummary lWiscSummary = WiscSummary.loadWiscResult(RS.getInt("def_id"));
                if (lWiscSummary == null) continue;
                res.add(lWiscSummary);
            }
            RS.close();
        }
        catch (WiscResultException wre) {
            System.out.println("Method run Exception: " + wre.getClass() + wre.getMessage());
        }
        return res;
    }

    public Session getRelatedSession() throws SQLException {
        Statement stmt = WiscSummary.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT session_id FROM wisc_sessions_results WHERE def_id=" + this.getId());
        if (RS.next()) {
            int sessionId = RS.getInt("session_id");
            RS.close();
            stmt.close();
            WiscSummary.getConnection().commit();
            return Session.loadSession(sessionId);
        }
        RS.close();
        stmt.close();
        WiscSummary.getConnection().rollback();
        throw new SQLException("Results with id " + this.getId() + " is bound with no session");
    }

    public SortedSet getResultSummary() {
        return this.mResultSummary;
    }

    public ServerNode getServerNode() {
        return this.serverNode;
    }

    public Date getTestTime() {
        return this.testTime;
    }

    public DBDescription getDBDescription() {
        return this.dbDescription;
    }

    public int compareTo(Object obj) {
        if (obj instanceof WiscSummary) {
            WiscSummary ws = (WiscSummary)obj;
            int snC = this.serverNode.compareTo(ws.serverNode);
            if (snC == 0) {
                int ddC = this.dbDescription.compareTo(ws.dbDescription);
                if (ddC == 0) {
                    return this.getId() - ws.getId();
                }
                return ddC;
            }
            return snC;
        }
        return 0;
    }
}

