/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util.starter;

import com.sap.sapdb.benchmark.tp2.util.FtpTransport;
import com.sap.sapdb.benchmark.tp2.util.SimpleXMLHandler;
import com.sap.sapdb.benchmark.tp2.util.starter.HostConfigDialog;
import com.sap.sapdb.benchmark.tp2.util.starter.HostNode;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterEnv;
import com.sap.sapdb.benchmark.tp2.util.starter.StarterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class Host
implements Serializable,
Comparable {
    private static TreeMap hostList = null;
    private String hostName = "";
    private String userName = "";
    private String password = "";
    private SortedSet dirs = null;
    private Host itSelf = this;
    private HostNode hostNode = null;

    public static void loadSavedTransfers() throws StarterException {
        File hosts = StarterEnv.getConfFile("hosts.xml");
        if (hosts.exists()) {
            try {
                new HostConfigHandler().parse(hosts);
            }
            catch (Exception e) {
                throw new StarterException("Problem when loading hosts", e);
            }
        }
    }

    public static void removeHost(String hostName) {
        hostList.remove(hostName);
    }

    public static void addHost(Host host) throws StarterException {
        if (hostList.containsKey(host.getHostName())) {
            throw new StarterException("There is already an Host with this name : " + host.getHostName());
        }
        StarterEnv.getStarterGUI().getStarterTreeModel().addHost(host);
        hostList.put(host.getHostName(), host);
    }

    public static void saveTransfersConfigs() throws StarterException {
        File hosts = StarterEnv.getConfFile("hosts.xml");
        try {
            FileWriter FW = new FileWriter(hosts);
            FW.write("<Hosts>\n");
            Iterator it = hostList.keySet().iterator();
            while (it.hasNext()) {
                FW.write(((Host)hostList.get(it.next())).getConfAsXML());
            }
            FW.write("</Hosts>\n");
            FW.close();
        }
        catch (IOException e) {
            throw new StarterException("Problem when saving hosts in " + hosts, e);
        }
    }

    public static Host getHost(String hostName) {
        return (Host)hostList.get(hostName);
    }

    public static Iterator listHosts() {
        TreeSet<Host> result = new TreeSet<Host>();
        Iterator keys = hostList.keySet().iterator();
        while (keys.hasNext()) {
            result.add(Host.getHost(keys.next().toString()));
        }
        return result.iterator();
    }

    public Host(String hostNameArg, String userName, String password) throws StarterException {
        try {
            InetAddress ipAdd = InetAddress.getByName(hostNameArg);
            this.hostName = ipAdd.getHostName();
            this.userName = userName;
            this.password = password;
            this.dirs = new TreeSet();
            this.hostNode = new HostNode(this);
        }
        catch (UnknownHostException e) {
            throw new StarterException("Host '" + hostNameArg + "' is unknown", e);
        }
        catch (IOException e) {
            throw new StarterException("Cannot connect with FTP to " + this.hostName + " with user '" + userName + "'", e);
        }
    }

    public void addDir(String dir) throws StarterException {
        this.dirs.add(dir);
        this.hostNode.addHostDirNode(dir);
    }

    public void removeDir(String dir) {
        this.dirs.remove(dir);
    }

    public void showConfigDialog() {
        new InternHostConfigDialog();
    }

    public FtpTransport getFtpTransport() throws IOException {
        return new FtpTransport(this.hostName, this.userName, this.password);
    }

    public void putFile(String dir, String file, String fileContent) throws IOException {
        FtpTransport ftpTrans = this.getFtpTransport();
        ftpTrans.put(dir + "/" + file, fileContent);
        ftpTrans.close();
    }

    public String getConfAsXML() {
        StringBuffer res = new StringBuffer("");
        res.append("<Host name=\"" + this.hostName + "\" user=\"" + this.userName + "\" password=\"" + this.password + "\">\n");
        Iterator it = this.dirs.iterator();
        while (it.hasNext()) {
            res.append("\t<Dir path=\"" + it.next() + "\"/>\n");
        }
        res.append("</Host>\n");
        return res.toString();
    }

    public String getHostName() {
        return this.hostName;
    }

    public Iterator listDirs() {
        return this.dirs.iterator();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public String toString() {
        return this.hostName;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Host) {
            return this.hostName.compareTo(((Host)obj).getHostName());
        }
        return 0;
    }

    public HostNode getHostNode() {
        return this.hostNode;
    }

    static {
        hostList = new TreeMap();
    }

    private class InternHostConfigDialog
    extends HostConfigDialog {
        public InternHostConfigDialog() {
            super(Host.this.itSelf);
        }

        protected void save() {
            try {
                Host.this.userName = this.userNameTF.getText();
                Host.this.password = new String(this.passwordTF.getPassword());
                Host.saveTransfersConfigs();
            }
            catch (StarterException e) {
                StarterEnv.throwException(e);
            }
        }
    }

    private static class HostConfigHandler
    extends SimpleXMLHandler {
        private Host currentHost = null;
        private String currentHostName = null;
        private String currentUserName = null;
        private String currentPassword = null;
        private SortedSet currentDirs = null;

        private HostConfigHandler() {
        }

        protected void endTag(String tagName) throws SAXException {
            if (tagName.equals("Host") && this.currentHost != null) {
                Iterator it = this.currentDirs.iterator();
                while (it.hasNext()) {
                    try {
                        this.currentHost.addDir((String)it.next());
                    }
                    catch (StarterException e) {
                        StarterEnv.throwException(e);
                    }
                }
                this.currentHost = null;
            }
        }

        protected void startTag(String tagName, Attributes attr) throws SAXException {
            if (tagName.equals("Host")) {
                this.currentHostName = attr.getValue("name");
                this.currentUserName = attr.getValue("user");
                this.currentPassword = attr.getValue("password");
                this.currentDirs = new TreeSet();
                try {
                    this.currentHost = new Host(this.currentHostName, this.currentUserName, this.currentPassword);
                    Host.addHost(this.currentHost);
                }
                catch (StarterException e) {
                    StarterEnv.throwException(e);
                }
            } else if (tagName.equals("Dir")) {
                this.currentDirs.add(attr.getValue("path"));
            }
        }
    }
}

