/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SimpleXMLHandler
extends DefaultHandler {
    private String tagText = "";
    private int depth = 0;

    protected abstract void startTag(String var1, Attributes var2) throws SAXException;

    protected abstract void endTag(String var1) throws SAXException;

    protected String getTagText() {
        return this.tagText.toString();
    }

    public void parse(File file) throws ParserConfigurationException, SAXException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        this.parse(new InputSource(in));
        in.close();
    }

    public void parse(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(this);
        xmlReader.parse(source);
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        String newStr = new String(ch, start, length);
        if (!newStr.equals("\n")) {
            this.tagText = this.tagText + newStr;
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        this.endTag(qName);
        --this.depth;
    }

    public final void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        ++this.depth;
        this.tagText = "";
        this.startTag(qName, attr);
    }

    public int getDepth() {
        return this.depth;
    }
}

