/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.MutableDBDescProperties;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public abstract class TestDbInit {
    private CaseEnv caseEnv = null;

    protected static void stdOut(Object obj) {
        Tp2Env.stdOut(obj);
    }

    protected static void stdErr(Object obj) {
        Tp2Env.stdErr(obj);
    }

    protected static void stdOut(Object obj, int debug) {
        Tp2Env.stdOut(obj, debug);
    }

    public TestDbInit(CaseEnv caseEnv) throws Tp2Exception {
        this.caseEnv = caseEnv;
    }

    protected abstract void fillTables(Connection var1, int var2) throws Tp2Exception;

    protected abstract void createDbProcedures(Connection var1, int var2) throws Tp2Exception;

    protected abstract void putTestTablesInCache(TestEnv var1, Connection var2) throws Tp2Exception;

    public final void initCaseRun() throws Tp2Exception {
        try {
            int versionInt;
            System.out.println("");
            TestDbInit.stdOut("#");
            TestDbInit.stdOut("### " + this.caseEnv.getBenchmark().getName() + "[TestDbInit] - " + this.caseEnv.getCaseTypeWithId() + " ###");
            TestDbInit.stdOut("#");
            TestDbInit.stdOut("Checks database parameters ...", 10);
            this.caseEnv.checkParams();
            this.getTestDB().stop();
            TestDbInit.stdOut("Database " + this.getTestDB().getState(), 10);
            this.getTestDB().cold();
            TestDbInit.stdOut("Database " + this.getTestDB().getState());
            TestDbInit.stdOut("Activates ...");
            try {
                this.getTestDB().executeDBMcmd("util_execute INIT CONFIG");
                this.getTestDB().executeDBMcmd("util_connect");
                this.getTestDB().executeDBMcmd("util_activate " + this.getTestDB().getDBAUser() + "," + this.getTestDB().getDBAPassword());
                this.getTestDB().executeDBMcmd("util_release");
            }
            catch (Exception e) {
                this.getTestDB().executeDBMcmd("db_activate " + this.getTestDB().getDBAUser() + "," + this.getTestDB().getDBAPassword());
            }
            this.getTestDB().executeDBMcmd("dbm_configset XLOAD 1");
            TestDbInit.stdOut("Loads system tables ...");
            this.getTestDB().executeDBMcmd("load_systab -ud dom");
            TestDbInit.stdOut("Database " + this.getTestDB().getState());
            TestDbInit.stdOut("Creates TP2 user (bench,bench) ...");
            this.createSQLUser();
            try {
                Connection testDBConnection = this.caseEnv.createTestDBConnection();
                TestDbInit.stdOut("Creates and fills tables in test database ...");
                this.createResultsTable(testDBConnection);
                int scaleFactor = Integer.parseInt(this.caseEnv.getProp("tp2.ext.scaleFactor"));
                this.fillTables(testDBConnection, scaleFactor);
                TestDbInit.stdOut("Creates DB Procedures ...");
                this.createDbProcedures(testDBConnection, scaleFactor);
                testDBConnection.close();
            }
            catch (SQLException e) {
                throw new Tp2Exception("Problem with the test DB connection", 3, e);
            }
            this.setDBParameters();
            this.setDBDescProperties();
            TestDbInit.stdOut("Creates media definition for backup ...", 10);
            this.getTestDB().executeDBMcmd("backup_media_put TP2_SV_D tp2Backup FILE DATA 0 8 YES");
            if (this.caseEnv.getTestDB().getInstanceType().equals("LVC") && (versionInt = Integer.parseInt(this.caseEnv.getCompactDBVersion())) < 7300) {
                TestDbInit.stdOut("Call force_and_wait_for_checkpoint for LiveCache. versionInt=" + versionInt, 20);
                this.forceCheckPoint();
            }
            TestDbInit.stdOut("Creating TP2 data backup (id=TP2_SV_D, file=tp2Backup) ...");
            this.getTestDB().executeDBMcmd("util_connect");
            this.getTestDB().executeDBMcmd("backup_save TP2_SV_D DATA");
            this.getTestDB().executeDBMcmd("util_release");
            TestDbInit.stdOut("Save data finished", 10);
            this.getTestDB().stop();
            TestDbInit.stdOut("Database " + this.getTestDB().getState());
            TestDbInit.stdOut("### End of TestDbInit - " + this.caseEnv.getCaseTypeWithId() + " ###\n");
        }
        catch (TestDatabaseException e) {
            throw new Tp2Exception("Unexpected exception in tp2Init() : " + (Object)((Object)e), 3, (Exception)((Object)e));
        }
    }

    private void createSQLUser() throws Tp2Exception {
        try {
            this.getTestDB().executeDBMcmd("sql_connect " + this.getTestDB().getDBAUser() + "," + this.getTestDB().getDBAPassword());
            this.getTestDB().executeDBMcmd("sql_execute create user bench password bench dba not exclusive");
            this.getTestDB().executeDBMcmd("sql_release");
        }
        catch (TestDatabaseException e) {
            throw new Tp2Exception("Could not create TP2 user", 3, (Exception)((Object)e));
        }
    }

    private void createResultsTable(Connection testDBConnection) throws Tp2Exception {
        try {
            Statement stmt = testDBConnection.createStatement();
            try {
                stmt.executeUpdate("DROP TABLE results");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.executeUpdate("CREATE TABLE results ( PROCESS INTEGER KEY, DURATION INTEGER, TCOUNTPU INTEGER, ERRORS INTEGER, TPSPU INTEGER)");
            testDBConnection.commit();
            stmt.close();
            TestDbInit.stdOut("Created results table " + "bench".toUpperCase() + ".RESULTS in test database", 10);
        }
        catch (SQLException e) {
            throw new Tp2Exception("Creation of table 'results' failed", 3, e);
        }
    }

    private void setDBParameters() throws Tp2Exception {
        if (this.caseEnv.isPropSet("tp2.db.DBParameters")) {
            try {
                this.getTestDB().executeDBMcmd("param_startsession");
                StringTokenizer ST1 = new StringTokenizer(this.caseEnv.getProp("tp2.db.DBParameters"), ";");
                TestDbInit.stdOut("Setting case specific DB parameters ...");
                while (ST1.hasMoreTokens()) {
                    String semiColToken = ST1.nextToken();
                    if (semiColToken.indexOf(35) == 0) continue;
                    StringTokenizer ST2 = new StringTokenizer(semiColToken, "=");
                    String paramName = ST2.nextToken();
                    String paramValue = ST2.nextToken();
                    this.getTestDB().executeDBMcmd("param_put " + paramName + " " + paramValue);
                    TestDbInit.stdOut("\t" + paramName + " = " + paramValue);
                }
                this.getTestDB().executeDBMcmd("param_checkall");
                this.getTestDB().executeDBMcmd("param_extgetall");
                this.getTestDB().executeDBMcmd("param_commitsession");
                TestDbInit.stdOut("Case specific DB parameters successfully set");
            }
            catch (TestDatabaseException e) {
                this.caseEnv.executeDBMcmd("param_abortsession");
                throw new Tp2Exception("Initialization of DB parameters given by tp2.db.DBParameters failed (" + this.caseEnv.getProp("tp2.db.DBParameters") + ").", 3, (Exception)((Object)e));
            }
        }
    }

    private void setDBDescProperties() throws Tp2Exception {
        if (this.caseEnv.isPropSet("tp2.db.BooleanDBDescProps")) {
            try {
                StringTokenizer ST1 = new StringTokenizer(this.caseEnv.getProp("tp2.db.BooleanDBDescProps"), ";");
                TestDbInit.stdOut("Setting case specific Boolean DBDescProperties ...");
                while (ST1.hasMoreTokens()) {
                    String semiColToken = ST1.nextToken();
                    if (semiColToken.indexOf(35) == 0) continue;
                    StringTokenizer ST2 = new StringTokenizer(semiColToken, "=");
                    String dbDescPropName = ST2.nextToken();
                    String dbDescPropValue = ST2.nextToken();
                    MutableDBDescProperties.getCommonMutableDBDescProperties().setBooleanProperty(dbDescPropName, new Boolean(dbDescPropValue));
                    TestDbInit.stdOut("\t" + dbDescPropName + " = " + dbDescPropValue);
                }
                TestDbInit.stdOut("Case specific Boolean DBDescProperties successfully set");
            }
            catch (Exception e) {
                throw new Tp2Exception("Initialization of Boolean DBDescProperties given by tp2.db.BooleanDBDescProps failed (" + this.caseEnv.getProp("tp2.db.BooleanDBDescProps") + ").", 3, e);
            }
        }
    }

    private void forceCheckPoint() throws Tp2Exception {
        try {
            this.getTestDB().executeDBMcmd("sql_connect " + this.getTestDB().getDBAUser() + "," + this.getTestDB().getDBAPassword());
            this.getTestDB().executeDBMcmd("sql_execute CALL force_and_wait_for_checkpoint");
            this.getTestDB().executeDBMcmd("sql_release");
        }
        catch (TestDatabaseException e) {
            throw new Tp2Exception("Could force and wait for checkpoint", 3, (Exception)((Object)e));
        }
    }

    private TestDatabaseSap getTestDB() throws Tp2Exception {
        return this.caseEnv.getTestDB();
    }

    public String toString() {
        return "<TestDbInit/>";
    }
}

