/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.test;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.tp2.common.Tp2Exception;
import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import com.sap.sapdb.benchmark.tp2.test.BadResultException;
import com.sap.sapdb.benchmark.tp2.test.CaseEnv;
import com.sap.sapdb.benchmark.tp2.test.SimulatedUser;
import com.sap.sapdb.benchmark.tp2.test.SingleTestId;
import com.sap.sapdb.benchmark.tp2.test.TestEnv;
import com.sap.sapdb.benchmark.tp2.test.TestMonitor;
import com.sap.sapdb.benchmark.tp2.test.Tp2Env;
import com.sap.sapdb.benchmark.tp2.test.Tp2TestCase;
import com.sap.sapdb.benchmark.tp2.util.Tp2Ps;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class SingleTest {
    private static final long WAIT_TIME = 4000L;
    private static SingleTest currentTest = null;
    private long beginReads = -1L;
    private long beginWrites = -1L;
    private long endReads = -1L;
    private long endWrites = -1L;
    private long testBegin = 0L;
    private long testNow = 0L;
    private TestMonitor testMonitor = null;
    private Tp2TestCase relatedTestCase = null;
    private Tp2Ps lastPs = null;

    public static void abort() throws Tp2Exception {
        if (currentTest != null) {
            currentTest.abortTest();
        }
    }

    protected static void stdOut(Object obj) {
        Tp2Env.stdOut(obj);
    }

    protected static void stdErr(Object obj) {
        Tp2Env.stdErr(obj);
    }

    protected static void stdOut(Object obj, int debug) {
        Tp2Env.stdOut(obj, debug);
    }

    public SingleTest(int userCount, int testDuration, CaseEnv caseEnv, Tp2TestCase relatedTestCase) throws Tp2Exception {
        this.relatedTestCase = relatedTestCase;
        if (currentTest != null) {
            currentTest.abort();
        }
        currentTest = this;
        this.testMonitor = new TestMonitor(userCount, testDuration, caseEnv);
    }

    public final Tp2Result runTest() throws Tp2Exception, BadResultException {
        this.preTest();
        SingleTest.stdOut("Starts all simulated users (" + this.testMonitor.getUserCount() + ") :");
        this.getCaseEnv().logInfo("SingleTest.runTest()", "        Starts all simulated users (" + this.testMonitor.getUserCount() + ") :");
        try {
            this.runMultiUser();
        }
        catch (Tp2Exception e) {
            SingleTest.abort();
            currentTest = null;
            throw e;
        }
        return this.postTest();
    }

    public final Tp2Result runTest(int scaleFactor) throws Tp2Exception, BadResultException {
        this.preTest();
        SingleTest.stdOut("Starts all simulated users (" + this.testMonitor.getUserCount() + ") with scaleFactor ");
        this.getCaseEnv().logInfo("SingleTest.runTest()", "        Starts all simulated users (" + this.testMonitor.getUserCount() + ") with scaleFactor: ");
        try {
            this.runMultiUser(scaleFactor);
        }
        catch (Tp2Exception e) {
            SingleTest.abort();
            currentTest = null;
            throw e;
        }
        return this.postTest();
    }

    private void preTest() throws Tp2Exception {
        try {
            int versionInt;
            String outString = "";
            SingleTest.stdOut("#");
            SingleTest.stdOut("### " + this.getCaseEnv().getBenchmark().getName() + "[" + this.testMonitor.getUserCount() + " usr] - " + this.getCaseEnv().getCaseTypeWithId() + " ###");
            SingleTest.stdOut("#");
            outString = outString + "        #\n";
            outString = outString + "        ### " + this.getCaseEnv().getBenchmark().getName() + "[" + this.testMonitor.getUserCount() + " usr] - " + this.getCaseEnv().getCaseTypeWithId() + " ###" + "\n";
            outString = outString + "        #\n";
            SingleTest.stdOut("Access type : " + this.testMonitor.getAccessType().getCodeStr(), 10);
            outString = outString + "        Access type : " + this.testMonitor.getAccessType().getCodeStr() + "\n";
            SingleTest.stdOut("Prepares test DB ...");
            SingleTest.stdOut("Database " + this.getTestDB().getState(), 10);
            outString = outString + "        Prepares test DB ..." + "\n";
            outString = outString + "        Database " + this.getTestDB().getState() + "\n";
            SingleTest.stdOut("Checks database parameters", 10);
            outString = outString + "        Checks database parameters" + "\n";
            this.getCaseEnv().checkParams();
            if (!this.getCaseEnv().getBooleanProp("tp2.db.UseOnlineDB")) {
                long loopBegin = System.currentTimeMillis();
                while (!this.getTestDB().getState().equals("ADMIN") && !this.getTestDB().getState().equals("COLD")) {
                    try {
                        SingleTest.stdOut("Put database in mode ADMIN ...", 10);
                        outString = outString + "        Put database in mode ADMIN ..." + "\n";
                        this.getTestDB().cold();
                    }
                    catch (Exception e) {
                        SingleTest.stdErr(BenchEnv.getCurrentTimeFormatted(true) + " : " + e);
                        try {
                            Thread.currentThread();
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException intE) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - loopBegin <= 3600000L) continue;
                        throw new Tp2Exception("Break the ADMIN loop after " + (System.currentTimeMillis() - loopBegin) + "ms", 3, e);
                    }
                }
            }
            SingleTest.stdOut("Database " + this.getTestDB().getState(), 10);
            outString = outString + "        Database " + this.getTestDB().getState() + "\n";
            if (!this.getCaseEnv().getBooleanProp("tp2.db.UseOnlineDB")) {
                this.getTestDB().executeDBMcmd("util_connect");
                SingleTest.stdOut("Restores data ...", 10);
                outString = outString + "        Restores data ..." + "\n";
                this.getTestDB().executeDBMcmd("backup_restore TP2_SV_D DATA");
                SingleTest.stdOut("Clears log ...", 10);
                outString = outString + "        Clears log ..." + "\n";
                this.getTestDB().executeDBMcmd("util_execute clear log");
            }
            if (this.getCaseEnv().getBooleanProp("tp2.db.logOff") && !this.getCaseEnv().getBooleanProp("tp2.db.UseOnlineDB")) {
                SingleTest.stdOut("Setting 'log devspace/volume off ...'", 10);
                outString = outString + "        Setting 'log devspace/volume off ...'" + "\n";
                this.getTestDB().executeDBMcmd("util_release");
                this.getTestDB().offline();
                this.getTestDB().cold();
                SingleTest.stdOut("Database " + this.getTestDB().getState(), 10);
                outString = outString + "        Database " + this.getTestDB().getState() + "\n";
                this.getTestDB().executeDBMcmd("util_connect");
                this.setLogOff();
                this.testMonitor.setBooleanDBDescProperty("Log OFF", true);
            }
            if (this.getCaseEnv().getBooleanProp("tp2.db.VTraceOn")) {
                SingleTest.stdOut("Setting VTrace On ...", 10);
                outString = outString + "        Setting VTrace On ..." + "\n";
                this.getTestDB().executeDBMcmd("util_release");
                this.getTestDB().offline();
                this.getTestDB().cold();
                SingleTest.stdOut("Database " + this.getTestDB().getState(), 10);
                outString = outString + "        Database " + this.getTestDB().getState() + "\n";
                this.getTestDB().executeDBMcmd("util_connect");
                this.getTestDB().executeDBMcmd("util_execute diagnose vtrace default on");
                this.testMonitor.setBooleanDBDescProperty("VTrace ON", true);
            }
            if (this.getCaseEnv().getBooleanProp("tp2.db.UseOnlineDB") && !this.getTestDB().getState().equals("ONLINE") && !this.getTestDB().getState().equals("WARM")) {
                SingleTest.stdOut("DB_ONLINE ...", 10);
                outString = outString + "        db_online ..." + "\n";
                this.getTestDB().executeDBMcmd("db_online");
            }
            if (!this.getCaseEnv().getBooleanProp("tp2.db.UseOnlineDB")) {
                this.relatedTestCase.justBeforeTestDBOnline();
                SingleTest.stdOut("Restarts ...", 10);
                outString = outString + "        Restarts ..." + "\n";
                this.getTestDB().executeDBMcmd("util_execute restart");
                this.getTestDB().executeDBMcmd("util_release");
            }
            if (!this.getTestDB().getState().equals("ONLINE") && !this.getTestDB().getState().equals("WARM")) {
                throw new Tp2Exception("Database is not ONLINE after restore (in tp2Run())", 2);
            }
            SingleTest.stdOut("Database " + this.getTestDB().getState(), 10);
            outString = outString + "        Database " + this.getTestDB().getState() + "\n";
            if (this.getCaseEnv().getTestDB().getInstanceType().equals("LVC") && (versionInt = Integer.parseInt(this.getCaseEnv().getCompactDBVersion())) < 7300) {
                SingleTest.stdOut("Call 'enable write transaction' for LiveCache. versionInt=" + versionInt, 20);
                outString = outString + "        Call 'enable write transaction' for LiveCache. versionInt=" + versionInt + "\n";
                this.getCaseEnv().executeDBMcmd("sql_execute enable write transaction");
            }
            Connection preTestDBConn = this.getCaseEnv().createTestDBConnection();
            this.testMonitor.initDBDescription(preTestDBConn);
            SingleTest.stdOut("Puts test tables in cache ...", 10);
            outString = outString + "        Puts test tables in cache ..." + "\n";
            this.getCaseEnv().getBenchmark().getTestDbInit().putTestTablesInCache(this.testMonitor, preTestDBConn);
            try {
                SingleTest.stdOut("Resets all ...", 10);
                outString = outString + "        x_cons resets all ..." + "\n";
                this.xCons("reset all");
            }
            catch (Tp2Exception e) {
                SingleTest.stdErr(e);
                this.getCaseEnv().logError("SingleTest.preTest", "Problem with x_cons", e);
            }
            try {
                SingleTest.stdOut("Enables time measures ...", 10);
                outString = outString + "        Enables time measures ..." + "\n";
                this.xCons("time enable");
            }
            catch (Tp2Exception e) {
                SingleTest.stdErr(e);
                this.getCaseEnv().logError("SingleTest.preTest", "Problem with x_cons", e);
            }
            this.relatedTestCase.justBeforeUsersStart(preTestDBConn);
            SingleTest.stdOut("Starts IO measures", 10);
            outString = outString + "        Starts IO measures" + "\n";
            String switchDBAnalyzerOn = this.getCaseEnv().getProp("tp2.test.switchDBAnalyzerOn");
            if (switchDBAnalyzerOn.equalsIgnoreCase("YES")) {
                SingleTest.stdOut("Start DB Analyzer", 10);
                this.getTestDB().executeDBMcmd("dban_start -t 5");
            }
            this.getCaseEnv().logInfo("SingleTest.preTest()", outString);
            this.preMeasure(preTestDBConn);
            if (this.getCaseEnv().getProp("tp2.outputLevel").equals("debug")) {
                SingleTest.stdOut("Set diagnos analyze on", 20);
                this.getTestDB().executeDBMcmd("util_connect");
                this.getTestDB().executeDBMcmd("util_execute diagnose analyze on");
                this.getTestDB().executeDBMcmd("util_release");
            }
            try {
                preTestDBConn.close();
            }
            catch (SQLException e) {
                this.getCaseEnv().logError("SingleTest.runTest", "Could not close pre-test test DB connection", e);
            }
        }
        catch (TestDatabaseException e) {
            currentTest = null;
            throw new Tp2Exception("Exception with the test DB before the simulated users were started", 2, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMultiUser() throws Tp2Exception, BadResultException {
        try {
            this.testMonitor.initTestRun();
            SingleTest.stdOut("Current time : " + BenchEnv.getCurrentTimeFormatted(true));
            this.testMonitor.launchAllUsers();
            long durationAfterNormalEndTime = 0L;
            String waitAfterEndStr = this.getCaseEnv().getProp("tp2.test.waitAfterEnd");
            int index = waitAfterEndStr.indexOf("%");
            if (index < 0) {
                durationAfterNormalEndTime = 1000L * Long.parseLong(waitAfterEndStr);
            } else {
                long percent = Long.parseLong(waitAfterEndStr.substring(0, index));
                durationAfterNormalEndTime = (long)(this.testMonitor.getTestDuration() * 1000) * percent / 100L;
            }
            boolean beforeNormalEndTime = true;
            this.testBegin = System.currentTimeMillis();
            long maxTime = this.testBegin + (long)(this.testMonitor.getTestDuration() * 1000) + durationAfterNormalEndTime;
            boolean testInRunningLoop = true;
            this.lastPs = null;
            String errorMsg = "Some users were in state FINISHED_BAD";
            while (testInRunningLoop) {
                this.testNow = System.currentTimeMillis();
                if (beforeNormalEndTime) {
                    if (BenchEnv.getOutputLevel() > 0) {
                        System.out.print("\r");
                        System.out.print(this.getProgressionBar());
                        System.out.print(this.testCompletionReport());
                    }
                    if (BenchEnv.getOutputLevel() >= 20) {
                        System.out.print(Tp2Env.memoryReport());
                    }
                } else {
                    SingleTest.stdOut(this.testCompletionReport() + Tp2Env.memoryReport());
                    SingleTest.stdOut(this.testMonitor.stateReport());
                    this.eventuallyExecutePs();
                }
                if (this.getTestCompletion() > 100) {
                    if (beforeNormalEndTime) {
                        beforeNormalEndTime = false;
                    }
                    if (this.testMonitor.areAllFinished()) {
                        testInRunningLoop = false;
                        break;
                    }
                } else if (this.getTestCompletion() < 90 && this.testMonitor.areSomeFinished() && Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.noOfExecutions")) == -1) {
                    errorMsg = "Had to interrupt the test : some users are finished before normal duration (" + this.testCompletionReport() + ")";
                    this.testMonitor.abortAllUsers();
                    testInRunningLoop = false;
                    break;
                }
                if (this.testNow > maxTime && !this.testMonitor.areAllFinished()) {
                    errorMsg = "Had to interrupt the test : it ran more than " + this.testCompletionReport();
                    this.testMonitor.abortAllUsers();
                    testInRunningLoop = false;
                    break;
                }
                try {
                    if (this.testMonitor.getTestState() != 3) {
                        testInRunningLoop = false;
                        break;
                    }
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    SingleTest.stdErr(e);
                }
            }
            SingleTest.stdOut("Benchmark loop finished. Global state " + SimulatedUser.convertState(this.testMonitor.getTestState()));
            if (this.testMonitor.getTestState() != 4) {
                String msg = "Test state was not FINISHED_OK at the end of the test (State: " + SimulatedUser.convertState(this.testMonitor.getTestState()) + ")\n" + "CAUSE : " + errorMsg;
                this.getCaseEnv().logError("SingleTest", msg + "\n" + this.testMonitor.badFinishedReport(), null);
                if (!this.testMonitor.areAllFinished()) {
                    this.testMonitor.abortAllUsers();
                }
                throw new BadResultException(msg, this.testMonitor.getSingleTestId());
            }
        }
        finally {
            if (!this.testMonitor.areAllFinished()) {
                this.testMonitor.abortAllUsers();
            }
            if (this.getCaseEnv().getProp("tp2.outputLevel").equalsIgnoreCase("debug")) {
                this.testMonitor.logUserOutput(this.getCaseEnv().getProp("tp2.dataoutputpath"));
            }
        }
    }

    private void runMultiUser(int scaleFactor) throws Tp2Exception, BadResultException {
        this.testMonitor.initTestRun();
        SingleTest.stdOut("Current time : " + BenchEnv.getCurrentTimeFormatted(true));
        this.testMonitor.launchAllUsers(scaleFactor);
        long durationAfterNormalEndTime = 0L;
        String waitAfterEndStr = this.getCaseEnv().getProp("tp2.test.waitAfterEnd");
        int index = waitAfterEndStr.indexOf("%");
        if (index < 0) {
            durationAfterNormalEndTime = 1000L * Long.parseLong(waitAfterEndStr);
        } else {
            long percent = Long.parseLong(waitAfterEndStr.substring(0, index));
            durationAfterNormalEndTime = (long)(this.testMonitor.getTestDuration() * 1000) * percent / 100L;
        }
        boolean beforeNormalEndTime = true;
        this.testBegin = System.currentTimeMillis();
        long maxTime = this.testBegin + (long)(this.testMonitor.getTestDuration() * 1000) + durationAfterNormalEndTime;
        boolean testInRunningLoop = true;
        this.lastPs = null;
        String errorMsg = "Some users were in state FINISHED_BAD";
        while (testInRunningLoop) {
            this.testNow = System.currentTimeMillis();
            if (beforeNormalEndTime) {
                if (BenchEnv.getOutputLevel() > 0) {
                    System.out.print("\r");
                    System.out.print(this.getProgressionBar());
                    System.out.print(this.testCompletionReport());
                }
                if (BenchEnv.getOutputLevel() >= 20) {
                    System.out.print(Tp2Env.memoryReport());
                }
            } else {
                SingleTest.stdOut(this.testCompletionReport() + Tp2Env.memoryReport());
                SingleTest.stdOut(this.testMonitor.stateReport());
                this.eventuallyExecutePs();
            }
            if (this.getTestCompletion() > 100) {
                if (beforeNormalEndTime) {
                    beforeNormalEndTime = false;
                }
                if (this.testMonitor.areAllFinished()) {
                    testInRunningLoop = false;
                    break;
                }
            } else if (this.getTestCompletion() < 90 && this.testMonitor.areSomeFinished() && Integer.parseInt(this.getCaseEnv().getProp("tp2.ext.noOfExecutions")) == -1) {
                errorMsg = "Had to interrupt the test : some users are finished before normal duration (" + this.testCompletionReport() + ")";
                this.testMonitor.abortAllUsers();
                testInRunningLoop = false;
                break;
            }
            if (this.testNow > maxTime && !this.testMonitor.areAllFinished()) {
                errorMsg = "Had to interrupt the test : it ran more than " + this.testCompletionReport();
                this.testMonitor.abortAllUsers();
                testInRunningLoop = false;
                break;
            }
            try {
                if (this.testMonitor.getTestState() != 3) {
                    testInRunningLoop = false;
                    break;
                }
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                SingleTest.stdErr(e);
            }
        }
        SingleTest.stdOut("Benchmark loop finished. Global state " + SimulatedUser.convertState(this.testMonitor.getTestState()));
        if (this.testMonitor.getTestState() != 4) {
            String msg = "Test state was not FINISHED_OK at the end of the test (State: " + SimulatedUser.convertState(this.testMonitor.getTestState()) + ")\n" + "CAUSE : " + errorMsg;
            this.getCaseEnv().logError("SingleTest", msg + "\n" + this.testMonitor.badFinishedReport(), null);
            if (!this.testMonitor.areAllFinished()) {
                this.testMonitor.abortAllUsers();
            }
            throw new BadResultException(msg, this.testMonitor.getSingleTestId());
        }
    }

    private Tp2Result postTest() throws Tp2Exception, BadResultException {
        try {
            Tp2Result result = null;
            Connection postTestDBConn = this.getCaseEnv().createTestDBConnection();
            SingleTest.stdOut("Stops IO measures", 10);
            this.postMeasure(postTestDBConn);
            SingleTest.stdOut("Stores results ...");
            result = this.testMonitor.retrieveAndStoreTestResult(this.endReads - this.beginReads, this.endWrites - this.beginWrites, postTestDBConn);
            SingleTest.stdOut(result);
            this.relatedTestCase.justAfterUsersStopped(postTestDBConn);
            if (this.getCaseEnv().getBooleanProp("tp2.test.stayWarmAndWait")) {
                SingleTest.stdOut("#");
                SingleTest.stdOut("# Because of tp2.test.stayWarmAndWait option the test will block until you press enter");
                SingleTest.stdOut("# Database state is " + this.getTestDB().getState());
                SingleTest.stdOut("#");
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                try {
                    in.readLine();
                }
                catch (IOException e) {
                    SingleTest.stdErr("Problem when waiting for user answer : " + e);
                }
            }
            try {
                postTestDBConn.close();
            }
            catch (SQLException e) {
                this.getCaseEnv().logError("SingleTest.runTest", "Could not close post-test test DB connection", e);
            }
            this.testMonitor.closeTestRun();
            this.getTestDB().offline();
            SingleTest.stdOut("Database " + this.getTestDB().getState(), 10);
            if (this.getCaseEnv().getBooleanProp("tp2.test.executePs") && this.lastPs != null) {
                this.saveCPUTimes(result);
            }
            SingleTest.stdOut("### End of Test[" + this.testMonitor.getUserCount() + " usr] - " + this.getCaseEnv().getCaseTypeWithId() + " ###\n");
            currentTest = null;
            return result;
        }
        catch (TestDatabaseException e) {
            currentTest = null;
            throw new Tp2Exception("Exception with the test DB after the simulated users finished", 2, (Exception)((Object)e));
        }
    }

    private void preMeasure(Connection testDBConn) throws Tp2Exception {
        try {
            Statement stmt = testDBConn.createStatement();
            ResultSet RS = stmt.executeQuery("SELECT SUM(reads) AS sum_reads, SUM(writes) AS sum_writes FROM DOMAIN.SYSMON_IOACCESS");
            if (RS.next()) {
                this.beginReads = RS.getLong("sum_reads");
                this.beginWrites = RS.getLong("sum_writes");
            }
            RS.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw new Tp2Exception("SQL Problem during pre-measure", 2, e);
        }
    }

    private void postMeasure(Connection testDBConn) throws Tp2Exception {
        try {
            Statement stmt = testDBConn.createStatement();
            ResultSet RS = stmt.executeQuery("SELECT SUM(reads) AS sum_reads, SUM(writes) AS sum_writes FROM DOMAIN.SYSMON_IOACCESS");
            if (RS.next()) {
                this.endReads = RS.getLong("sum_reads");
                this.endWrites = RS.getLong("sum_writes");
            }
            RS.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw new Tp2Exception("SQL Problem during post-measure", 2, e);
        }
    }

    private void abortTest() throws Tp2Exception {
        if (!this.testMonitor.areAllFinished()) {
            this.testMonitor.abortAllUsers();
        }
    }

    private String xCons(String command) throws Tp2Exception {
        return this.getCaseEnv().executeDBMcmd("db_cons " + command);
    }

    private void eventuallyExecutePs() throws Tp2Exception {
        block4: {
            if (this.testMonitor.getAccessType().isSystemUser() && this.getCaseEnv().getBooleanProp("tp2.test.executePs") && this.lastPs == null) {
                try {
                    long beginPs = System.currentTimeMillis();
                    SingleTest.stdOut("Calling ps ...");
                    this.lastPs = new Tp2Ps("Tp2Cpc").executePs();
                    SingleTest.stdOut("Users CPU time   : " + this.lastPs.getSimulatedUsersTime());
                    SingleTest.stdOut("Kernel CPU time  : " + this.lastPs.getKernelTime());
                    SingleTest.stdOut("Java CPU time    : " + this.lastPs.getJavaTime());
                    SingleTest.stdOut("Total CPU time   : " + this.lastPs.getTotalTime());
                    long endPs = System.currentTimeMillis();
                    SingleTest.stdOut("Ps took " + (endPs - beginPs) + " ms", 20);
                    Thread.currentThread();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    SingleTest.stdErr(e);
                }
                catch (Tp2Exception e) {
                    if (e.getAbortType() != 0) break block4;
                    this.getCaseEnv().logError("SingleTest.runtTest()", "Execute ps failed", e);
                }
            }
        }
    }

    private void saveCPUTimes(Tp2Result result) {
        try {
            SingleTest.stdOut("Saving CPU times ...");
            Statement stmt = StorableObject.getConnection().createStatement();
            stmt.executeUpdate("INSERT INTO tp2_cputimes SET  def_id=" + result.getId() + "," + " users_time=" + this.lastPs.getSimulatedUsersTime() + "," + " kernel_time=" + this.lastPs.getKernelTime() + "," + " java_time=" + this.lastPs.getJavaTime() + "," + " total_time=" + this.lastPs.getTotalTime());
            stmt.close();
            StorableObject.getConnection().commit();
        }
        catch (SQLException eSQL) {
            eSQL.printStackTrace();
            this.getCaseEnv().logError("SingleTest", "Problem when storing ps results", eSQL);
        }
    }

    private void setLogOff() throws Tp2Exception {
        int versionInt = Integer.parseInt(this.getCaseEnv().getCompactDBVersion());
        if (versionInt >= 7404) {
            try {
                this.getCaseEnv().executeDBMcmd("util_execute set log volume off");
            }
            catch (Tp2Exception e) {
                this.getCaseEnv().executeDBMcmd("util_execute set log writer off");
            }
        } else {
            try {
                this.getCaseEnv().executeDBMcmd("util_execute set log devspace off");
            }
            catch (Tp2Exception e) {
                this.getCaseEnv().executeDBMcmd("util_execute set log writer off");
            }
        }
    }

    public SingleTestId getSingleTestId() {
        return this.testMonitor.getSingleTestId();
    }

    private CaseEnv getCaseEnv() {
        return this.testMonitor.getCaseEnv();
    }

    public TestEnv getTestEnv() {
        return this.testMonitor;
    }

    private TestDatabaseSap getTestDB() throws Tp2Exception {
        return this.getCaseEnv().getTestDB();
    }

    private int getTestCompletion() {
        return (int)((this.testNow - this.testBegin) / (long)(this.testMonitor.getTestDuration() * 10));
    }

    private String getProgressionBar() {
        StringBuffer result = new StringBuffer("");
        result.append("|");
        for (int lastMark = 0; lastMark < 10; ++lastMark) {
            if (lastMark < this.getTestCompletion() / 10) {
                result.append("-");
            } else {
                result.append(" ");
            }
            if (lastMark != 9) continue;
            result.append("|");
        }
        return result.toString();
    }

    private String testCompletionReport() {
        StringBuffer result = new StringBuffer("");
        result.append(" ").append(BenchEnv.formatNbr(this.getTestCompletion())).append("% (").append((this.testNow - this.testBegin) / 1000L).append("s/").append(this.testMonitor.getTestDuration()).append("s)");
        return result.toString();
    }
}

