/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common.where;

import com.sap.sapdb.benchmark.common.where.AtomicFilter;
import com.sap.sapdb.benchmark.common.where.CartesianProductFilter;
import com.sap.sapdb.benchmark.common.where.CompositeFilter;
import com.sap.sapdb.benchmark.common.where.FilterInstance;
import com.sap.sapdb.benchmark.common.where.WhereException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class FilteredView {
    private static int nextId = 0;
    private int id = 0;
    private PreparedStatement preparedStmt = null;
    private Vector atomicFilters = new Vector();
    private CompositeFilter compositeFilter = null;
    private FilterInstance currentFilterInstance = null;
    private boolean executedAtLeastOneTime = false;
    private long duration = 0L;
    static /* synthetic */ Class class$java$lang$String;

    public abstract String getPreparedQuery() throws WhereException;

    protected FilteredView() {
        this.id = nextId++;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.getFilterCount() > 0) {
            this.currentFilterInstance.setPreparedStatementValues(this.preparedStmt);
        }
        long begin = System.currentTimeMillis();
        ResultSet RS = this.preparedStmt.executeQuery();
        long queryDuration = System.currentTimeMillis() - begin;
        this.duration += queryDuration;
        this.executedAtLeastOneTime = true;
        return RS;
    }

    public void prepare(Connection conn) throws SQLException, WhereException {
        if (this.preparedStmt != null) {
            this.preparedStmt.close();
        }
        if (this.compositeFilter == null) {
            this.setCompositeFilter(new CartesianProductFilter());
        }
        this.preparedStmt = conn.prepareStatement(this.getPreparedQuery());
    }

    public String getPreparedWherePart() throws WhereException {
        StringBuffer result = new StringBuffer(" \n( (");
        Iterator it = this.getAtomicFilters().iterator();
        int cnt = 0;
        while (it.hasNext()) {
            AtomicFilter af = (AtomicFilter)it.next();
            if (cnt != 0) {
                result.append(") \nAND (");
            }
            Class[] params = new Class[]{class$java$lang$String == null ? FilteredView.class$("java.lang.String") : class$java$lang$String};
            Object[] args = new Object[]{af.getTableName()};
            try {
                String pwp = (String)af.getFilterClass().getMethod("getClassPreparedWherePart", params).invoke(null, args);
                result.append(pwp);
            }
            catch (Exception e) {
                throw new WhereException("Cannot call 'getClassPreparedWherePart(String)' on AtomicFilter for " + af.getFilterClass(), e);
            }
            ++cnt;
        }
        result.append(") ) ");
        return result.toString();
    }

    public boolean next() {
        if (this.getFilterCount() > 0) {
            boolean hasNext = this.compositeFilter.hasNext();
            if (!hasNext) {
                return hasNext;
            }
            this.currentFilterInstance = this.compositeFilter.nextFilterInstance();
            return hasNext;
        }
        return !this.executedAtLeastOneTime;
    }

    public void addAtomicFilter(AtomicFilter atomicFilter) {
        if (atomicFilter != null) {
            this.atomicFilters.add(atomicFilter);
        }
    }

    public void setCompositeFilter(CompositeFilter compositeFilter) {
        this.compositeFilter = compositeFilter;
        if (this.getFilterCount() > 0) {
            this.compositeFilter.init(this.getAtomicFilters());
        }
        this.duration = 0L;
    }

    public List getAtomicFilters() {
        return this.atomicFilters;
    }

    public int getFilterCount() {
        return this.atomicFilters.size();
    }

    public FilterInstance getCurrentFilterInstance() {
        return this.currentFilterInstance;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getFormattedDuration() {
        if (this.duration / 1000L > 0L) {
            return this.duration / 1000L + "s " + this.duration % 1000L + "ms";
        }
        return this.duration + "ms";
    }
}

