/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.where.WhereProducer;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class StorableObject
implements WhereProducer,
Serializable,
Comparable {
    private static Connection connection = null;
    private static boolean nonPersistent = false;
    private int id;

    public static Connection initConnection(String connectionStr) throws SQLException {
        BenchEnv.stdOut("StorableObject", "### Connecting to results database ... ###");
        long begin = System.currentTimeMillis();
        if (connection != null) {
            connection.close();
        }
        connection = DriverManager.getConnection(connectionStr);
        connection.setAutoCommit(false);
        long duration = System.currentTimeMillis() - begin;
        BenchEnv.stdOut("StorableObject", "### Connection to results database created (" + duration / 1000L + "s " + duration % 1000L + "ms) ###");
        return connection;
    }

    public static void closeConnection() throws SQLException {
        if (connection != null && !connection.isClosed()) {
            connection.close();
            BenchEnv.stdOut("StorableObject", "### Connection to results database closed ###");
        }
    }

    public static boolean isConnectionOpen() throws SQLException {
        if (connection != null) {
            return !connection.isClosed();
        }
        return false;
    }

    public static Connection getConnection() throws SQLException {
        if (!StorableObject.isNonPersistent()) {
            if (connection != null && !connection.isClosed()) {
                return connection;
            }
            return null;
        }
        return null;
    }

    public static boolean isNonPersistent() {
        return nonPersistent;
    }

    public static void setNonPersistent(boolean nonPersistent) {
        StorableObject.nonPersistent = nonPersistent;
    }

    protected StorableObject(int id) {
        this.id = id;
    }

    public String getAsStaticWherePart(String tableName) {
        return tableName + ".id=" + this.getId();
    }

    public static String getClassPreparedWherePart(String table) {
        return table + ".id=? ";
    }

    public String getPreparedWherePart(String table) {
        return StorableObject.getClassPreparedWherePart(table);
    }

    public int setPeparedStatementValues(PreparedStatement pStmt, int relIndex) throws SQLException {
        pStmt.setInt(relIndex, this.getId());
        return relIndex + 1;
    }

    public final int getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorableObject) {
            return this.getId() == ((StorableObject)obj).getId();
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof StorableObject) {
            return this.getId() - ((StorableObject)obj).getId();
        }
        return 0;
    }
}

