/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.CompInt;
import com.sap.sapdb.benchmark.common.DBDescProperties;
import com.sap.sapdb.benchmark.common.DBDescription;
import com.sap.sapdb.benchmark.common.DBParameters;
import com.sap.sapdb.benchmark.common.ServerNode;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.User;
import java.io.File;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class NonPersistent {
    private static SortedMap mainContainer = null;
    private static ServerNode serverNode = null;
    private static String resultsDir = null;
    private static String logDir = null;

    public static void initNonPersistent(String workDir) {
        mainContainer = Collections.synchronizedSortedMap(new TreeMap());
        resultsDir = workDir + File.separator + "NonPersistent" + File.separator + BenchEnv.getCurrentDateFormatted() + File.separator + BenchEnv.getCurrentTimeFormatted(false) + File.separator;
        new File(resultsDir).mkdirs();
        logDir = resultsDir + "log" + File.separator;
        new File(logDir).mkdirs();
    }

    public static void insert(StorableObject obj) throws SQLException {
        SortedMap objContainer;
        String className = obj.getClass().getName();
        if (!mainContainer.containsKey(className)) {
            mainContainer.put(className, Collections.synchronizedSortedMap(new TreeMap()));
        }
        if ((objContainer = (SortedMap)mainContainer.get(className)).containsKey(new CompInt(obj.getId()))) {
            throw new SQLException("There is already an object stored with id " + obj.getId() + " for " + className);
        }
        objContainer.put(new CompInt(obj.getId()), obj);
    }

    public static StorableObject select(Class typeClass, int id) throws SQLException {
        SortedMap objContainer;
        if (mainContainer.containsKey(typeClass.getName()) && (objContainer = (SortedMap)mainContainer.get(typeClass.getName())).containsKey(new CompInt(id))) {
            return (StorableObject)objContainer.get(new CompInt(id));
        }
        throw new SQLException(typeClass.getName() + " with id " + id + " was not found");
    }

    public static void delete(Class typeClass, int id) throws SQLException {
        SortedMap objContainer;
        if (mainContainer.containsKey(typeClass.getName()) && (objContainer = (SortedMap)mainContainer.get(typeClass.getName())).containsKey(new CompInt(id))) {
            objContainer.remove(new CompInt(id));
        }
        throw new SQLException(typeClass.getName() + " with id " + id + " was not found");
    }

    public static Iterator list(Class typeClass) {
        if (mainContainer.containsKey(typeClass.getName())) {
            SortedMap map = (SortedMap)mainContainer.get(typeClass.getName());
            return map.values().iterator();
        }
        return new Vector().iterator();
    }

    public static User selectUser(String userName) {
        if (mainContainer.containsKey(User.class.getName())) {
            SortedMap users = (SortedMap)mainContainer.get(User.class.getName());
            Iterator it = users.values().iterator();
            while (it.hasNext()) {
                User user = (User)it.next();
                if (!user.getName().equals(userName)) continue;
                return user;
            }
        }
        return null;
    }

    public static DBParameters findDBParameters(SortedMap parameters) {
        if (mainContainer.containsKey(DBParameters.class.getName())) {
            Iterator dbpIt = ((SortedMap)mainContainer.get(DBParameters.class.getName())).values().iterator();
            while (dbpIt.hasNext()) {
                boolean same = true;
                DBParameters dbParam = (DBParameters)dbpIt.next();
                SortedMap content = dbParam.getAsSortedMap();
                Iterator keyIt = content.keySet().iterator();
                while (keyIt.hasNext()) {
                    String key = (String)keyIt.next();
                    if (content.get(key).equals(parameters.get(key))) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                return dbParam;
            }
            return null;
        }
        return null;
    }

    public static DBDescription findDBDescription(int major, int minor, int correctionLevel, String build, int dbParamId, DBDescProperties dbDescProp) {
        if (mainContainer.containsKey(DBDescription.class.getName())) {
            Iterator dbpIt = ((SortedMap)mainContainer.get(DBDescription.class.getName())).values().iterator();
            while (dbpIt.hasNext()) {
                boolean same = true;
                DBDescription dbDesc = (DBDescription)dbpIt.next();
                try {
                    if (major != dbDesc.getMajor()) {
                        same = false;
                    }
                    if (same && minor != dbDesc.getMinor()) {
                        same = false;
                    }
                    if (same && correctionLevel != dbDesc.getCorrectionLevel()) {
                        same = false;
                    }
                    if (same && !build.equals(dbDesc.getBuild())) {
                        same = false;
                    }
                    if (same && dbParamId != dbDesc.getDBParameters().getId()) {
                        same = false;
                    }
                    if (same && !dbDescProp.equals(dbDesc.getDBDescProperties())) {
                        same = false;
                    }
                }
                catch (SQLException e) {
                    same = false;
                }
                if (!same) continue;
                return dbDesc;
            }
            return null;
        }
        return null;
    }

    private static SortedMap map(Class typeClass) {
        if (mainContainer.containsKey(typeClass.getName())) {
            return (SortedMap)mainContainer.get(typeClass.getName());
        }
        return null;
    }

    public static int getNextId(Class clss) {
        if (mainContainer.containsKey(clss.getName())) {
            SortedMap sm = (SortedMap)mainContainer.get(clss.getName());
            return ((CompInt)sm.firstKey()).getValue() - 1;
        }
        return -1;
    }

    public static String getResultsDir() {
        return resultsDir;
    }

    public static String getLogDir() {
        return logDir;
    }

    public static ServerNode getServerNode() {
        return serverNode;
    }

    public static void setServerNode(ServerNode serverNode) {
        NonPersistent.serverNode = serverNode;
    }
}

