/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.common;

import com.sap.sapdb.benchmark.common.BenchEnv;
import com.sap.sapdb.benchmark.common.Build;
import com.sap.sapdb.benchmark.common.DBDescProperties;
import com.sap.sapdb.benchmark.common.DBParameters;
import com.sap.sapdb.benchmark.common.NonPersistent;
import com.sap.sapdb.benchmark.common.ShortBuild;
import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.common.Version;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.StringTokenizer;

public class DBDescription
extends StorableObject {
    private int dbParametersId;
    private int maxcpu;
    protected DBParameters dBParameters = null;
    private Build buildObject = null;
    private DBDescProperties dbDescProperties = null;

    public static DBDescription getDBDescription(Connection testDBConn, String kernelBuild, String kernelVersion, DBDescProperties dbDescProp) throws SQLException {
        String build = kernelBuild;
        String version = kernelVersion;
        StringTokenizer ST = new StringTokenizer(version, ".");
        int correctionLevel = -1;
        if (!ST.hasMoreTokens()) {
            throw new SQLException("Version in bad format: " + version);
        }
        int major = Integer.parseInt(ST.nextToken());
        if (!ST.hasMoreTokens()) {
            throw new SQLException("Version in bad format: " + version);
        }
        int minor = Integer.parseInt(ST.nextToken());
        if (!ST.hasMoreTokens()) {
            throw new SQLException("Version in bad format: " + version);
        }
        correctionLevel = Integer.parseInt(ST.nextToken());
        DBParameters dbParam = DBParameters.getDBParameters(testDBConn);
        return DBDescription.getDBDescription(major, minor, correctionLevel, build, dbParam, dbDescProp);
    }

    public static DBDescription getDBDescription(int major, int minor, int correctionLevel, String build, DBParameters dbParam, DBDescProperties dbDescProp) throws SQLException {
        int maxcpu;
        String value = dbParam.getParameter("MAXCPU");
        try {
            maxcpu = Integer.parseInt(value);
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer(value);
            int curVal = 0;
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (!Character.isDigit(c)) continue;
                curVal = curVal * 10 + Character.digit(c, 10);
            }
            maxcpu = curVal;
        }
        if (!DBDescription.isNonPersistent()) {
            Statement stmt = DBDescription.getConnection().createStatement();
            String selectSql = "SELECT id  FROM  dbdescriptions dbdesc WHERE  dbdesc.major=" + major + " AND " + " dbdesc.minor=" + minor + " AND " + " dbdesc.correction_level=" + correctionLevel + " AND " + " dbdesc.build='" + build + "' AND " + " dbdesc.dbparameters_id=" + dbParam.getId();
            ResultSet RS = stmt.executeQuery(selectSql);
            int id = -1;
            while (RS.next()) {
                int currId = RS.getInt("id");
                if (!DBDescProperties.getDBDescProperties(currId).equals(dbDescProp)) continue;
                id = currId;
                break;
            }
            if (id == -1) {
                CallableStatement call = DBDescription.getConnection().prepareCall("SELECT dbdescriptions_seq.NEXTVAL INTO :nextval FROM DUAL");
                call.registerOutParameter(1, 4);
                call.execute();
                id = call.getInt(1);
                stmt.executeUpdate("INSERT INTO dbdescriptions SET id=" + id + "," + "major=" + major + "," + "minor=" + minor + "," + "correction_level=" + correctionLevel + "," + "build='" + build + "'," + "maxcpu='" + dbParam.getParameter("MAXCPU") + "'," + "dbparameters_id=" + dbParam.getId());
                Iterator it = dbDescProp.listSetBooleanProperties();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    stmt.executeUpdate("INSERT INTO dbdesc_boolean_prop_lnk SET  dbdesc_id=" + id + "," + " prop_id=" + DBDescProperties.getBooleanPropertyId(name));
                }
            }
            RS.close();
            stmt.close();
            DBDescription.getConnection().commit();
            return new DBDescription(id, major, minor, correctionLevel, build, dbParam.getId(), maxcpu);
        }
        DBDescription result = NonPersistent.findDBDescription(major, minor, correctionLevel, build, dbParam.getId(), dbDescProp);
        if (result == null) {
            DBDescription dbDesc = new DBDescription(NonPersistent.getNextId(DBDescription.class), major, minor, correctionLevel, build, dbParam.getId(), maxcpu, dbDescProp);
            NonPersistent.insert(dbDesc);
            return dbDesc;
        }
        return result;
    }

    public static DBDescription loadDBDescription(int id) throws SQLException {
        Statement stmt = DBDescription.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("SELECT major,minor,correction_level,build,dbparameters_id,maxcpu  FROM dbdescriptions WHERE id=" + id);
        if (RS.next()) {
            int major = RS.getInt("major");
            int minor = RS.getInt("minor");
            int correctionLevel = RS.getInt("correction_level");
            String build = RS.getString("build");
            int dbParametersId = RS.getInt("dbparameters_id");
            int maxcpu = RS.getInt("maxcpu");
            RS.close();
            stmt.close();
            DBDescription.getConnection().commit();
            return new DBDescription(id, major, minor, correctionLevel, build, dbParametersId, maxcpu);
        }
        RS.close();
        stmt.close();
        DBDescription.getConnection().rollback();
        return null;
    }

    public DBDescription(int id, int major, int minor, int correctionLevel, String build, int dbParametersId, int maxcpu) {
        super(id);
        this.dbParametersId = dbParametersId;
        this.maxcpu = maxcpu;
        this.buildObject = new Build(new Version(major, minor, correctionLevel), build);
    }

    public DBDescription(int id, int major, int minor, int correctionLevel, String build, int dbParametersId, int maxcpu, DBDescProperties dbDescProperties) {
        super(id);
        this.dbParametersId = dbParametersId;
        this.maxcpu = maxcpu;
        this.buildObject = new Build(new Version(major, minor, correctionLevel), build);
        this.dbDescProperties = dbDescProperties;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBDescription) {
            return this.getId() == ((DBDescription)obj).getId();
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof DBDescription) {
            DBDescription dbDesc = (DBDescription)obj;
            int buildComp = this.getBuildObject().compareTo(dbDesc.getBuildObject());
            if (buildComp != 0) {
                return buildComp;
            }
            if (this.maxcpu != dbDesc.getMAXCPU()) {
                return this.maxcpu - dbDesc.getMAXCPU();
            }
            return this.getId() - dbDesc.getId();
        }
        return 0;
    }

    public String toString() {
        return this.getBuildObject().toString() + "#" + this.getId();
    }

    public int getMajor() {
        return this.buildObject.getVersion().getMajor();
    }

    public int getMinor() {
        return this.buildObject.getVersion().getMinor();
    }

    public int getCorrectionLevel() {
        return this.buildObject.getVersion().getCorrectionLevel();
    }

    public String getCorrectionLevelStr() {
        return BenchEnv.formatNbr(this.getCorrectionLevel());
    }

    public Version getVersionObject() {
        return this.buildObject.getVersion();
    }

    public String getVersion() {
        return this.getVersionObject().toString();
    }

    public String getVersionWithShortBuild() {
        return this.getShortBuildObject().toString();
    }

    public String getBuildObjectWithIdAndMAXCPU() {
        return this.getBuildObject() + "#" + this.getId() + "[" + this.maxcpu + "]";
    }

    public String getShortBuildStr() {
        return this.getShortBuildObject().getShortBuildAsString();
    }

    public int getShortBuild() {
        return this.getShortBuildObject().getShortBuildAsInt();
    }

    public ShortBuild getShortBuildObject() {
        return this.buildObject.getShortBuild();
    }

    public String getBuild() {
        return this.buildObject.getBuildAsString();
    }

    public Build getBuildObject() {
        return this.buildObject;
    }

    public int getMAXCPU() {
        return this.maxcpu;
    }

    public DBParameters getDBParameters() throws SQLException {
        if (this.dBParameters == null) {
            this.dBParameters = DBParameters.loadDBParameters(this.dbParametersId);
        }
        return this.dBParameters;
    }

    public DBDescProperties getDBDescProperties() throws SQLException {
        if (this.dbDescProperties == null) {
            this.dbDescProperties = DBDescProperties.getDBDescProperties(this.getId());
        }
        return this.dbDescProperties;
    }
}

