/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtechtest.util.options;

import com.sap.dbtechtest.util.options.OptionDesc;
import java.io.PrintStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Options {
    protected OptionDesc[] desc;
    protected String helpString;
    protected Dictionary values = new Hashtable();
    protected Vector extraOptions;
    protected String[] args;
    protected static final String[] helpOptions = new String[]{"-?", "-h", "--help"};
    public static final int parseFailedC = 0;
    public static final int helpOptionFoundC = 1;
    public static final int parseSucceededC = 2;

    public Options(OptionDesc[] optionDescArray, String string) {
        this.desc = optionDescArray;
        this.helpString = string;
        if (optionDescArray != null) {
            for (int i = 0; i < optionDescArray.length; ++i) {
                OptionDesc optionDesc = optionDescArray[i];
                this.values.put(optionDesc.getName(), optionDesc.getDefault());
            }
        }
    }

    public int parse(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            String string;
            String string2;
            String string3 = stringArray[n];
            if (string3.equals("--")) {
                ++n;
                break;
            }
            if (string3.charAt(0) != '-') break;
            int n2 = string3.indexOf(58);
            if (n2 > 0) {
                string2 = string3.substring(0, n2);
                string = string3.substring(n2 + 1);
            } else {
                string2 = string3;
                string = "";
            }
            boolean bl = false;
            for (int i = 0; i < this.desc.length && !bl; ++i) {
                bl = this.desc[i].hasMatchingOption(string2);
                if (!bl) continue;
                this.desc[i].setOptionValue(this, string);
            }
            if (bl) continue;
            System.out.println("invalid option");
            return this.invalidOption(string2);
        }
        this.args = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, this.args, 0, stringArray.length - n);
        return 2;
    }

    public void help(PrintStream printStream) {
        if (this.helpString != null) {
            printStream.println(this.helpString);
        }
        printStream.println("Usage: java -cp <jdbc-driver-jar>;sapdbctest.jar <test class> [option:<value>]");
        printStream.println("possible options:");
        for (int i = 0; i < this.desc.length; ++i) {
            this.desc[i].help(printStream);
        }
        System.exit(1);
    }

    public int invalidOption(String string) {
        int n = 0;
        for (int i = 0; i < helpOptions.length; ++i) {
            if (!helpOptions[i].equals(string)) continue;
            n = 1;
        }
        if (n == 0) {
            System.err.println("invalid option: " + string);
        }
        this.help(System.err);
        return n;
    }

    public String[] getArgs() {
        return this.args;
    }

    public Object get(String string) {
        Object v = this.values.get(string);
        return v;
    }

    void set(String string, Object object) {
        this.values.put(string, object);
    }

    public boolean getBoolean(String string) {
        Boolean bl = (Boolean)this.values.get(string);
        boolean bl2 = bl;
        return bl2;
    }

    public int getInt(String string) {
        Integer n = (Integer)this.values.get(string);
        return n;
    }

    public String getString(String string) {
        String string2 = (String)this.values.get(string);
        return string2;
    }

    public String getEnum(String string, String[] stringArray) {
        String string2 = this.getString(string);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("arg to --subtest must be one of [");
            stringBuffer.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append("]");
            System.err.println(stringBuffer.toString());
        }
        return string2;
    }

    public Vector getVector(String string) {
        Vector vector = (Vector)this.values.get(string);
        return vector;
    }

    public Dictionary getVariables(String string) {
        Dictionary dictionary = (Dictionary)this.values.get(string);
        return dictionary;
    }

    public void dump() {
        int n;
        for (n = 0; n < this.desc.length; ++n) {
            this.desc[n].dump(this);
        }
        if (this.args != null) {
            for (n = 0; n < this.args.length; ++n) {
                System.out.println(this.args[n]);
            }
        }
    }

    public void addExtraOption(OptionDesc optionDesc) {
        if (this.extraOptions == null) {
            this.extraOptions = new Vector();
        }
        this.values.put(optionDesc.getName(), optionDesc.getDefault());
        this.extraOptions.add(optionDesc.getName());
    }

    public void addExtraOptions(OptionDesc[] optionDescArray) {
        for (int i = 0; i < optionDescArray.length; ++i) {
            this.addExtraOption(optionDescArray[i]);
        }
    }

    public void clearExtraOptions() {
        if (this.extraOptions != null) {
            Enumeration enumeration = this.extraOptions.elements();
            while (enumeration.hasMoreElements()) {
                this.values.remove(enumeration.nextElement());
            }
        }
    }
}

